/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.ByteColumn;
import db.Column;
import db.HashTablePool;
import db.IdbVector;
import db.IntegerColumn;
import db.Journal;
import db.SQLProg;
import db.StringColumn;
import db.Table;
import db.TableEncrypt;
import db.Trace;
import db.Transaction;
import db.TypeInfo;
import db.indexTable;
import db.sqltoken;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Database
implements Runnable {
    String \u011a;
    Properties \u011b;
    int \u011c = 1;
    String \u011d;
    String \u011e;
    String \u011f;
    String \u0120;
    int \u0121;
    IdbVector \u0122;
    boolean \u0123;
    boolean \u0124;
    int \u0125;
    String \u0126;
    String \u0127;
    Thread \u0128;
    Vector \u0129;
    long \u012a;
    Table \u012b;
    Table \u012c;
    Table \u012d;
    Vector \u012e;
    String \u012f;
    String \u0130;
    String \u0131;
    String \u0132;
    char \u0133;
    int \u0134;
    int \u0135;
    float \u0136;
    int \u0137;
    int \u0138;
    PrintWriter \u0139;
    int \u013a;
    int \u013b;
    boolean \u013c;
    boolean \u013d;
    int \u013e;
    boolean \u00ea;
    boolean \u013f;
    boolean \u0140;
    boolean \u0141;
    boolean \u0142;
    int \u0143;
    boolean \u0144;
    boolean \u0145;
    boolean \u0146;
    Vector \u0147;
    Vector \u0148;
    Vector \u0149;
    Transaction \u014a;
    Journal \u014b;
    boolean doRecovery;
    String \u014c = "";
    String \u014d = "";
    static sqltoken \u014e;
    static Vector \u014f;
    static boolean \u0150;
    public static final int TABLE_NAME_MAX = 64;
    public static final int PATH_NAME_MAX = 256;
    public static final int COLUMN_NAME_MAX = 64;
    public static final int MAJOR_VERSION = 3;
    public static final int MINOR_VERSION = 13;
    public static final int BETA_VERSION = 0;
    public static final int CACHE_DEFAULT = 0;
    public static final int CACHE_ROWS = 1;
    public static final int CACHE_PERCENT = 2;
    public static final String nullString = "NULL";

    public Database(String string) throws SQLException {
        this.\u0127 = string;
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("java.vendor");
        if (string2.indexOf("Microsoft") != -1) {
            this.\u0146 = true;
        }
    }

    void \u011a() {
        IntegerColumn integerColumn = new IntegerColumn(this.\u012c, "ColID");
        integerColumn.\u00e9(1, true);
        integerColumn.\u00e9(5, true);
        integerColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.\u012c, "TableId");
        integerColumn.setCacheCondition(2, 100);
        StringColumn stringColumn = new StringColumn(this.\u012c, "ColName", 64);
        stringColumn.setCacheCondition(2, 100);
        stringColumn = new StringColumn(this.\u012c, "Flags", 64);
        stringColumn.setCacheCondition(2, 100);
        ByteColumn byteColumn = new ByteColumn(this.\u012c, "Type");
        byteColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.\u012c, "Offset");
        integerColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.\u012c, "Length");
        integerColumn.setCacheCondition(2, 100);
        byteColumn = new ByteColumn(this.\u012c, "CacheCond");
        byteColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.\u012c, "CacheAmnt");
        integerColumn.setCacheCondition(2, 100);
        stringColumn = new StringColumn(this.\u012c, "ColDefault", 64);
        stringColumn.setCacheCondition(2, 100);
    }

    public static void addDatabase(Database database) {
        Vector vector = \u014f;
        synchronized (vector) {
            \u014f.addElement(database);
        }
    }

    synchronized void \u011b(Table table) {
        this.\u012e.addElement(table);
    }

    public void addToTimerQueue(Transaction transaction, int n) {
        if (n == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        transaction.\u02bb = l += (long)(n * 1000);
        Vector vector = this.\u0129;
        synchronized (vector) {
            int n2 = this.\u0129.size();
            if (n2 == 0) {
                this.\u0129.addElement(transaction);
            } else {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    Transaction transaction2 = (Transaction)this.\u0129.elementAt(n3);
                    if (l >= transaction2.\u02bb) {
                        if (n3 == n2 - 1) {
                            this.\u0129.addElement(transaction);
                            break;
                        }
                        this.\u0129.insertElementAt(transaction, n3 + 1);
                        break;
                    }
                    --n3;
                }
            }
        }
    }

    void \u011c() {
        if (this.\u0124) {
            throw new SQLException("Database has been closed");
        }
        if (\u0150) {
            throw new SQLException("Shutdown is in progress");
        }
    }

    public synchronized void close() throws SQLException {
        if (Trace.traceIt(1)) {
            Trace.traceOut("Closing database " + this.\u011a + " opens=" + this.\u0125);
        }
        this.close(false);
    }

    public void close(boolean bl) throws SQLException {
        if (!this.\u0123) {
            return;
        }
        --this.\u0125;
        if (this.\u0125 > 0) {
            Trace.close();
            return;
        }
        if (!bl) {
            this.\u014b.\u01b8();
        }
        int n = 0;
        while (n < this.\u012e.size()) {
            Table table = (Table)this.\u012e.elementAt(n);
            try {
                if (table.\u0264 == 3) {
                    table.dropTable(null);
                } else {
                    table.close(bl);
                }
            }
            catch (Exception exception) {
                System.out.println("Error closing table " + table.\u0193 + "\n" + exception);
                exception.printStackTrace();
            }
            ++n;
        }
        this.\u011a = null;
        this.\u012b = null;
        this.\u012c = null;
        this.\u012d = null;
        this.\u012e = null;
        this.\u011b = null;
        this.\u0139 = null;
        this.\u0147 = null;
        this.\u0148 = null;
        this.\u0129 = null;
        this.\u0128.interrupt();
        this.\u0149 = null;
        this.\u011c = 1;
        this.\u0123 = false;
        this.\u0124 = true;
        Trace.close();
        this.\u014b.\u01b7();
        Database.removeDatabase(this);
    }

    void \u011d(String string) {
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new SQLException("Cannot create directory: " + string, "XOPEN");
        }
    }

    public Transaction dbCreate(String string, String string2, Transaction transaction) throws SQLException {
        this.\u012b = new Table(String.valueOf(this.\u011a) + "$db$Tables", this, transaction, -1);
        IntegerColumn integerColumn = new IntegerColumn(this.\u012b, "TableID");
        integerColumn.\u00e9(1, true);
        integerColumn.\u00e9(5, true);
        integerColumn.setCacheCondition(2, 100);
        StringColumn stringColumn = new StringColumn(this.\u012b, "TableName", 64);
        stringColumn.\u00e9(2, true);
        stringColumn.setCacheCondition(2, 100);
        stringColumn = new StringColumn(this.\u012b, "Path", 256);
        stringColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.\u012b, "RecLen");
        integerColumn.setCacheCondition(2, 100);
        ByteColumn byteColumn = new ByteColumn(this.\u012b, "Type");
        byteColumn.setCacheCondition(2, 100);
        try {
            this.\u012b.\u0253(transaction, true);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
        this.\u012c = new Table(String.valueOf(this.\u011a) + "$db$Cols", this, transaction, -1);
        this.\u011a();
        try {
            this.\u012c.\u0253(transaction, true);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
        this.\u012b.\u0262(transaction);
        indexTable indexTable2 = (indexTable)this.getTable(String.valueOf(this.\u011a) + "$db$Tables$pKey");
        indexTable2.\u0262(transaction);
        this.\u012d = new Table(String.valueOf(this.\u011a) + "$db$Indexes", this, transaction, -1);
        integerColumn = new IntegerColumn(this.\u012d, "TableID");
        integerColumn.setCacheCondition(2, 100);
        integerColumn = new IntegerColumn(this.\u012d, "ColID");
        integerColumn.setCacheCondition(2, 100);
        try {
            this.\u012d.\u0253(transaction, true);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
        indexTable2.\u01ab(transaction);
        indexTable2 = (indexTable)this.getTable(String.valueOf(this.\u011a) + "$db$Cols$pKey");
        indexTable2.\u01ab(transaction);
        new TypeInfo(this, transaction);
        return transaction;
    }

    public synchronized Transaction dbOpen(String string, String string2, String string3) throws SQLException {
        Object object;
        int n;
        Object object2;
        Object object3;
        Serializable serializable;
        int n2;
        this.\u011c();
        if (!this.\u0123) {
            this.\u0126(string);
        }
        if (Trace.traceIt(1)) {
            Trace.traceOut("Opening database " + string + " opens=" + this.\u0125);
        }
        this.\u0130();
        if (this.\u0123) {
            ++this.\u0125;
            return new Transaction(this);
        }
        String string4 = this.\u011d;
        if (this.\u0120 != null) {
            this.\u011d = this.\u0120;
        }
        if (!this.\u0123) {
            this.\u014a = new Transaction(this);
        }
        Transaction transaction = new Transaction(this);
        this.\u012c = new Table(null, this, transaction, -1);
        this.\u011a();
        try {
            n2 = this.\u012c.\u0260(String.valueOf(this.\u011a) + "$db$Cols");
            if (n2 == 0) {
                n2 = this.\u012c.\u0260(String.valueOf(this.\u011a) + "$db$Columns");
            }
            if (n2 == 0) {
                this.\u012c = null;
                this.dbCreate(string, string3, transaction);
                transaction.commit(transaction.\u02b8);
                this.\u011d = string4;
                this.\u0123 = true;
                ++this.\u0125;
                return transaction;
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString());
        }
        this.\u012c.\u0263 = new Integer(1000);
        n2 = 1;
        while (n2 <= this.\u012c.\u01f5) {
            if (this.\u012c.rowDeleted(n2)) {
                throw new SQLException("Internal error - column table columns missing");
            }
            serializable = (Integer)this.\u012c.getColByRow("TableId", n2);
            if (!((Integer)serializable).equals(this.\u012c.\u0263)) break;
            object3 = (String)this.\u012c.getColByRow("ColName", n2);
            Integer n3 = (Integer)this.\u012c.getColByRow("ColID", n2);
            object2 = this.\u012c.getColByName((String)object3);
            ((Column)object2).\u00f0 = n3;
            ++n2;
        }
        serializable = null;
        object3 = new IdbVector(this.\u012c);
        serializable = new Hashtable(200, 0.6f);
        int n4 = 1;
        while (n4 <= this.\u012c.\u01f5) {
            if (!this.\u012c.rowDeleted(n4)) {
                this.\u012c.getRow(n4, (Vector)object3);
                object2 = ((IdbVector)object3).getIntegerAt(2);
                Vector<Object> vector = (Vector<Object>)((Hashtable)serializable).get(object2);
                n = ((IdbVector)object3).getIntAt(6);
                object = new int[]{n4, n};
                if (vector == null) {
                    vector = new Vector<Object>(20, 20);
                    vector.addElement(object);
                    ((Hashtable)serializable).put(object2, vector);
                } else {
                    boolean bl = false;
                    int n5 = vector.size() - 1;
                    while (n5 >= 0) {
                        int[] nArray = (int[])vector.elementAt(n5);
                        if (n > nArray[1]) {
                            vector.ensureCapacity(vector.size() + 1);
                            vector.insertElementAt(object, n5 + 1);
                            bl = true;
                            break;
                        }
                        --n5;
                    }
                    if (!bl) {
                        vector.insertElementAt(object, 0);
                    }
                }
            }
            ++n4;
        }
        this.\u012b = new Table(null, this.\u012c, String.valueOf(this.\u011a) + "$db$Tables", (Hashtable)serializable);
        object2 = new IdbVector(this.\u012b);
        int n6 = 1;
        while (n6 <= this.\u012b.\u01f5) {
            if (n6 > 6) {
                this.\u011d = string4;
            }
            if (!this.\u012b.rowDeleted(n6)) {
                this.\u012b.getRow(n6, (Vector)object2);
                n = ((IdbVector)object2).getIntAt(5);
                object = null;
                if (n == 1) {
                    object = new Table((IdbVector)object2, this.\u012c, new Integer(n6), (Hashtable)serializable);
                    if (object.\u0193.endsWith("$db$Indexes")) {
                        this.\u012d = object;
                        try {
                            this.\u014b.doRecovery(true);
                        }
                        catch (IOException iOException) {
                            throw new SQLException("Problem replaying system journal: " + iOException.toString());
                        }
                    }
                } else if (n == 2) {
                    object = new indexTable((IdbVector)object2, this.\u012c, new Integer(n6), (Hashtable)serializable);
                }
            }
            ++n6;
        }
        try {
            this.\u014b.doRecovery(false);
        }
        catch (IOException iOException) {
            throw new SQLException("Problem replaying journal: " + iOException.toString());
        }
        n = 0;
        while (n < this.\u012e.size()) {
            object = (Table)this.\u012e.elementAt(n);
            if (object instanceof indexTable) {
                try {
                    ((indexTable)object).\u0199(this.\u012d, this.\u012c, this.\u012b);
                }
                catch (Exception exception) {
                    System.out.println("Error binding index: " + object.getTableName() + "\n" + exception.toString() + "\nIndex will be dropped from database.");
                    object.dropTable(this.\u014a);
                }
            }
            ++n;
        }
        transaction.commit(transaction.\u02b8);
        this.\u011d = string4;
        ++this.\u0125;
        this.\u0123 = true;
        return transaction;
    }

    public SQLProg execQuery(String string, Transaction transaction) throws SQLException {
        SQLProg sQLProg = new SQLProg(this, string, false, transaction);
        sQLProg.execute();
        return sQLProg;
    }

    public void execSQL(String string, Transaction transaction) throws SQLException {
        SQLProg sQLProg = this.execQuery(string, transaction);
        if (sQLProg.\u01f3 != null) {
            sQLProg.\u01f3.dropTable(null);
            sQLProg.\u01f3 = null;
            sQLProg = null;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            this.close(false);
        }
        catch (Exception exception) {}
    }

    Database getDatabase() {
        return this;
    }

    public static Database getDatabase(String string) {
        Object object;
        try {
            object = Class.forName("java.lang.Exception");
            synchronized (object) {
                if (\u014f == null) {
                    \u014f = new Vector(5, 5);
                    if (System.getProperty("noBanner") == null) {
                        System.out.print("InstantDB - Version 3.13");
                        System.out.println();
                        System.out.println("Copyright (c) 1997-2000 Instant Computer Solutions Ltd.");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Internal error - problem locking Database class " + exception.toString());
            return null;
        }
        Vector vector = \u014f;
        synchronized (vector) {
            int n = 0;
            while (n < \u014f.size()) {
                Database database = (Database)\u014f.elementAt(n);
                if (database.getURL().equalsIgnoreCase(string)) {
                    object = database;
                    Object var3_6 = null;
                    return object;
                }
                ++n;
            }
            object = null;
            Object var3_7 = null;
            return object;
        }
    }

    public static Database getDatabaseWithTable(String string) {
        Vector vector = \u014f;
        synchronized (vector) {
            int n = 0;
            while (n < \u014f.size()) {
                Database database = (Database)\u014f.elementAt(n);
                if (database.getTable(string) != null) {
                    Database database2 = database;
                    Object var3_6 = null;
                    return database2;
                }
                ++n;
            }
            Database database = null;
            Object var3_7 = null;
            return database;
        }
    }

    public String getFilename() {
        return this.\u011a;
    }

    HashTablePool \u011e() {
        HashTablePool hashTablePool = null;
        Vector vector = this.\u0147;
        synchronized (vector) {
            int n = this.\u0147.size() - 1;
            if (n < 0) {
                hashTablePool = new HashTablePool();
            } else {
                hashTablePool = (HashTablePool)this.\u0147.elementAt(n);
                this.\u0147.removeElementAt(n);
            }
        }
        return hashTablePool;
    }

    Transaction \u011f() {
        Transaction transaction = null;
        Vector vector = this.\u0129;
        synchronized (vector) {
            if (this.\u0129.size() > 0) {
                transaction = (Transaction)this.\u0129.elementAt(0);
            }
        }
        return transaction;
    }

    int \u0120(String string, String string2) {
        String string3 = this.\u011b.getProperty(string, string2);
        return Integer.parseInt(string3);
    }

    public Journal getJournal() {
        return this.\u014b;
    }

    public int getOpenCount() {
        return this.\u0125;
    }

    StringBuffer \u0121() {
        StringBuffer stringBuffer = null;
        Vector vector = this.\u0149;
        synchronized (vector) {
            int n = this.\u0149.size() - 1;
            if (n < 0) {
                stringBuffer = new StringBuffer(20);
            } else {
                stringBuffer = (StringBuffer)this.\u0149.elementAt(n);
                this.\u0149.removeElementAt(n);
            }
        }
        return stringBuffer;
    }

    String \u0122(String string, String string2) {
        return this.\u011b.getProperty(string, string2);
    }

    synchronized Table getTable(int n) {
        int n2 = 0;
        while (n2 < this.\u012e.size()) {
            Table table = (Table)this.\u012e.elementAt(n2);
            if (n == table.getTableID()) {
                return table;
            }
            ++n2;
        }
        return null;
    }

    public synchronized Table getTable(String string) {
        int n = 0;
        while (n < this.\u012e.size()) {
            Table table = (Table)this.\u012e.elementAt(n);
            String string2 = table.getTableName();
            if (string2.equalsIgnoreCase(string)) {
                return table;
            }
            ++n;
        }
        return null;
    }

    synchronized Table[] \u0123() {
        Table[] tableArray = new Table[this.\u012e.size()];
        int n = 0;
        while (n < this.\u012e.size()) {
            Table table;
            tableArray[n] = table = (Table)this.\u012e.elementAt(n);
            ++n;
        }
        return tableArray;
    }

    synchronized int \u0124(Table table) {
        int n = 0;
        while (n < this.\u012e.size()) {
            Table table2 = (Table)this.\u012e.elementAt(n);
            if (table2 == table) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized Vector getTables() {
        return (Vector)this.\u012e.clone();
    }

    synchronized String \u0125() {
        return String.valueOf(this.\u011a) + "$tmp$" + this.\u011c++;
    }

    public String getURL() {
        return this.\u0127;
    }

    void \u0126(String string) {
        Object object;
        Object object2;
        Object object3;
        this.\u0147 = new Vector(40, 20);
        this.\u0148 = new Vector(20, 10);
        this.\u0149 = new Vector(40, 20);
        this.\u011b = new Properties();
        string = this.\u012f(string);
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            file = new File(string2);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem opening properties file: " + string + "\n" + iOException.toString());
        }
        this.\u011a = file.getName();
        int n = this.\u011a.indexOf(46);
        if (n != -1) {
            this.\u011a = this.\u011a.substring(0, n);
        }
        try {
            object3 = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object3);
            this.\u011b.load(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SQLException("FileNotFoundException reading properties from file: " + string + " " + fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new SQLException("IOException reading properties from file: " + string + " " + iOException.toString());
        }
        catch (SecurityException securityException) {
            throw new SQLException("SecurityException reading properties from file: " + string + " " + securityException.toString());
        }
        this.\u012f = String.valueOf(this.\u011a) + "$db$cols";
        this.\u0130 = String.valueOf(this.\u011a) + "$db$tables";
        this.\u0131 = String.valueOf(this.\u011a) + "$db$indexes";
        object3 = this.\u0122("traceFile", null);
        object3 = this.\u012f((String)object3);
        boolean bl = false;
        if (this.\u0120("relativeToProperties", "0") != 0) {
            bl = true;
        }
        this.\u0126 = file.getParent();
        this.\u011d = this.\u012d("tablePath", ".", bl);
        this.\u011e = this.\u012d("indexPath", null, bl);
        this.\u0120 = this.\u012d("systemPath", null, bl);
        this.\u011f = this.\u012d("tmpPath", null, bl);
        this.\u0121 = this.\u0120("partitionCount", "0");
        this.\u0122 = new IdbVector(this.\u0121);
        int n2 = 1;
        while (n2 <= this.\u0121) {
            object2 = "partition" + n2;
            object = this.\u012d((String)object2, null, false);
            this.\u0122.addElement(object);
            ++n2;
        }
        this.\u011d(this.\u011d);
        if (this.\u011e != null) {
            this.\u011d(this.\u011e);
        }
        if (this.\u0120 != null) {
            this.\u011d(this.\u0120);
        }
        if (this.\u011f != null) {
            this.\u011d(this.\u011f);
        }
        this.\u013a = this.\u0120("traceLevel", "0");
        this.\u013b = this.\u0120("traceConsole", "0");
        object2 = new Trace(this);
        ((Trace)object2).\u029e((String)object3, this.\u013a);
        this.\u0139 = ((Trace)object2).\u0139;
        this.\u0135 = this.\u0120("exportSQL", "0");
        this.\u0136 = (float)this.\u0120("indexLoad", "5") / 100.0f;
        if (this.\u0120("resultsOnDisk", "0") != 0) {
            this.\u013f = true;
        }
        if (this.\u0120("readOnly", "0") != 0) {
            this.\u00ea = true;
            this.\u013f = false;
        }
        this.\u0132 = this.\u0122("dateFormat", "yyyy-mm-dd");
        this.\u0133 = this.\u0122("currencySymbol", "$").charAt(0);
        this.\u0134 = this.\u0120("currencyDecimal", "2");
        this.\u0137 = this.\u0120("transLevel", "1");
        this.\u0138 = this.\u0120("transImports", "100");
        this.\u0143 = this.\u0120("recoveryPolicy", "2");
        this.\u012a = this.\u0120("timerCheck", "5000");
        this.\u013c = this.\u0120("fastUpdate", "0") != 0;
        this.\u013d = this.\u0120("strictLiterals", "0") != 0;
        this.\u0140 = this.\u0120("likeIgnoreCase", "0") != 0;
        this.\u013e = this.\u0120("milleniumBoundary", "0");
        this.\u0141 = this.\u0120("altStringHashing", "0") != 0;
        this.\u0142 = this.\u0120("nowMeansTime", "0") != 0;
        this.\u0144 = this.\u0120("searchDeletes", "0") != 0;
        this.\u0145 = this.\u0120("prepareIgnoresEscapes", "0") != 0;
        try {
            object = this.getClass();
            synchronized (object) {
                if (\u014e == null) {
                    \u014e = new sqltoken(this);
                    \u014e.\u0210();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Internal error - problem locking Database class " + exception.toString());
        }
        object = this.\u0122("ignoreKeywords", "");
        if (((String)object).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",;", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                \u014e.\u020e(string3);
            }
        }
        this.\u012e = new Vector(20, 20);
        this.\u014b = new Journal(this);
        this.\u0129 = new Vector(10, 5);
        this.\u0128 = new Thread(this);
        this.\u0128.start();
    }

    boolean \u0127() {
        return this.\u0123;
    }

    void \u0128(Transaction transaction) {
        this.\u012c.\u025d(transaction);
        this.\u012b.\u025d(transaction);
        this.\u012d.\u025d(transaction);
    }

    void \u0129(Vector vector, Transaction transaction) {
        Vector vector2 = this.getTables();
        int n = 0;
        while (n < vector2.size()) {
            Table table = (Table)vector2.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                Table table2 = (Table)vector.elementAt(n2);
                if (table == table2) {
                    if (table.\u0263 == null) {
                        table.\u025d(transaction);
                    } else if (table.\u0263 < 1004) {
                        this.\u0128(transaction);
                    } else {
                        table.\u025d(transaction);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    void \u012a(HashTablePool hashTablePool) {
        hashTablePool.\u0188();
        if (this.\u0147 == null) {
            return;
        }
        Vector vector = this.\u0147;
        synchronized (vector) {
            this.\u0147.addElement(hashTablePool);
        }
    }

    public static void removeDatabase(Database database) {
        Vector vector = \u014f;
        synchronized (vector) {
            \u014f.removeElement(database);
        }
    }

    public void removeFromTimerQueue(Transaction transaction) {
        this.\u0129.removeElement(transaction);
    }

    synchronized void \u012b(Table table) {
        if (this.\u012e == null) {
            return;
        }
        int n = this.\u0124(table);
        if (n < 0) {
            return;
        }
        this.\u012e.removeElementAt(n);
    }

    void \u012c(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        Vector vector = this.\u0149;
        synchronized (vector) {
            this.\u0149.addElement(stringBuffer);
        }
    }

    public void run() {
        this.\u0128.setName(String.valueOf(this.\u011a) + "$timer");
        while (true) {
            block8: {
                try {
                    Thread.sleep(this.\u012a);
                }
                catch (InterruptedException interruptedException) {
                    if (this.\u0129 == null) break block8;
                    interruptedException.printStackTrace();
                }
            }
            Database database = this;
            synchronized (database) {
                if (this.\u0129 == null) {
                    Object var2_4 = null;
                    return;
                }
                Transaction transaction = this.\u011f();
                while (transaction != null) {
                    transaction = transaction.\u02a6() ? this.\u011f() : null;
                }
            }
        }
    }

    String \u012d(String string, String string2, boolean bl) {
        Object object;
        String string3 = this.\u0122(string, string2);
        if (string3 != null) {
            if (string3.charAt(0) == '$') {
                object = string3.substring(1);
                string3 = System.getProperty((String)object);
            } else if (bl) {
                string3 = String.valueOf(this.\u0126) + File.separatorChar + string3;
            }
            string3 = this.\u012f(string3);
        } else {
            string3 = this.\u011d;
        }
        try {
            object = new File(string3);
            string3 = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem opening file: " + string3 + "\n" + iOException.toString());
        }
        return string3;
    }

    public void setTableEncryption(String string, TableEncrypt tableEncrypt) throws SQLException {
        Table table = this.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string + " - setting table encryption");
        }
        table.setTableEncryption(tableEncrypt);
    }

    void \u012e(boolean bl) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            \u0150 = true;
            int n = \u014f.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                Database database = (Database)\u014f.elementAt(n2);
                if (!bl) {
                    database.\u0129(database.\u012e, this.\u014a);
                }
                database.\u0125 = 1;
                database.close(false);
                --n2;
            }
            \u0150 = false;
        }
    }

    String \u012f(String string) {
        if (string == null) {
            return null;
        }
        char c = File.separatorChar == '\\' ? (char)'/' : '\\';
        String string2 = string.replace(c, File.separatorChar);
        return string2;
    }

    void \u0130() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        if (Trace.traceIt(128)) {
            Trace.traceOut("Total Memory=" + runtime.totalMemory() + " Free=" + runtime.freeMemory() + " Used " + l);
        }
    }

    int \u0131(String string) {
        if (string.equalsIgnoreCase("CACHE_ROWS")) {
            return 1;
        }
        return 2;
    }
}

