/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BlobColumn;
import db.ByteColumn;
import db.Database;
import db.DateColumn;
import db.DoubleColumn;
import db.FloatColumn;
import db.Importer;
import db.IntegerColumn;
import db.LongColumn;
import db.StringColumn;
import db.Table;
import db.Transaction;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;

class JdbcImporter
implements Importer {
    Connection \u01b1;
    Statement \u01b2;
    ResultSet rs;
    ResultSetMetaData \u01b3;
    int \u01b4;
    int[] \u01b5;

    JdbcImporter(Database database, String string, String string2, Table table, Transaction transaction, Properties properties) {
        String string3 = table.getTableName();
        String string4 = properties.getProperty(String.valueOf(string3) + "%username");
        String string5 = properties.getProperty(String.valueOf(string3) + "$password");
        this.\u01b1 = string4 != null ? DriverManager.getConnection(string, string4, string5) : DriverManager.getConnection(string, database.\u014c, database.\u014d);
        this.\u01b2 = this.\u01b1.createStatement();
        this.rs = this.\u01b2.executeQuery(string2);
        this.\u01b3 = this.rs.getMetaData();
        this.\u01b4 = this.\u01b3.getColumnCount();
        this.\u01b5 = new int[this.\u01b4 + 1];
        if (table.getColCount() > 1) {
            return;
        }
        int n = 1;
        while (n <= this.\u01b4) {
            String string6 = this.\u01b3.getColumnLabel(n);
            this.\u01b5[n] = this.\u01b3.getColumnType(n);
            int n2 = this.\u01b3.getColumnDisplaySize(n);
            if (n2 > 65536) {
                n2 = 256;
            }
            switch (this.\u01b5[n]) {
                case 1: 
                case 12: {
                    new StringColumn(table, string6, n2);
                    break;
                }
                case -7: 
                case -6: {
                    new ByteColumn(table, string6);
                    break;
                }
                case 4: 
                case 5: {
                    new IntegerColumn(table, string6);
                    break;
                }
                case -5: {
                    new LongColumn(table, string6);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    new DateColumn(table, string6, transaction.\u016a);
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    new DoubleColumn(table, string6);
                    break;
                }
                case 7: {
                    new FloatColumn(table, string6);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    new BlobColumn(table, string6, BlobColumn.BINARY_BLOB);
                    break;
                }
                case -1: {
                    new BlobColumn(table, string6, BlobColumn.STRING_BLOB);
                    break;
                }
                default: {
                    throw new SQLException("Column " + string6 + " of type " + this.\u01b5[n] + " is not supported");
                }
            }
            ++n;
        }
    }

    public void close() throws SQLException, IOException {
        this.rs.close();
        this.\u01b2.close();
        this.\u01b1.close();
    }

    public String getCurLine() throws SQLException, IOException {
        return "";
    }

    public void getNextRow(Vector vector, int n) throws SQLException, IOException {
        int n2 = 1;
        while (n2 <= this.\u01b4) {
            Object object = null;
            switch (this.\u01b5[n2]) {
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    object = new Integer(this.rs.getInt(n2));
                    break;
                }
                case -5: {
                    object = new Long(this.rs.getLong(n2));
                    break;
                }
                case 91: {
                    object = this.rs.getDate(n2);
                    break;
                }
                case 92: {
                    object = this.rs.getTime(n2);
                    break;
                }
                case 93: {
                    object = this.rs.getTimestamp(n2);
                    break;
                }
                case 6: 
                case 8: {
                    object = new Double(this.rs.getDouble(n2));
                    break;
                }
                case 7: {
                    object = new Float(this.rs.getFloat(n2));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    object = this.rs.getObject(n2);
                    break;
                }
                default: {
                    object = this.rs.getString(n2);
                }
            }
            vector.setElementAt(object, n2);
            ++n2;
        }
    }

    public boolean hasMoreRows() throws SQLException, IOException {
        return this.rs.next();
    }
}

