/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTreeObject;
import db.BlobColumn;
import db.ByteColumn;
import db.Char1Column;
import db.Column;
import db.CurrencyColumn;
import db.Database;
import db.DateColumn;
import db.DoubleColumn;
import db.FloatColumn;
import db.GrowArray;
import db.IdbVector;
import db.IndexColumn;
import db.IntegerColumn;
import db.Journal;
import db.LongColumn;
import db.RowRangeCache;
import db.SQLProg;
import db.StringColumn;
import db.TableEncrypt;
import db.Trace;
import db.Transaction;
import db.idbDataOutputStream;
import db.idbTrigger;
import db.indexTable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;

public class Table
extends Observable
implements BTreeObject {
    String \u0193;
    int \u0250;
    Vector \u0251;
    int \u01f5;
    int \u0252;
    Vector \u0253;
    String \u0254;
    File \u0255;
    RandomAccessFile \u0256;
    FileDescriptor fd;
    ByteColumn \u0257;
    long \u0258;
    long \u0259;
    byte[] \u025a;
    idbDataOutputStream \u025b;
    ByteArrayInputStream \u025c;
    DataInputStream \u025d;
    byte[] \u025e;
    int \u025f;
    int \u0260;
    Database \u00ee;
    Journal \u014b;
    int \u0261;
    int \u0262;
    Integer \u0263;
    int \u0264;
    boolean \u0265;
    static int \u0266;
    Transaction \u0267;
    int \u0268;
    Thread \u0269;
    int \u026a;
    int \u026b;
    int \u026c;
    BitSet \u026d;
    int[] \u026e;
    int \u026f;
    boolean \u0270;
    Vector \u0271;
    boolean \u0272;
    boolean \u0273;
    boolean isClosed;
    boolean \u0274;
    boolean \u013c;
    int[] \u00f4;
    int \u0275;
    int \u0276;
    TableEncrypt \u0277;
    byte[] \u0278;
    int[] \u0279;
    int \u027a;
    boolean \u027b;
    boolean \u027c;
    boolean \u027d;
    Runtime \u027e;
    GrowArray \u027f;
    Table \u00f6;
    int \u0280;
    boolean \u0281;
    public static final int VANILLA_TABLE = 1;
    public static final int INDEX_TABLE = 2;
    public static final int TEMP_TABLE = 3;
    static final Integer \u0282;
    static final Integer \u0283;
    byte[] \u0284;
    int \u0285;
    int \u0286;
    int \u0287;

    static {
        \u0282 = new Integer(1);
        \u0283 = new Integer(0);
    }

    Table(IdbVector idbVector, Table table, Object object, Hashtable hashtable) {
        Object object2;
        this.\u027e = Runtime.getRuntime();
        this.\u00ee = table.\u00ee;
        this.\u014b = this.\u00ee.\u014b;
        this.\u013c = this.\u00ee.\u013c;
        this.\u0251 = new Vector(10, 10);
        this.\u0253 = new Vector(10, 10);
        this.\u026d = new BitSet(256);
        this.\u0262 = this.\u00ee.\u0120("rowCacheSize", "20");
        if (idbVector == null) {
            this.\u0193 = (String)object;
            this.\u0263 = new Integer(1002);
            this.\u0254 = this.\u00ee.\u011d;
            this.\u0264 = 1;
        } else {
            this.\u0263 = idbVector.getIntegerAt(1);
            this.\u0193 = idbVector.getStringAt(2);
            object2 = idbVector.getStringAt(3);
            this.\u0280 = ((String)object2).length() > 0 ? Integer.parseInt((String)object2) : -1;
            if (this.\u0263 < 1000) {
                throw new SQLException("Internal error - illegal table ID: " + this.\u0263 + " column: " + this.\u0193);
            }
            if (this.\u0263.equals(new Integer(1000))) {
                return;
            }
            if (this.\u0263.equals(new Integer(1002))) {
                return;
            }
            this.\u0264 = idbVector.getIntAt(5);
            this.\u0267();
        }
        object2 = (Vector)hashtable.get(this.\u0263);
        IdbVector idbVector2 = new IdbVector(table);
        int n = 0;
        while (n < ((Vector)object2).size()) {
            int[] nArray = (int[])((Vector)object2).elementAt(n);
            table.getRow(nArray[0], idbVector2);
            int n2 = idbVector2.getIntAt(1);
            String string = idbVector2.getStringAt(3);
            String string2 = idbVector2.getStringAt(4);
            int n3 = idbVector2.getIntAt(5);
            int n4 = idbVector2.getIntAt(6);
            int n5 = idbVector2.getIntAt(7);
            int n6 = idbVector2.getIntAt(8);
            int n7 = idbVector2.getIntAt(9);
            String string3 = idbVector2.getStringAt(10);
            if (n2 < 1000) {
                throw new SQLException("Internal error - illegal column ID: " + n2 + " column: " + string);
            }
            Column column = null;
            switch (n3) {
                case 3: {
                    column = new StringColumn(this, string, (n5 - 4) / 2);
                    break;
                }
                case 11: {
                    column = new Char1Column(this, string, n5 - 4);
                    break;
                }
                case 2: {
                    column = new IntegerColumn(this, string);
                    break;
                }
                case 4: {
                    column = new LongColumn(this, string);
                    break;
                }
                case 5: {
                    column = new DateColumn(this, string, "dd-mmm-yyyy");
                    break;
                }
                case 6: {
                    column = new CurrencyColumn(this, string, '$', 2);
                    break;
                }
                case 7: {
                    column = new FloatColumn(this, string);
                    break;
                }
                case 8: {
                    column = new DoubleColumn(this, string);
                    break;
                }
                case 9: {
                    column = new IndexColumn(this, string, 0);
                    break;
                }
                case 10: {
                    column = new BlobColumn(this, string, 0);
                    break;
                }
                case 1: {
                    column = new ByteColumn(this, string);
                    if (!string.equals("$$control")) break;
                    this.\u0257 = (ByteColumn)column;
                    break;
                }
                default: {
                    throw new SQLException("Corrupt columns table");
                }
            }
            column.setCacheCondition(n6, n7, true);
            column.\u00e5 = n4;
            column.\u00f0 = new Integer(n2);
            if (string2.indexOf(".PK") >= 0) {
                column.\u00e9(1, true);
            }
            if (string2.indexOf(".UNIQ") >= 0) {
                column.\u00e9(2, true);
            }
            if (string2.indexOf(".~NULL") >= 0) {
                column.\u00e9(3, true);
            }
            if (!StringColumn.\u0216(string3)) {
                column.\u00df(4, string3);
            }
            ++n;
        }
        try {
            if (!this.\u0260(this.\u0193)) {
                throw new SQLException("Could not open table " + this.\u0193 + " in path " + this.\u0254);
            }
            this.\u00ee.\u0130();
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
    }

    public Table(String string, Database database, Transaction transaction, int n) throws SQLException {
        this.\u0264 = 1;
        try {
            this.\u0255(string, database, n);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
        this.\u025d(transaction);
    }

    Table(String string, Database database, boolean bl, boolean bl2) {
        this.\u0264 = bl ? 3 : 1;
        if (bl2) {
            this.\u027b = true;
        }
        try {
            this.\u0255(string, database, -1);
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: " + iOException.toString() + iOException.getMessage());
        }
    }

    void \u0250(Column column) {
        column.\u00ea(this.\u0250);
        this.\u0250 += column.getLength();
        this.\u0251.addElement(column);
    }

    void \u0251(String string, String string2, boolean bl) {
        if (this.\u026e == null) {
            this.\u026e = new int[this.\u0251.size()];
            this.\u026f = 0;
        }
        Column column = null;
        int n = 0;
        String string3 = null;
        if (string != null) {
            string3 = String.valueOf(string) + "." + string2;
        }
        int n2 = 0;
        while (n2 < this.\u0251.size()) {
            Column column2 = (Column)this.\u0251.elementAt(n2);
            if (string2.equalsIgnoreCase(column2.getName())) {
                column = column2;
                n = n2;
                break;
            }
            if (string != null) {
                if (string3.equalsIgnoreCase(column2.getName())) {
                    column = column2;
                    n = n2;
                    break;
                }
            } else {
                String string4 = column2.getName();
                int n3 = string4.indexOf(46);
                if (n3 >= 0 && string2.equalsIgnoreCase(string4 = string4.substring(n3 + 1))) {
                    if (column != null) {
                        throw new SQLException("Ambiguous column name: " + string2);
                    }
                    column = column2;
                    n = n2;
                }
            }
            ++n2;
        }
        if (column == null) {
            try {
                n = Integer.parseInt(string2);
                column = (Column)this.\u0251.elementAt(n);
            }
            catch (Exception exception) {
                throw new SQLException("ORDER BY column, " + string2 + ", must be in the column selection");
            }
        }
        this.\u026e[this.\u026f++] = n;
        column.\u00f4 = 1;
        if (bl) {
            column.\u00f4 = 2;
        }
    }

    public int addRow(Object object, Transaction transaction) throws SQLException {
        int n = 0;
        n = this.\u01f5 + 1;
        if (this.\u0252 > 0) {
            if (this.\u0261 < this.\u026a) {
                n = this.\u0261;
            } else if (this.\u00ee.\u0144 && this.\u026b != Integer.MAX_VALUE) {
                int n2 = this.\u026b + 1;
                while (n2 < this.\u01f5) {
                    if (this.rowDeleted(n2)) {
                        n = n2;
                    }
                    ++n2;
                }
            }
        }
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            Vector vector = new Vector(this.\u0251.size());
            int n3 = 0;
            while (n3 < this.\u0251.size()) {
                Column column = (Column)this.\u0251.elementAt(n3);
                String string = column.getName();
                Object object2 = hashtable.get(string);
                if (object2 == null || object2 == "NULL") {
                    object2 = column.\u00e4();
                }
                vector.addElement(object2);
                ++n3;
            }
            this.\u0197(vector, n, transaction);
        } else {
            this.\u0197((Vector)object, n, transaction);
        }
        return n;
    }

    int addRow(Object object, Transaction transaction, int n) {
        int n2 = this.addRow(object, transaction);
        if (this.\u027f != null) {
            this.\u027f.add(n);
        }
        return n2;
    }

    void \u0197(Vector vector, int n, Transaction transaction) {
        int n2;
        int n3;
        boolean bl = false;
        if (n <= this.\u01f5 && this.rowDeleted(n)) {
            bl = true;
        }
        try {
            this.\u025b.\u0161();
            n3 = 0;
            while (n3 < this.\u0251.size()) {
                Column column = (Column)this.\u0251.elementAt(n3);
                Object e = vector.elementAt(n3);
                column.\u00eb(this.\u025b, n, e, transaction);
                ++n3;
            }
        }
        catch (Exception exception) {
            if (bl) {
                Column column = (Column)this.\u0251.elementAt(0);
                Integer n4 = ByteColumn.\u00de(1);
                column.\u00f3.add(n4, n);
            }
            throw new SQLException(exception.toString());
        }
        if (this.\u00ee.\u00ea) {
            if (this.\u0264 != 3) {
                throw new SQLException("Error writing to table, " + this.\u0193 + " - database is readonly.");
            }
            ++this.\u01f5;
            return;
        }
        if (this.\u0264 == 3 && !this.\u00ee.\u013f) {
            if (bl) {
                --this.\u0252;
                if (n == this.\u0261) {
                    this.\u0259(n + 1);
                }
            } else if (n > this.\u01f5) {
                ++this.\u01f5;
            }
            return;
        }
        if (this.\u0277 != null) {
            n3 = this.\u025a[0];
            this.\u0277.Encrypt(this.\u0193, this.\u025a, n, this.\u0279);
            this.\u025a[0] = n3;
            if (n == this.\u027a) {
                this.\u027a = 0;
            }
            this.\u025b.\u018d = null;
            this.\u0266();
        }
        try {
            if (!this.\u0273) {
                this.\u025e();
            }
            this.\u0274 = true;
            if (transaction != null && this.\u0264 != 3) {
                this.\u014b.\u01be(transaction, 1231975028, n, this, null, this.\u025a);
            }
            if (bl) {
                --this.\u0252;
                if (n == this.\u0261) {
                    this.\u0259(n + 1);
                }
            } else if (n > this.\u01f5) {
                ++this.\u01f5;
            }
            if (this.\u0284 != null) {
                if (this.\u0286 == 0) {
                    this.\u0287 = n;
                }
                System.arraycopy(this.\u025a, 0, this.\u0284, this.\u0286, this.\u0250);
                this.\u0286 += this.\u0250;
                if (this.\u0286 == this.\u0285) {
                    this.\u0268(false);
                }
            } else {
                long l = this.\u0259 + (long)((n - 1) * this.\u0250);
                this.\u0256.seek(l);
                this.\u0256.write(this.\u025a, 0, this.\u0250);
                if (n == this.\u01f5) {
                    byte by = this.\u025a[0];
                    this.\u025a[0] = -1;
                    this.\u0256.write(this.\u025a, 0, this.\u0250);
                    this.\u025a[0] = by;
                }
            }
            if (n >= this.\u025f && n < this.\u025f + this.\u0260) {
                int n5 = (n - this.\u025f) * this.\u0250;
                System.arraycopy(this.\u025a, 0, this.\u025e, n5, this.\u0250);
            }
            if (this.rowDeleted(n)) {
                ++this.\u0252;
            }
            n2 = 0;
            while (n2 < this.\u0253.size()) {
                indexTable indexTable2 = (indexTable)this.\u0253.elementAt(n2);
                indexTable2.\u0198(n);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Disk write problem: " + iOException.toString());
        }
        if (this.\u0271 != null && transaction != null) {
            Vector vector2 = new Vector(this.\u0251.size());
            this.getRow(n, vector2);
            vector2.removeElementAt(0);
            n2 = 0;
            while (n2 < this.\u0271.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.\u0271.elementAt(n2);
                if (this.\u0272) {
                    if ((idbTrigger2.getEvents() & 1) > 0) {
                        idbTrigger2.onUpdate((Vector)vector2.clone(), transaction.ID);
                    }
                } else if ((idbTrigger2.getEvents() & 4) > 0) {
                    idbTrigger2.onAdd((Vector)vector2.clone(), transaction.ID);
                }
                ++n2;
            }
        }
    }

    void \u0252(idbTrigger idbTrigger2) {
        if (this == this.\u00ee.\u012b || this == this.\u00ee.\u012c || this == this.\u00ee.\u012d) {
            throw new SQLException("Triggers not allowed on system tables");
        }
        if (this.\u0271 == null) {
            this.\u0271 = new Vector(10, 10);
        }
        this.\u0271.addElement(idbTrigger2);
    }

    void \u0253(Transaction transaction, boolean bl) {
        Object object;
        this.\u025a = new byte[this.\u0250];
        this.\u025b = new idbDataOutputStream(this.\u025a, 2 * this.\u0251.size());
        this.\u025e = new byte[this.\u0262 * this.\u0250];
        if (this.\u027b) {
            this.\u00ee.\u011b(this);
        }
        if (this.\u00ee.\u00ea) {
            return;
        }
        if (this.\u0256 == null) {
            return;
        }
        if (this.\u0264 != 3) {
            this.\u00ee.\u011b(this);
        }
        Vector<String> vector = new Vector<String>(this.\u0251.size());
        Enumeration enumeration = this.\u0251.elements();
        while (enumeration.hasMoreElements()) {
            object = (Column)enumeration.nextElement();
            ((Column)object).\u00d4(this.\u0256);
            if (!((Column)object).inPrimaryKey() || !bl) continue;
            vector.addElement(((Column)object).getName());
        }
        this.\u0256.writeInt(this.\u0250);
        this.\u0259 = this.\u0256.getFilePointer();
        object = new byte[this.\u0250];
        int n = 0;
        while (n < this.\u0250) {
            object[n] = -1;
            ++n;
        }
        this.\u0256.write((byte[])object, 0, this.\u0250);
        if (this.fd != null) {
            this.fd.sync();
        }
        this.\u0262(transaction);
        if (!vector.isEmpty()) {
            new indexTable(this, vector, String.valueOf(this.\u0193) + "$pKey", false, transaction, this.\u0280);
        }
        if (this.\u0264 == 2) {
            try {
                int n2;
                if (this.\u0263 != null && (n2 = this.\u0263.intValue()) >= 1006) {
                    this.\u0256.close();
                    this.\u0256 = null;
                    this.fd = null;
                }
            }
            catch (IOException iOException) {
                throw new SQLException("IO problem closing index file: " + iOException);
            }
        }
    }

    public boolean checkColName(String string) {
        int n = 0;
        while (n < this.\u0251.size()) {
            Column column = (Column)this.\u0251.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    synchronized void close(boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("Closing table " + this.\u0193 + " Rows " + this.\u01f5 + " Deleted rows " + this.\u0252);
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("  Rec len " + this.\u0250 + " Cols " + this.\u0251.size() + " Indexes " + this.\u0253.size());
        }
        if (!this.\u0273 || this.\u00ee.\u00ea) {
            if (Trace.traceIt(8)) {
                Trace.traceOut("  No change");
            }
        } else if (this.\u0264 != 3 && !bl) {
            this.\u0266();
        }
        if (this.\u0256 != null) {
            this.\u0256.close();
        }
        this.isClosed = true;
        int n = 0;
        while (n < this.\u0251.size()) {
            Column column = (Column)this.\u0251.elementAt(n);
            column.\u00d0();
            column = null;
            ++n;
        }
        this.\u0251 = null;
        this.\u0253 = null;
    }

    void \u0254(long l) {
        if (this.\u0271 != null) {
            int n = 0;
            while (n < this.\u0271.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.\u0271.elementAt(n);
                if ((idbTrigger2.getEvents() & 0x10) > 0) {
                    idbTrigger2.onCommit(l);
                }
                ++n;
            }
        }
    }

    void \u0255(String string, Database database, int n) {
        this.\u027e = Runtime.getRuntime();
        if (string == null) {
            if (Trace.traceIt(8)) {
                Trace.traceOut("Creating table null");
            }
        } else if (Trace.traceIt(8)) {
            Trace.traceOut("Creating table " + string);
        }
        this.\u00ee = database;
        this.\u0280 = n;
        this.\u014b = this.\u00ee.\u014b;
        this.\u013c = this.\u00ee.\u013c;
        Table table = database.getTable(string);
        if (table != null) {
            throw new SQLException("Table alreacy exists: " + string);
        }
        this.\u0251 = new Vector(10, 10);
        this.\u0253 = new Vector(10, 10);
        this.\u026d = new BitSet(256);
        this.\u0267();
        if (string != null) {
            this.\u0193 = new String(string);
            this.\u0255 = new File(this.\u0254, String.valueOf(string) + ".tbl");
            this.\u0255.isAbsolute();
            if (this.\u0264 != 3 || this.\u00ee.\u013f) {
                String string2 = "rw";
                if (this.\u00ee.\u00ea) {
                    string2 = "r";
                }
                this.\u0256 = new RandomAccessFile(this.\u0255, string2);
                if (this.\u0264 != 3) {
                    this.fd = this.\u0256.getFD();
                }
                this.\u0256.writeInt(3);
                this.\u0256.writeInt(13);
                this.\u0258 = this.\u0256.getFilePointer();
                this.\u025e();
            }
        }
        this.\u0262 = this.\u00ee.\u0120("rowCacheSize", "20");
        this.\u0257 = new ByteColumn(this, "$$control");
        this.\u0257.\u00e9(3, true);
        this.\u0257.\u00df(4, "0");
        this.\u0257.setCacheCondition(1, 8192);
        this.\u00ee.\u0130();
    }

    void \u0256(int n) {
        this.\u0285 = n * this.\u0250;
        this.\u0284 = new byte[this.\u0285];
        this.\u0286 = 0;
        this.\u0287 = 0;
        this.\u025c = new ByteArrayInputStream(this.\u0284);
        this.\u025d = new DataInputStream(this.\u025c);
    }

    void \u0257(byte[] byArray, int n, int n2, int n3) {
        if (this.\u027a != n) {
            int n4 = (n - n2) * this.\u0250;
            System.arraycopy(byArray, n4, this.\u0278, 0, this.\u0250);
            byte by = this.\u0278[0];
            this.\u0277.Decrypt(this.\u0193, this.\u0278, n, this.\u0279);
            this.\u0278[0] = by;
            this.\u025c = new ByteArrayInputStream(this.\u0278);
            this.\u025d = new DataInputStream(this.\u025c);
            this.\u027a = n;
        }
        this.\u025d.reset();
        this.\u025d.skip(n3);
    }

    public void deleteRow(int n, Transaction transaction) throws SQLException {
        Object object;
        if (n > this.\u01f5 && transaction == null) {
            return;
        }
        if (n == this.\u027a) {
            this.\u027a = 0;
        }
        if (this.\u026b == 0) {
            this.\u026a = this.\u026b = n;
        } else if (n > this.\u026b) {
            this.\u026c = this.\u026b;
            if (this.\u026c == 0) {
                this.\u026c = Integer.MAX_VALUE;
            }
            this.\u026b = n;
        } else if (n < this.\u026a) {
            this.\u026a = n;
        }
        if (n <= 256) {
            this.\u026d.set(n - 1);
        }
        if (transaction != null) {
            this.\u014b.\u01be(transaction, 1147497588, n, this, null, null);
        }
        int n2 = 0;
        while (n2 < this.\u0253.size()) {
            indexTable indexTable2 = (indexTable)this.\u0253.elementAt(n2);
            indexTable2.\u019b(n);
            ++n2;
        }
        ++this.\u0252;
        if (n < this.\u0261 || this.\u0252 == 1) {
            this.\u0261 = n;
        }
        int n3 = 0;
        while (n3 < this.\u0251.size()) {
            object = (Column)this.\u0251.elementAt(n3);
            ((Column)object).onDelete(this.\u0256, n, transaction);
            ++n3;
        }
        this.\u025b.\u0161();
        this.\u0257.\u00eb(this.\u025b, n, \u0282, transaction);
        try {
            if (!this.\u0273) {
                this.\u025e();
            }
            this.\u0274 = true;
            if (this.\u0256 != null) {
                this.\u0256.seek(this.\u0259 + (long)((n - 1) * this.\u0250) + (long)this.\u0257.\u00e7());
                this.\u0256.write(this.\u025a, 0, this.\u0257.getLength());
            }
            if (this.\u0277 != null) {
                this.\u0266();
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem while deleting row: " + n + " " + exception.toString());
        }
        if (n >= this.\u025f && n < this.\u025f + this.\u0260) {
            this.\u0260 = n - this.\u025f;
        }
        if (this.\u0271 != null && transaction != null) {
            object = new Vector(this.\u0251.size());
            this.getRow(n, (Vector)object);
            ((Vector)object).removeElementAt(0);
            int n4 = 0;
            while (n4 < this.\u0271.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.\u0271.elementAt(n4);
                if ((idbTrigger2.getEvents() & 2) > 0 && !this.\u0272) {
                    idbTrigger2.onDelete((Vector)((Vector)object).clone(), transaction.ID);
                }
                if ((idbTrigger2.getEvents() & 1) > 0 && this.\u0272) {
                    idbTrigger2.preUpdate((Vector)((Vector)object).clone(), transaction.ID);
                }
                ++n4;
            }
        }
    }

    void \u0258(String string, Column column) {
        int n;
        int n2 = 0;
        while (n2 < this.\u0253.size()) {
            indexTable indexTable2 = (indexTable)this.\u0253.elementAt(n2);
            Vector vector = indexTable2.\u0199;
            n = 0;
            while (n < vector.size()) {
                Column column2 = (Column)vector.elementAt(n);
                if (column == column2) {
                    throw new SQLException("Col " + column2.getName() + " is part of index " + indexTable2.getTableName());
                }
                ++n;
            }
            ++n2;
        }
        int n3 = column.getLength();
        int n4 = column.\u00e7();
        n = n4 + n3;
        int n5 = this.\u0250 - n3;
        int n6 = this.\u0250 - n4 - n3;
        long l = 0L;
        String string2 = "DELETE FROM " + this.\u00ee.\u012f + " WHERE ColId = " + column.getColID();
        this.\u00ee.execSQL(string2, null);
        string2 = "UPDATE " + this.\u00ee.\u012f + " SET offset = offset - " + n3 + " WHERE TableID = " + this.\u0263 + " AND offset > " + n4;
        this.\u00ee.execSQL(string2, null);
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.\u0251.size()) {
            Column column3 = (Column)this.\u0251.elementAt(n8);
            if (column == column3) {
                n7 = n8;
            } else if (column3.\u00e7() > n4) {
                column3.\u00ea(column3.\u00e7() - n3);
                if (l == 0L) {
                    l = column3.\u00f5 - column.\u00f5;
                }
                column3.\u00f5 -= l;
            }
            column3.close(this.\u0256);
            ++n8;
        }
        if (l == 0L) {
            l = this.\u0256.getFilePointer() - column.\u00f5;
        }
        this.\u0251.removeElementAt(n7);
        int n9 = 0;
        int n10 = 1;
        while (n10 <= this.\u01f5) {
            int n11 = this.\u0261(n10, 0);
            System.arraycopy(this.\u025e, n11, this.\u025e, n9, n4);
            System.arraycopy(this.\u025e, n11 + n, this.\u025e, n9 + n4, n6);
            n9 += n5;
            if (n10 == this.\u025f + this.\u0260 - 1) {
                this.\u0256.seek(this.\u0259 - l + (long)((this.\u025f - 1) * n5));
                this.\u0256.write(this.\u025e, 0, this.\u0260 * n5);
                n9 = 0;
            }
            this.\u025a();
            ++n10;
        }
        this.\u0256.write(-1);
        this.\u0250 = n5;
        this.\u0259 -= l;
        this.\u0256.seek(this.\u0259 - 4L);
        this.\u0256.writeInt(n5);
        if (this.\u0277 != null) {
            this.setTableEncryption(this.\u0277);
        }
    }

    public synchronized void dropTable(Transaction transaction) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("Dropping table " + this.\u0193);
        }
        this.\u00ee.\u012b(this);
        while (!this.\u0253.isEmpty()) {
            indexTable indexTable2 = (indexTable)this.\u0253.elementAt(0);
            indexTable2.dropTable(transaction);
        }
        try {
            int n = 0;
            while (n < this.\u0251.size()) {
                Column column = (Column)this.\u0251.elementAt(n);
                column.\u00d1();
                ++n;
            }
            this.close(false);
        }
        catch (Exception exception) {}
        if (this.\u0264 != 3) {
            Object object;
            Table table = this.\u00ee.\u012c;
            int n = 1;
            while (n <= table.\u01f5) {
                object = (Integer)table.getColByRow("TableID", n);
                if (this.\u0263.equals(object)) {
                    table.deleteRow(n, transaction);
                }
                ++n;
            }
            object = this.\u00ee.\u012b;
            int n2 = 1;
            while (n2 <= ((Table)object).\u01f5) {
                Integer n3 = (Integer)((Table)object).getColByRow("TableID", n2);
                if (this.\u0263.equals(n3)) {
                    ((Table)object).deleteRow(n2, transaction);
                    break;
                }
                ++n2;
            }
        }
        this.\u025e = null;
        try {
            if (this.\u0264 != 3) {
                this.\u00ee.\u012c.fd.sync();
                this.\u00ee.\u012b.fd.sync();
                this.\u00ee.\u012d.fd.sync();
            }
            this.\u0255.delete();
        }
        catch (Exception exception) {}
    }

    void \u00d8() {
        int n = 0;
        while (n <= this.\u01f5) {
            this.\u00d8(n);
            ++n;
        }
    }

    void \u00d8(int n) {
        System.out.println(this.\u0265(n, true));
    }

    public void exportText(String string) throws SQLException {
        Trace trace = Trace.\u029b();
        if (trace.\u0139 == null) {
            return;
        }
        if ((trace.\u029c() & 0x800) == 0) {
            return;
        }
        PrintWriter printWriter = trace.\u0139;
        synchronized (printWriter) {
            int n;
            PrintWriter printWriter2 = trace.\u0139;
            if (string != null) {
                printWriter2.println(string);
            }
            if (trace.\u029c && this.\u0264 != 3) {
                printWriter2.println("Table " + this.\u0193 + " has " + this.\u01f5 + " rows. " + this.\u0252 + " are deleted.");
            }
            StringBuffer stringBuffer = new StringBuffer(1024);
            int n2 = this.\u0251.size();
            Column[] columnArray = new Column[n2];
            int[] nArray = new int[n2];
            if (trace.\u029a && trace.\u029d) {
                stringBuffer.append("Row  ");
            }
            int n3 = 0;
            while (n3 < n2) {
                if (n3 != 0 || trace.\u029f) {
                    Object object;
                    columnArray[n3] = (Column)this.\u0251.elementAt(n3);
                    int n4 = 0;
                    switch (columnArray[n3].\u00ed) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            n4 = 9;
                            break;
                        }
                        case 8: {
                            n4 = 15;
                            break;
                        }
                        case 3: {
                            object = (StringColumn)columnArray[n3];
                            n4 = ((StringColumn)object).\u0217 + 1;
                            break;
                        }
                        default: {
                            n4 = 5;
                        }
                    }
                    if (trace.\u029a) {
                        object = String.valueOf(columnArray[n3].getName()) + ' ';
                        nArray[n3] = ((String)object).length();
                        stringBuffer.append((String)object);
                        if (nArray[n3] < n4) {
                            n = nArray[n3];
                            while (n < n4) {
                                stringBuffer.append(' ');
                                ++n;
                            }
                            nArray[n3] = n4;
                        }
                    } else {
                        nArray[n3] = n4;
                    }
                }
                ++n3;
            }
            if (trace.\u029a) {
                printWriter2.println(stringBuffer);
            }
            Vector vector = new Vector(n2);
            int n5 = 1;
            while (n5 <= this.\u01f5) {
                stringBuffer.setLength(0);
                if (!this.rowDeleted(n5) || trace.\u029e) {
                    if (trace.\u029d) {
                        stringBuffer.append(n5);
                        if (!trace.\u029b) {
                            if (n5 < 10) {
                                stringBuffer.append(' ');
                            }
                            if (n5 < 100) {
                                stringBuffer.append(' ');
                            }
                            if (n5 < 1000) {
                                stringBuffer.append(' ');
                            }
                            if (n5 < 10000) {
                                stringBuffer.append(' ');
                            }
                        } else {
                            stringBuffer.append(trace.\u0179);
                        }
                    }
                    this.getRow(n5, vector);
                    n = 0;
                    while (n < n2) {
                        if (n != 0 || trace.\u029f) {
                            Object e = vector.elementAt(n);
                            String string2 = columnArray[n].toString(e);
                            trace.\u029a(stringBuffer);
                            stringBuffer.append(string2);
                            trace.\u029a(stringBuffer);
                            if (trace.\u029b) {
                                if (n != n2 - 1) {
                                    stringBuffer.append(trace.\u0179);
                                }
                            } else if (string2.length() < nArray[n]) {
                                int n6 = string2.length();
                                while (n6 < nArray[n]) {
                                    stringBuffer.append(' ');
                                    ++n6;
                                }
                            } else {
                                stringBuffer.append(' ');
                                nArray[n] = string2.length() + 1;
                            }
                        }
                        ++n;
                    }
                    printWriter2.println(stringBuffer);
                }
                ++n5;
            }
            trace.\u0139.flush();
        }
    }

    protected void finalize() throws Throwable {
        if (this.\u0264 == 3 && this.\u0253 != null) {
            this.dropTable(null);
        }
        if (this.\u027b) {
            this.\u00ee.\u012b(this);
        }
    }

    int \u0259(int n) {
        if (this.\u0252 == 0) {
            this.\u0261 = 0;
            return this.\u0261;
        }
        int n2 = n;
        while (n2 <= this.\u01f5) {
            if (this.rowDeleted(n2)) {
                this.\u0261 = n2;
                return this.\u0261;
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 < n) {
            if (this.rowDeleted(n3)) {
                if (n3 == this.\u0261) break;
                this.\u0261 = n3;
                return this.\u0261;
            }
            ++n3;
        }
        this.\u0261 = 0;
        this.\u0252 = 0;
        if (!this.\u0273) {
            this.\u025e();
        }
        return this.\u0261;
    }

    void \u025a() {
        this.\u027d = false;
        byte[] byArray = this.\u025e;
        synchronized (byArray) {
            this.\u025e.notify();
        }
    }

    synchronized void \u025b() {
        --this.\u0268;
        try {
            if (this.fd != null && this.\u0274 && this.\u0268 == 0) {
                if (this.fd.valid() && !this.\u013c) {
                    this.fd.sync();
                }
                this.\u0274 = false;
            }
        }
        catch (Exception exception) {
            System.out.println("Table " + this.\u0193);
            exception.printStackTrace();
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("Trans " + this.\u0267.ID + " freed  table: " + this.\u0193 + " Lock count=" + this.\u0268);
        }
        if (this.\u0268 < 0) {
            throw new SQLException("Internal error - Transaction: " + this.\u0267.ID + " has " + this.\u0268 + " lock(s) on table: " + this.\u0193);
        }
        if (this.\u0268 == 0) {
            this.notify();
        }
    }

    public Column getColByID(Integer n) {
        int n2 = 0;
        while (n2 < this.\u0251.size()) {
            Column column = (Column)this.\u0251.elementAt(n2);
            if (column.\u00f0.equals(n)) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    public Column getColByName(String string) {
        int n = 0;
        while (n < this.\u0251.size()) {
            Column column = (Column)this.\u0251.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return column;
            }
            ++n;
        }
        return null;
    }

    public Column getColByName(String string, boolean bl) {
        boolean bl2 = false;
        int n = string.indexOf(46);
        if (n != -1) {
            bl2 = true;
        }
        int n2 = 0;
        while (n2 < this.\u0251.size()) {
            Column column = (Column)this.\u0251.elementAt(n2);
            String string2 = column.getName();
            if (bl2) {
                Table table = column.getUnderlyingTable();
                if (table != null) {
                    String string3 = table.getTableName();
                    string2 = String.valueOf(string3) + "." + string2;
                } else {
                    string2 = String.valueOf(this.\u0193) + "." + string2;
                }
            }
            if (string2.equalsIgnoreCase(string)) {
                return column;
            }
            if (bl && (n = string2.indexOf(46)) != -1) {
                string2 = string2.substring(n + 1);
            }
            if (string2.equalsIgnoreCase(string)) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    public Object getColByRow(String string, int n) throws SQLException {
        Column column = this.getColByName(string);
        if (column == null) {
            return null;
        }
        return column.\u00c9(n);
    }

    public int getColCount() {
        return this.\u0251.size();
    }

    public int getColIndex(String string) {
        int n = 0;
        while (n < this.\u0251.size()) {
            Column column = (Column)this.\u0251.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Vector getColList() {
        return this.\u0251;
    }

    public int getCount() {
        this.\u01f5 -= this.\u0252;
        return this.\u01f5;
    }

    indexTable \u025c(Column column) {
        Vector<Column> vector = new Vector<Column>(1);
        vector.addElement(column);
        return this.\u025c(vector);
    }

    indexTable \u025c(Vector vector) {
        int n = 0;
        while (n < this.\u0253.size()) {
            indexTable indexTable2 = (indexTable)this.\u0253.elementAt(n);
            if (indexTable2.\u01a5(vector)) {
                return indexTable2;
            }
            ++n;
        }
        return null;
    }

    public int getRelColPosn(String string) {
        int n = 0;
        while (n < this.\u0251.size()) {
            Column column = (Column)this.\u0251.elementAt(n);
            if (column.getName().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void getRow(int n, Vector vector) throws SQLException {
        int n2 = this.\u0251.size();
        vector.removeAllElements();
        if (this.\u00f4 != null) {
            n = this.\u00f4[n - 1] + 1;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Column column = (Column)this.\u0251.elementAt(n3);
            Object object = column.\u00c9(n);
            vector.addElement(object);
            if (n3 == 0 && (n4 = ((Integer)object).intValue()) == -1) break;
            ++n3;
        }
    }

    public void getRowByValue(String string, Object object, Vector vector) throws SQLException {
        Column column = this.getColByName(string);
        int n = column.getRowByValue(object, 0);
        if (n == 0) {
            return;
        }
        this.getRow(n, vector);
    }

    public int getRowCount() {
        return this.\u01f5;
    }

    public int getTableID() {
        if (this.\u0263 == null) {
            return 0;
        }
        return this.\u0263;
    }

    public String getTableName() {
        return this.\u0193;
    }

    public int getTableType() {
        return this.\u0264;
    }

    public int getUnderlyingRow(int n) {
        return this.\u027f.\u0186[n - 1];
    }

    public Table getUnderlyingTable() {
        return this.\u00f6;
    }

    public int getValidRowCount() {
        return this.\u01f5 - this.\u0252;
    }

    public Object getValueByValue(String string, Object object, Column column) throws SQLException {
        Vector vector = new Vector(this.getColCount());
        this.getRowByValue(string, object, vector);
        if (vector == null) {
            return null;
        }
        int n = 0;
        while (n < this.\u0251.size()) {
            if (this.\u0251.elementAt(n) == column) {
                return vector.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void \u025d(Transaction var1_1) {
        if (var1_1 == null) {
            return;
        }
        if (var1_1.\u02b1()) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            if (var1_1.\u02b0() > 0 && this.\u0267.\u02a5(var1_1)) {
                throw new SQLException("Deadlock detected by\n" + var1_1.toString() + "\nTrying to lock table: " + this.\u0193 + "\nLock owner: \n" + this.\u0267.toString());
            }
            var1_1.\u02b3(this.\u0267);
            if (Trace.traceIt(16)) {
                Trace.traceOut("Transaction: " + this.\u0267.ID + " has " + this.\u0268 + " lock(s) on table: " + this.\u0193 + ". " + var1_1.ID + " Waiting...");
            }
            try {
                var1_1.\u02b0 = Thread.currentThread();
                this.wait();
                if (!this.\u00ee.\u0127()) {
                    throw new SQLException("Database closed while waiting for table");
                }
                continue;
            }
            catch (InterruptedException v0) {
                throw new SQLException("Timeout detected by\n" + var1_1.toString() + "\nTrying to lock table: " + this.\u0193 + "\nLock owner: \n" + this.\u0267.toString());
            }
lbl18:
            // 2 sources

            ** while (this.\u0268 > 0 && this.\u0267 != var1_1)
        }
lbl19:
        // 1 sources

        var1_1.\u02b3(null);
        if (this.\u0268 > 0) {
            Thread.currentThread();
        } else {
            this.\u0269 = Thread.currentThread();
            this.\u026a = 0x7FFFFFFF;
            this.\u026b = 0;
            this.\u026c = 0x7FFFFFFF;
            this.\u026d.xor(this.\u026d);
        }
        this.\u0267 = var1_1;
        ++this.\u0268;
        var1_1.\u02a4(this);
        if (Trace.traceIt(16)) {
            Trace.traceOut("Trans " + var1_1.ID + " locked table: " + this.\u0193 + " Lock count=" + this.\u0268);
        }
    }

    public boolean lt(int n, int n2) {
        try {
            int n3 = 0;
            while (n3 < this.\u026f) {
                int n4 = this.\u026e[n3];
                Column column = (Column)this.\u0251.elementAt(n4);
                Object object = column.\u00c9(n2 + 1);
                int n5 = 7;
                if (column.\u00f4 == 2) {
                    n5 = 5;
                }
                if (column.\u00c5(n + 1, object, n5, true)) {
                    return true;
                }
                if (!column.\u00c5(n + 1, object, 1, true)) {
                    return false;
                }
                ++n3;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Error comparing rows during ordering: \n" + exception.getMessage());
            return false;
        }
    }

    void \u025e() {
        try {
            if (Trace.traceIt(8)) {
                Trace.traceOut(String.valueOf(this.\u0193) + " marked dirty");
            }
            boolean bl = false;
            if (this.\u0256 == null) {
                this.\u0256 = new RandomAccessFile(this.\u0255, "rw");
                this.fd = this.\u0256.getFD();
                bl = true;
            }
            this.\u0256.seek(this.\u0258);
            this.\u0256.writeInt(-1);
            this.\u0256.writeInt(0);
            if (this.fd != null) {
                this.fd.sync();
            }
            this.\u0273 = true;
            if (bl) {
                this.\u0256.close();
                this.\u0256 = null;
                this.fd = null;
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error saving row counts " + exception.toString());
        }
    }

    void \u025f() {
        Object object;
        Column column = (Column)this.\u0251.lastElement();
        this.\u0250 -= column.getLength();
        Table table = new Table(this.\u00ee.\u0125(), this.\u00ee, null, this.\u0280);
        table.\u0193 = this.\u0193;
        Integer[] integerArray = new Integer[this.\u0251.size()];
        int n = 1;
        while (n < this.\u0251.size()) {
            object = (Column)this.\u0251.elementAt(n);
            table.\u0250((Column)object);
            ((Column)object).\u00e3 = table;
            integerArray[n] = ((Column)object).\u00f0;
            ++n;
        }
        object = "DELETE FROM " + this.\u00ee.\u012f + " WHERE TableId = " + this.\u0263;
        String string = "DELETE FROM " + this.\u00ee.\u0130 + " WHERE TableId = " + this.\u0263;
        this.\u00ee.execSQL((String)object, null);
        this.\u00ee.execSQL(string, null);
        this.\u00ee.\u012b(this);
        table.\u0253(null, false);
        String string2 = "UPDATE " + this.\u00ee.\u0131 + " SET ColID = ? WHERE ColID = ?";
        SQLProg sQLProg = new SQLProg(this.\u00ee, string2, true, null);
        int n2 = 1;
        while (n2 < this.\u0251.size() - 1) {
            Column column2 = (Column)this.\u0251.elementAt(n2);
            sQLProg.setParam(1, column2.\u00f0);
            sQLProg.setParam(2, integerArray[n2]);
            sQLProg.execute();
            ++n2;
        }
        table.\u0256.seek(table.\u0259);
        int n3 = 1;
        while (n3 <= this.\u01f5) {
            int n4 = this.\u0261(n3, 0);
            System.arraycopy(this.\u025e, n4, table.\u025a, 0, this.\u0250);
            table.\u025b.\u0161();
            table.\u025b.\u018b = this.\u0250;
            table.\u025b.\u018e = this.\u0251.size() - 1;
            column.\u00eb(table.\u025b, n3, column.\u00e4(), null);
            table.\u0256.write(table.\u025a);
            this.\u025a();
            ++n3;
        }
        table.\u0256.write(-1);
        table.\u01f5 = this.\u01f5;
        table.\u0252 = this.\u0252;
        table.\u0259(1);
        table.\u0253 = this.\u0253;
        table.\u0271 = this.\u0271;
        this.\u0256.close();
        if (!this.\u0255.delete()) {
            throw new SQLException("Error deleting file: " + this.\u0255);
        }
        table.\u0256.close();
        if (!table.\u0255.renameTo(this.\u0255)) {
            throw new SQLException("Error renaming file: " + table.\u0255 + " to " + this.\u0255);
        }
        table.\u0255 = this.\u0255;
        table.\u0256 = new RandomAccessFile(table.\u0255, "rw");
        table.fd = table.\u0256.getFD();
        table.\u025e();
        if (this.\u0277 != null) {
            this.setTableEncryption(this.\u0277);
        }
    }

    synchronized boolean \u0260(String string) {
        Object object;
        Object object2;
        if (Trace.traceIt(8)) {
            Trace.traceOut("Opening table " + string);
        }
        this.\u0193 = new String(string);
        this.\u0255 = new File(this.\u0254, String.valueOf(string) + ".tbl");
        if (!this.\u0255.exists()) {
            return false;
        }
        if (this.\u00ee.\u00ea) {
            this.\u0256 = new RandomAccessFile(this.\u0255, "r");
        } else {
            this.\u0256 = new RandomAccessFile(this.\u0255, "rw");
            this.fd = this.\u0256.getFD();
        }
        if (this.\u0256.length() < 16L) {
            throw new SQLException("Invalid table file: " + this.\u0254 + File.separatorChar + string);
        }
        this.\u0275 = this.\u0256.readInt();
        if (this.\u0275 > 3) {
            throw new SQLException("Database created with a later version.");
        }
        this.\u0276 = this.\u0256.readInt();
        this.\u0258 = this.\u0256.getFilePointer();
        this.\u01f5 = this.\u0256.readInt();
        this.\u0252 = this.\u0256.readInt();
        if (this.\u01f5 == -1) {
            object2 = "Database not shut down cleanly or in use by another program.\nSet recoveryPolicy=1 for automatic recovery.";
            switch (this.\u00ee.\u0143) {
                case 1: {
                    this.\u00ee.doRecovery = true;
                    break;
                }
                case 2: {
                    if (this.\u00ee.doRecovery) break;
                    System.out.println((String)object2);
                    System.out.println("Note that it is dangerous to proceed if another\nprogram is currently accessing this database.");
                    System.out.println("Should InstantDB attempt recovery now? (y/n)");
                    object = new BufferedReader(new InputStreamReader(System.in));
                    String string2 = "";
                    while (string2.length() == 0) {
                        string2 = ((BufferedReader)object).readLine();
                    }
                    char c = string2.charAt(0);
                    if (c != 'y' && c != 'Y') break;
                    this.\u00ee.doRecovery = true;
                    break;
                }
            }
            if (this.\u00ee.doRecovery) {
                this.\u0265 = true;
            } else {
                this.\u00ee.close();
                throw new SQLException((String)object2);
            }
        }
        object2 = this.\u0251.elements();
        while (object2.hasMoreElements()) {
            object = (Column)object2.nextElement();
            ((Column)object).\u00d2(this.\u0256);
        }
        int n = this.\u0256.readInt();
        if (this.\u0250 != n) {
            throw new SQLException("Internal error header recLength=" + n + "\nComputed record length should be " + this.\u0250 + "\nTable: " + this.\u0193);
        }
        this.\u025a = new byte[this.\u0250];
        this.\u025b = new idbDataOutputStream(this.\u025a, 2 * this.\u0251.size());
        this.\u025e = new byte[this.\u0262 * this.\u0250];
        this.\u0259 = this.\u0256.getFilePointer();
        if (Trace.traceIt(8)) {
            Trace.traceOut("    Rows " + this.\u01f5 + " Deleted rows " + this.\u0252);
        }
        if (Trace.traceIt(8)) {
            Trace.traceOut("    Rec len " + this.\u0250 + " Cols " + this.\u0251.size() + " Indexes " + this.\u0253.size());
        }
        if (this.\u0265) {
            this.\u00e1();
            if (Trace.traceIt(8)) {
                Trace.traceOut("    Rows " + this.\u01f5 + " Deleted rows " + this.\u0252);
            }
            if (Trace.traceIt(8)) {
                Trace.traceOut("    Rec len " + this.\u0250 + " Cols " + this.\u0251.size() + " Indexes " + this.\u0253.size());
            }
        }
        if (this.\u0264 != 2) {
            this.\u0259(1);
        }
        this.\u00ee.\u011b(this);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int \u0261(int n, int n2) {
        int n3 = 0;
        if (this.\u0284 != null) {
            this.\u025c.reset();
            n3 = (n - this.\u0287) * this.\u0250 + n2;
            this.\u025c.skip(n3);
            if (this.\u0277 != null) {
                this.\u0257(this.\u0284, n, this.\u0287, n2);
            }
            return n2;
        }
        byte[] byArray = this.\u025e;
        synchronized (byArray) {
            while (true) {
                if (!this.\u027d) {
                    this.\u027d = true;
                    break;
                }
                try {
                    this.\u025e.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        if (n < this.\u025f || n >= this.\u025f + this.\u0260) {
            this.\u0260 = n == this.\u025f + this.\u0260 && this.\u0260 != 0 ? (n + this.\u0262 > this.\u01f5 + 1 ? this.\u01f5 - n + 1 : this.\u0262) : 1;
            this.\u025f = n;
            this.\u0256.seek(this.\u0259 + (long)((this.\u025f - 1) * this.\u0250));
            this.\u0256.read(this.\u025e, 0, this.\u0260 * this.\u0250);
            this.\u025c = new ByteArrayInputStream(this.\u025e);
            this.\u025d = new DataInputStream(this.\u025c);
        }
        this.\u025c.reset();
        n3 = (n - this.\u025f) * this.\u0250 + n2;
        this.\u025c.skip(n3);
        if (this.\u0277 != null) {
            this.\u0257(this.\u025e, n, this.\u025f, n2);
        }
        return n3;
    }

    void \u00e1() {
        long l;
        Object object;
        Column[] columnArray;
        block13: {
            if (Trace.traceIt(8)) {
                Trace.traceOut("Recovering table: " + this.\u0193);
            }
            this.\u0252 = 0;
            this.\u01f5 = 0;
            columnArray = new Column[this.\u0251.size()];
            int n = 0;
            while (n < this.\u0251.size()) {
                object = (Column)this.\u0251.elementAt(n);
                if (((Column)object).\u00f1) {
                    columnArray[n] = object;
                }
                ++n;
            }
            object = new Vector(this.getColCount());
            l = 0L;
            try {
                l = this.\u0256.length();
            }
            catch (Exception exception) {
                if (!Trace.traceIt(8)) break block13;
                Trace.traceOut("IO problem getting file length" + exception.toString());
            }
        }
        while (true) {
            block14: {
                try {
                    if (this.\u0256.length() > l) {
                        if (Trace.traceIt(4)) {
                            Trace.traceOut("Had to add new EOF marker " + this.\u0193 + " may contain invalid data.");
                        }
                        this.\u0256.seek(this.\u0256.length());
                        byte[] byArray = new byte[this.\u0250];
                        byArray[0] = -1;
                        this.\u0256.write(byArray, 0, this.\u0250);
                    }
                }
                catch (Exception exception) {
                    if (!Trace.traceIt(4)) break block14;
                    Trace.traceOut("IO problem adding EOF marker" + exception.toString());
                }
            }
            ++this.\u01f5;
            this.getRow(this.\u01f5, (Vector)object);
            int n = (Integer)((Vector)object).elementAt(0);
            if (n == -1) break;
            if ((n & 1) > 0) {
                ++this.\u0252;
            }
            int n2 = 0;
            while (n2 < columnArray.length) {
                if (columnArray[n2] != null) {
                    columnArray[n2].\u00e1(((Vector)object).elementAt(n2));
                }
                ++n2;
            }
            if (this.\u01f5 % 100 != 0 || !Trace.traceIt(32)) continue;
            Trace.traceOut(String.valueOf(this.\u01f5) + " rows recovered");
        }
        --this.\u01f5;
        this.\u0266();
    }

    void \u0262(Transaction transaction) {
        if (this.\u00ee.\u012c == null) {
            return;
        }
        if (this.\u0264 == 3) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(20);
        hashtable.put("TableName", this.\u0193);
        hashtable.put("Path", Integer.toString(this.\u0280));
        hashtable.put("RecLen", new Integer(this.\u0250));
        hashtable.put("Type", new Integer(this.\u0264));
        int n = this.\u00ee.\u012b.addRow(hashtable, transaction);
        this.\u0263 = (Integer)this.\u00ee.\u012b.getColByRow("TableID", n);
        int n2 = 0;
        while (n2 < this.\u0251.size()) {
            hashtable.clear();
            Column column = (Column)this.\u0251.elementAt(n2);
            hashtable.put("TableId", this.\u0263);
            hashtable.put("ColName", column.\u00e4);
            hashtable.put("Type", new Integer(column.\u00ed));
            hashtable.put("Offset", new Integer(column.\u00e5));
            hashtable.put("Length", new Integer(column.\u00e6));
            RowRangeCache rowRangeCache = (RowRangeCache)column.\u00f3;
            hashtable.put("CacheCond", new Integer(rowRangeCache.\u01cd));
            hashtable.put("CacheAmnt", new Integer(rowRangeCache.\u01ce));
            if (column.\u00eb != null) {
                hashtable.put("ColDefault", column.\u00eb.toString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (column.\u00e7) {
                stringBuffer.append(".PK");
            }
            if (column.\u00e8) {
                stringBuffer.append(".UNIQ");
            }
            if (column.\u00e9) {
                stringBuffer.append(".~NULL");
            }
            hashtable.put("Flags", stringBuffer.toString());
            n = this.\u00ee.\u012c.addRow(hashtable, transaction);
            column.\u00f0 = (Integer)this.\u00ee.\u012c.getColByRow("ColID", n);
            ++n2;
        }
        try {
            this.\u00ee.\u012c.fd.sync();
            this.\u00ee.\u012b.fd.sync();
            this.fd.sync();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    void \u0263(idbTrigger idbTrigger2) {
        this.\u0271.removeElement(idbTrigger2);
        if (this.\u0271.size() == 0) {
            this.\u0271 = null;
        }
    }

    void \u0264(long l) {
        if (this.\u0271 != null) {
            int n = 0;
            while (n < this.\u0271.size()) {
                idbTrigger idbTrigger2 = (idbTrigger)this.\u0271.elementAt(n);
                if ((idbTrigger2.getEvents() & 8) > 0) {
                    idbTrigger2.onRollback(l);
                }
                ++n;
            }
        }
    }

    boolean rowDeleted(int n) {
        if (this.\u0252 == 0) {
            return false;
        }
        if (this.\u00f4 != null) {
            n = this.\u00f4[n - 1] + 1;
        }
        return this.\u0257.\u00dd(n);
    }

    String \u0265(int n, boolean bl) {
        int n2 = this.\u0251.size();
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Row " + n);
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0 || bl) {
                Column column = (Column)this.\u0251.elementAt(n3);
                try {
                    Object object = column.\u00c9(n);
                    stringBuffer.append(' ');
                    if (object instanceof String) {
                        stringBuffer.append(object.toString());
                    } else {
                        stringBuffer.append(column.toString(object));
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    void \u0266() {
        try {
            this.\u025e();
            int n = 0;
            while (n < this.\u0251.size()) {
                Column column = (Column)this.\u0251.elementAt(n);
                column.\u00d4(this.\u0256);
                ++n;
            }
            this.\u0256.seek(this.\u0258);
            this.\u0256.writeInt(this.\u01f5);
            this.\u0256.writeInt(this.\u0252);
            if (this.fd != null) {
                this.fd.sync();
            }
            if (Trace.traceIt(8)) {
                Trace.traceOut(String.valueOf(this.\u0193) + " marked OK");
            }
            this.\u0273 = false;
        }
        catch (Exception exception) {
            throw new SQLException("Error saving row counts " + exception.toString());
        }
    }

    public void setOrder(int[] nArray) {
        this.\u00f4 = nArray;
    }

    void setTableEncryption(TableEncrypt tableEncrypt) {
        this.\u0277 = tableEncrypt;
        this.\u0278 = new byte[this.\u0250];
        this.\u0279 = new int[this.\u0251.size()];
        int n = 0;
        while (n < this.\u0251.size()) {
            Column column = (Column)this.\u0251.elementAt(n);
            this.\u0279[n] = column.\u00e7();
            ++n;
        }
    }

    void \u0267() {
        this.\u0254 = this.\u00ee.\u011d;
        if (this instanceof indexTable && this.\u00ee.\u011e != null) {
            this.\u0254 = this.\u00ee.\u011e;
        }
        if (this.\u0280 > 0) {
            this.\u0254 = this.\u00ee.\u0122.getStringAt(this.\u0280 - 1);
        }
        if (this.\u0264 == 3 && this.\u00ee.\u011f != null) {
            this.\u0254 = this.\u00ee.\u011f;
        }
    }

    public void swap(int n, int n2) {
        try {
            Vector vector = new Vector(this.\u0251.size());
            this.getRow(n + 1, vector);
            Vector vector2 = new Vector(this.\u0251.size());
            this.getRow(n2 + 1, vector2);
            this.\u0197(vector2, n + 1, null);
            this.\u0197(vector, n2 + 1, null);
            if (this.\u00ee.\u00ea) {
                this.\u01f5 -= 2;
            }
        }
        catch (Exception exception) {
            System.out.println("Error swapping rows during ordering: \n" + exception.getMessage());
        }
    }

    void \u0268(boolean bl) {
        if (this.\u0286 != 0) {
            long l = this.\u0259 + (long)((this.\u0287 - 1) * this.\u0250);
            this.\u0256.seek(l);
            this.\u0256.write(this.\u0284, 0, this.\u0286);
            this.\u0286 = 0;
            byte by = this.\u025a[0];
            this.\u025a[0] = -1;
            this.\u0256.write(this.\u025a, 0, this.\u0250);
            if (this.fd != null) {
                this.fd.sync();
            }
            this.\u025a[0] = by;
        }
        if (bl) {
            this.\u0284 = null;
            this.\u0260 = 0;
        }
    }
}

