/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.BlobColumn;
import db.IdbVector;
import db.SQLProg;
import db.Trace;
import db.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import jdbc.idbConnection;
import jdbc.idbResultsSet;
import jdbc.idbStatement;

public class idbPreparedStatement
extends idbStatement
implements PreparedStatement {
    SQLProg \u02b7;

    idbPreparedStatement(idbConnection idbConnection2, String string, int n) {
        super(idbConnection2, n);
        this.\u02b7 = new SQLProg(this.db, string, true, idbConnection2.\u01ec);
        this.\u0396("Created " + string);
    }

    public void addBatch() throws SQLException {
        if (this.\u03b3 == null) {
            this.\u03b3 = new IdbVector(5, 5);
        }
        this.\u03b3.addElement(this.\u02b7.getParams());
    }

    public synchronized void clearParameters() throws SQLException {
        this.\u02b7.clearParameters();
    }

    public synchronized boolean execute() throws SQLException {
        this.\u0396("execute");
        this.\u03a5();
        this.\u02b8 = this.\u01b1.\u01ec.allocateSqlID();
        Transaction transaction = this.\u01b1.\u01ec;
        synchronized (transaction) {
            this.\u03ad();
            this.\u01b1.\u0394(this.\u02b8);
            this.\u02b7.setMaxRows(this.\u01fb);
            boolean bl = this.\u01b1.\u039c;
            this.\u01b1.\u039c = false;
            try {
                this.db.addToTimerQueue(this.\u01b1.\u01ec, this.\u03b0);
                this.\u02b7.execute();
            }
            finally {
                Object var5_3 = null;
                if (this.\u03b0 != 0) {
                    this.db.removeFromTimerQueue(this.\u01b1.\u01ec);
                }
                this.\u01b1.\u039c = bl;
            }
        }
        this.\u01f5 = this.\u02b7.getRowCount();
        if (this.\u01f5 == -1) {
            this.\u01f3 = this.\u02b7.getResultSet();
            if (this.\u01f3 != null) {
                this.\u03ad = new idbResultsSet(this, this.\u01f3, this.\u02b8);
                this.\u0396(String.valueOf(this.\u01f3.getRowCount()) + " rows returned");
                if (this.\u03b2 == 1007) {
                    this.\u01b1.\u0394(this.\u02b8);
                }
                return true;
            }
        } else {
            this.\u01b1.\u0394(this.\u02b8);
            this.\u0396(String.valueOf(this.\u01f5) + " rows modified");
        }
        return false;
    }

    public int[] executeBatch() throws SQLException {
        int n = this.getBatchCount();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            boolean bl = false;
            try {
                Object[] objectArray = (Object[])this.\u03b3.elementAt(n3);
                this.\u02b7.setParams(objectArray);
                bl = this.execute();
                if (bl) {
                    throw new Exception("Cannot perform queries in batch updates");
                }
                ++n2;
            }
            catch (Exception exception) {
                this.clearBatch();
                int[] nArray2 = new int[n2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                throw new BatchUpdateException(exception.toString(), nArray2);
            }
            ++n3;
        }
        this.clearBatch();
        return nArray;
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        this.\u0396("executeQuery");
        this.\u03a5();
        this.\u03b1 = true;
        this.execute();
        this.\u03b1 = false;
        int n = 0;
        if (this.\u01f3 != null) {
            n = this.\u01f3.getRowCount();
        }
        this.\u0396(String.valueOf(n) + " rows updated");
        return this.\u03ad;
    }

    public synchronized int executeUpdate() throws SQLException {
        this.\u0396("executeUpdate");
        this.\u03a5();
        this.\u03b1 = true;
        this.execute();
        this.\u03b1 = false;
        int n = this.\u01f5;
        if (n == -1) {
            n = 0;
        }
        this.\u0396(String.valueOf(n) + " rows updated");
        return n;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Not implemented");
    }

    private synchronized void \u03a1(int n, Object object) {
        this.\u02b7.setParam(n, object);
    }

    private void \u03a3(int n, InputStream inputStream, int n2, byte by) {
        byte[] byArray = new byte[n2 + 1];
        byArray[0] = by;
        try {
            inputStream.read(byArray, 1, n2);
        }
        catch (IOException iOException) {
            throw new SQLException("Error reading from stream: \n" + iOException.getMessage());
        }
        this.\u03a1(n, byArray);
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2 * n2 + 1);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(BlobColumn.STRING_BLOB);
            int n3 = 0;
            while (n3 < n2) {
                char c = (char)inputStream.read();
                dataOutputStream.writeChar(c);
                ++n3;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.\u03a1(n, byArray);
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem: \n" + iOException.getMessage());
        }
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + bigDecimal);
        this.setObject(n, bigDecimal);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + inputStream);
        this.\u03a3(n, inputStream, n2, BlobColumn.BINARY_BLOB);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        this.\u0396("setBoolean: index=" + n + " value=" + bl);
        this.setObject(n, new Boolean(bl));
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + by);
        this.setObject(n, new Integer(by));
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + byArray);
        this.setObject(n, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + date);
        this.setObject(n, date.toString());
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + d);
        this.setObject(n, new Double(d));
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + f);
        this.setObject(n, new Float(f));
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + n2);
        this.setObject(n, new Integer(n2));
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + l);
        this.setObject(n, new Long(l));
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        this.\u0396("setNULL: index=" + n + " sqlType=" + n2);
        this.setObject(n, "NULL");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + object);
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = BlobColumn.BINARY_BLOB;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            object = byArray2;
        }
        this.\u03a1(n, object);
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + object);
        this.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + object);
        this.setObject(n, object);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + s);
        this.setObject(n, new Integer(s));
    }

    public synchronized void setString(int n, String string) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + string);
        this.setObject(n, string);
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + time);
        this.setObject(n, time.toString());
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + timestamp);
        this.setObject(n, timestamp.toString());
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.\u0396("set: index=" + n + " value=" + inputStream);
        this.\u03a3(n, inputStream, n2, BlobColumn.STRING_BLOB);
    }

    private void \u0396(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut(" Prp " + this.id + " " + string);
        }
    }
}

