/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.BlobColumn;
import db.Column;
import db.Table;
import db.Trace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jdbc.idbConnection;
import jdbc.idbResultSetMetaData;
import jdbc.idbStatement;

public class idbResultsSet
implements ResultSet {
    static int \u0394;
    Table \u03a4;
    int \u017f;
    int \u010c;
    Vector \u03a5;
    Vector insertRow;
    idbResultSetMetaData \u039a;
    idbStatement \u03a6;
    int id;
    idbConnection \u01b1;
    boolean \u0124;
    boolean \u03a7;
    boolean \u03a8;
    int \u02b8;
    static final String[] \u03a9;
    int \u03aa = 0;
    int \u03ab = 0;

    static {
        \u03a9 = new String[]{"T", "TRUE", "Y", "YES"};
    }

    idbResultsSet(idbStatement idbStatement2, Table table, int n) {
        this.\u03a4 = table;
        this.\u017f = this.\u03a4.getRowCount();
        this.\u03a6 = idbStatement2;
        this.\u01b1 = idbStatement2.\u01b1;
        this.\u02b8 = n;
        this.\u03a5 = new Vector(table.getColCount());
        n = ++\u0394;
        this.\u039a = new idbResultSetMetaData(this.\u03a4);
        if (this.\u017f == 0) {
            this.\u01b1.\u0394(this.\u02b8);
        }
        this.\u0396("created: rows,cols=" + this.\u017f + "," + table.getColCount());
    }

    public boolean absolute(int n) throws SQLException {
        this.\u0396("absolute: row=" + n);
        if (this.\u017f == 0) {
            return false;
        }
        if (n == 0 || n < -1 * this.\u017f) {
            this.\u010c = 0;
            this.\u03a5.removeAllElements();
            return false;
        }
        if (n > this.\u017f) {
            this.\u010c = this.\u017f + 1;
            this.\u03a5.removeAllElements();
            return false;
        }
        this.\u010c = n > 0 ? n - 1 : this.\u017f + n;
        this.next();
        return true;
    }

    public void afterLast() throws SQLException {
        this.absolute(this.\u017f + 1);
    }

    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    public void cancelRowUpdates() throws SQLException {
        this.moveToCurrentRow();
        this.insertRow = null;
    }

    void \u03a5() {
        if (this.\u0124) {
            throw new SQLException("results set is closed");
        }
    }

    synchronized boolean \u03a6(int n) {
        this.\u03a7 = false;
        if (this.\u039a == null || this.\u03a5.size() == 0) {
            return this.\u03a7;
        }
        Column column = this.\u039a.\u0185[n];
        Object e = this.\u03a5.elementAt(n);
        if (e == null) {
            return true;
        }
        if (column.isNull(e)) {
            this.\u03a7 = true;
        }
        return this.\u03a7;
    }

    void \u03a7() {
        if (this.\u010c > 0 && this.\u010c <= this.\u017f) {
            return;
        }
        if (!this.\u03a8) {
            return;
        }
        throw new SQLException("Not positioned on a row");
    }

    boolean \u03a8(int n) {
        return this.\u010c == n;
    }

    Table \u03a9() {
        Table table = this.\u03a4.getUnderlyingTable();
        if (table == null) {
            throw new SQLException("Result set is not updatable");
        }
        return table;
    }

    public synchronized void clearWarnings() throws SQLException {
    }

    public synchronized void close() throws SQLException {
        this.\u0396("close");
        if (this.\u0124) {
            return;
        }
        this.\u03a5();
        this.\u01b1.\u0394(this.\u02b8);
        this.\u0124 = true;
        if (this.\u03a4.getTableType() == 3) {
            this.\u03a4.dropTable(null);
        }
        this.\u03a4 = null;
        this.\u03a5 = null;
        this.\u039a = null;
        this.\u01b1 = null;
    }

    public void deleteRow() throws SQLException {
        this.\u03a7();
        Table table = this.\u03a9();
        int n = this.\u03a4.getUnderlyingRow(this.\u010c);
        table.deleteRow(n, this.\u01b1.\u01ec);
    }

    protected void finalize() throws Throwable {
        if (!this.\u0124) {
            this.close();
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.\u03a5();
        int n = 1;
        while (n <= this.\u039a.getColumnCount()) {
            String string2 = this.\u039a.getColumnName(n);
            if (string2.equalsIgnoreCase(string)) {
                this.\u0396("findColumn: " + string + " Result=" + n);
                return n;
            }
            ++n;
        }
        int n2 = 1;
        while (n2 <= this.\u039a.getColumnCount()) {
            String string3 = this.\u039a.getColumnName(n2);
            int n3 = string3.indexOf(46);
            if (n3 != -1) {
                string3 = string3.substring(n3 + 1);
            }
            if (string3.equalsIgnoreCase(string)) {
                this.\u0396("findColumn: " + string + " Result=" + n2);
                return n2;
            }
            ++n2;
        }
        int n4 = string.indexOf(46);
        if (n4 != -1) {
            String string4 = string.substring(n4 + 1);
            return this.findColumn(string4);
        }
        throw new SQLException("Column not found: " + string);
    }

    public boolean first() throws SQLException {
        this.\u0396("first");
        return this.absolute(1);
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return null;
        }
        Object e = this.\u03a5.elementAt(n);
        this.\u0396("getBigDecimal: index=" + n + " result=" + e);
        if (e instanceof String) {
            return new BigDecimal((String)e);
        }
        BigDecimal bigDecimal = new BigDecimal(((Number)e).doubleValue());
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), 0);
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        ByteArrayInputStream byteArrayInputStream = null;
        if (byArray != null) {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        this.\u0396("getBinaryStream: index=" + n);
        return byteArrayInputStream;
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        boolean bl;
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return false;
        }
        Object e = this.\u03a5.elementAt(n);
        if (e instanceof String) {
            String string = (String)e;
            int n2 = 0;
            while (n2 < \u03a9.length) {
                if (string.equalsIgnoreCase(\u03a9[n2])) {
                    bl = true;
                }
                ++n2;
            }
            bl = false;
        } else {
            Number number;
            bl = e instanceof Boolean ? (Boolean)e : (number = (Number)e).intValue() != 0;
        }
        this.\u0396("getBoolean: index=" + n + " result=" + bl);
        return bl;
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return 0;
        }
        byte by = (byte)this.getInt(n);
        this.\u0396("getByte: index=" + n + " result=" + by);
        return by;
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.\u0396("getBytes: index=" + n);
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return null;
        }
        Object object = this.\u03a5.elementAt(n);
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = string.getBytes();
            return byArray;
        }
        if (object instanceof Double) {
            long l = Double.doubleToLongBits((Double)object);
            object = new Long(l);
        }
        if (object instanceof Long) {
            byte[] byArray = new byte[8];
            long l = (Long)object;
            this.\u03aa((int)(l & 0xFFFFFFFFFFFFFFFFL), byArray, 0);
            this.\u03aa((int)l >> 32, byArray, 3);
            return byArray;
        }
        if (object instanceof Float) {
            int n2 = Float.floatToIntBits(((Float)object).floatValue());
            object = new Integer(n2);
        }
        if (object instanceof Integer) {
            byte[] byArray = new byte[4];
            int n3 = (Integer)object;
            this.\u03aa(n3, byArray, 0);
            return byArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        return null;
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public synchronized int getCurRow() {
        return this.\u010c + 1;
    }

    public synchronized String getCursorName() throws SQLException {
        return null;
    }

    public synchronized Date getDate(int n) throws SQLException {
        long l = this.getLong(n);
        if (this.\u03a7) {
            return null;
        }
        return new Date(l);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return 0.0;
        }
        Object object = this.\u03a5.elementAt(n);
        this.\u0396("getDouble: index=" + n + " result=" + object);
        if (object instanceof String) {
            object = new Double((String)object);
        }
        double d = ((Number)object).doubleValue();
        return d;
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        return this.\u03aa;
    }

    public int getFetchSize() throws SQLException {
        return this.\u03ab;
    }

    public synchronized float getFloat(int n) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return 0.0f;
        }
        Object object = this.\u03a5.elementAt(n);
        this.\u0396("getFloat: index=" + n + " result=" + object);
        if (object instanceof String) {
            object = new Float((String)object);
        }
        float f = ((Number)object).floatValue();
        return f;
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized int getInt(int n) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return 0;
        }
        Object object = this.\u03a5.elementAt(n);
        this.\u0396("getInt: index=" + n + " result=" + object);
        if (object instanceof String) {
            object = new Integer((String)object);
        }
        int n2 = ((Number)object).intValue();
        return n2;
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized long getLong(int n) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return 0L;
        }
        Object object = this.\u03a5.elementAt(n);
        this.\u0396("getLong: index=" + n + " result=" + object);
        if (object instanceof String) {
            object = new Long((String)object);
        }
        long l = ((Number)object).longValue();
        return l;
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.\u0396("getMetaData");
        this.\u03a5();
        return this.\u039a;
    }

    public synchronized Object getObject(int n) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return null;
        }
        Object object = this.\u03a5.elementAt(n);
        Column column = this.\u039a.\u0185[n];
        if (column.getType() == 5) {
            object = this.getDate(n);
        }
        if (!(object instanceof byte[])) {
            this.\u0396("getObject: index=" + n + " result=" + object);
            return object;
        }
        try {
            Object object2;
            byte[] byArray = (byte[])object;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.readByte();
            if (byArray[0] == BlobColumn.STRING_BLOB) {
                object2 = new StringBuffer(byArray.length / 2);
                while (dataInputStream.available() > 1) {
                    char c = dataInputStream.readChar();
                    ((StringBuffer)object2).append(c);
                }
                object = ((StringBuffer)object2).toString();
            } else if (byArray[0] == BlobColumn.OBJECT_BLOB) {
                object2 = new ObjectInputStream(byteArrayInputStream);
                try {
                    object = ((ObjectInputStream)object2).readObject();
                }
                catch (Exception exception) {}
            }
            if (object instanceof byte[]) {
                object2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, object2, 0, byArray.length - 1);
                object = object2;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.\u0396("getObject: index=" + n + " result=" + object);
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public int getRow() throws SQLException {
        if (this.isAfterLast()) {
            return 0;
        }
        return this.\u010c;
    }

    public synchronized int getRowCount() {
        return this.\u017f;
    }

    public synchronized short getShort(int n) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        if (this.\u03a6(n)) {
            return 0;
        }
        short s = (short)this.getInt(n);
        this.\u0396("getShort: index=" + n + " result=" + s);
        return s;
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        return this.\u03a6;
    }

    public synchronized String getString(int n) throws SQLException {
        this.\u03a5();
        if (this.\u03a5.size() == 0) {
            throw new SQLException("No rows fetched");
        }
        Column column = this.\u039a.\u0185[n];
        Object e = this.\u03a5.elementAt(n);
        if (this.\u03a6(n)) {
            return null;
        }
        String string = column.toString(e);
        this.\u0396("getString: " + string);
        return string;
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized Time getTime(int n) throws SQLException {
        long l = this.getLong(n);
        if (this.\u03a7) {
            return null;
        }
        return new Time(l);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        long l = this.getLong(n);
        if (this.\u03a7) {
            return null;
        }
        return new Timestamp(l);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void insertRow() throws SQLException {
        Table table = this.\u03a9();
        int n = this.\u039a.getColumnCount();
        Hashtable hashtable = new Hashtable(n, 0.5f);
        int n2 = 1;
        while (n2 <= n) {
            String string = this.\u039a.getColumnName(n2);
            Object e = this.\u03a5.elementAt(n2);
            if (e != null) {
                hashtable.put(string, e);
            }
            ++n2;
        }
        table.addRow(hashtable, this.\u01b1.\u01ec);
        this.cancelRowUpdates();
    }

    void \u03aa(int n, byte[] byArray, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            byArray[n3 + n2] = (byte)(n & 0xFF);
            n >>= 8;
            ++n3;
        }
    }

    public boolean isAfterLast() throws SQLException {
        return this.\u03a8(this.\u017f + 1);
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.\u03a8(0);
    }

    public boolean isFirst() throws SQLException {
        return this.\u03a8(1);
    }

    public boolean isLast() throws SQLException {
        return this.\u03a8(this.\u017f);
    }

    public boolean last() throws SQLException {
        this.\u0396("last");
        return this.absolute(this.\u017f);
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.\u03a8) {
            this.\u03a8 = false;
            this.insertRow = (Vector)this.\u03a5.clone();
            if (this.\u010c > 0 && this.\u010c <= this.\u017f) {
                this.\u03a4.getRow(this.\u010c, this.\u03a5);
            }
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.\u03a8 = true;
        if (this.insertRow == null) {
            int n = this.\u039a.getColumnCount();
            this.insertRow = new Vector(n + 1);
            this.insertRow.setSize(n + 1);
        }
        this.\u03a5 = this.insertRow;
    }

    public synchronized boolean next() throws SQLException {
        this.\u0396("next: curRow=" + this.\u010c);
        this.\u03a5();
        this.clearWarnings();
        if (++this.\u010c > this.\u017f) {
            this.\u03a5.removeAllElements();
            return false;
        }
        this.\u03a4.getRow(this.\u010c, this.\u03a5);
        return true;
    }

    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    void \u03ab(int n, InputStream inputStream, int n2, int n3) {
        this.\u03ac();
        byte[] byArray = new byte[n2 + 1];
        byArray[0] = (byte)n3;
        try {
            inputStream.read(byArray, 1, n2);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.\u03a5.setElementAt(byArray, n);
    }

    public void refreshRow() throws SQLException {
        this.\u03a7();
        this.\u03a4.getRow(this.\u010c, this.\u03a5);
    }

    public boolean relative(int n) throws SQLException {
        this.\u0396("relative: row=" + n);
        int n2 = this.\u010c + n;
        if (n2 < 0) {
            n2 = 0;
        }
        return this.absolute(this.\u010c + n);
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setCurRow(int n) throws SQLException {
        if (n < 1 || n > this.\u017f) {
            throw new SQLException("Row number " + n + " is out of range");
        }
        this.\u010c = n - 1;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.\u03aa = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.\u03ab = n;
    }

    void \u0396(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut("  Res " + this.id + " " + string);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.\u03ab(n, inputStream, n2, BlobColumn.STRING_BLOB);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(bigDecimal, n);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.\u03ab(n, inputStream, n2, BlobColumn.BINARY_BLOB);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(new Integer(1), n);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(new Byte(by), n);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.\u03ac();
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = BlobColumn.BINARY_BLOB;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        this.\u03a5.setElementAt(byArray, n);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.\u03ac();
        char[] cArray = new char[n2];
        try {
            reader.read(cArray);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.\u03a5.setElementAt(new String(cArray), n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    void \u03ac() {
        if (this.getRow() == 0 && !this.\u03a8) {
            throw new SQLException("Not positioned on a row");
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(date, n);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(new Double(d), n);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(new Float(f), n);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(new Integer(n2), n);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(new Long(l), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(null, n);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.\u03ac();
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = BlobColumn.BINARY_BLOB;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            object = byArray2;
        }
        this.\u03a5.setElementAt(object, n);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        this.\u03a7();
        Table table = this.\u03a9();
        Vector vector = new Vector(table.getColCount());
        table.getRow(this.\u010c, vector);
        int n = this.\u039a.getColumnCount();
        int n2 = 1;
        while (n2 <= n) {
            String string = this.\u039a.getColumnName(n2);
            Object e = this.\u03a5.elementAt(n2);
            int n3 = table.getColIndex(string);
            if (n3 == -1) {
                throw new SQLException("Column " + string + " not found in table " + table.getTableName());
            }
            vector.setElementAt(e, n3);
            ++n2;
        }
        vector.setElementAt(new Integer(0), 0);
        this.deleteRow();
        table.addRow(vector, this.\u01b1.\u01ec);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(new Short(s), n);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(string, n);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(time, n);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.\u03ac();
        this.\u03a5.setElementAt(timestamp, n);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public synchronized boolean wasNull() throws SQLException {
        this.\u0396("wasNull: " + this.\u03a7);
        this.\u03a5();
        return this.\u03a7;
    }
}

