/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Cache;
import db.Database;
import db.RowRangeCache;
import db.Table;
import db.Transaction;
import db.idbDataOutputStream;
import db.indexTable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

public abstract class Column {
    Table \u00e3;
    String \u00e4;
    int \u00e5;
    int \u00e6;
    boolean \u00e7;
    boolean \u00e8;
    boolean \u00e9;
    boolean \u00ea;
    Object \u00eb;
    Object \u00ec;
    int \u00ed;
    Database \u00ee;
    Object \u00ef;
    Integer \u00f0;
    boolean \u00f1;
    boolean \u00f2;
    Cache \u00f3;
    int \u00f4;
    long \u00f5;
    Table \u00f6;
    static int \u00f8;
    static final int \u00f9 = 1;
    static final int \u00fa = 2;
    static final int \u00fb = 3;
    static final int \u00fc = 4;
    static final int \u00fd = 5;
    static final int \u00fe = 6;
    static final int \u00ff = 7;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_DATE = 5;
    public static final int TYPE_CURRENCY = 6;
    public static final int TYPE_FLOAT = 7;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_INDEX = 9;
    public static final int TYPE_BLOB = 10;
    public static final int TYPE_CHAR1 = 11;
    static final int \u0100 = 0;
    static final int \u0101 = 1;
    static final int \u0102 = 2;
    public static final int[] SQL_TYPES;
    public static final String[] typeNames;

    static {
        int[] nArray = new int[11];
        nArray[1] = -6;
        nArray[2] = 4;
        nArray[3] = 12;
        nArray[4] = -5;
        nArray[5] = 91;
        nArray[6] = -5;
        nArray[7] = 6;
        nArray[8] = 6;
        nArray[9] = 1111;
        nArray[10] = -4;
        SQL_TYPES = nArray;
        typeNames = new String[]{"", "BYTE", "INTEGER", "CHAR", "LONG", "DATE", "CURRENCY", "FLOAT", "DOUBLE", "INDEX", "BINARY"};
    }

    Column(Table table, String string, int n) throws SQLException {
        this.\u00e4 = new String(string);
        this.\u00ee = table.\u00ee;
        this.\u00e6 = n;
        table.\u0250(this);
        this.\u00e3 = table;
        this.\u00f3 = new RowRangeCache();
        this.\u00f3.setRange(this, 1, 0);
        if (this.\u00e3.\u0256 == null) {
            this.\u00f3.setCacheCondition(2, 100);
        }
    }

    boolean \u00e3(Object object, Object object2) {
        String string;
        if (object != null && !(string = object instanceof Table ? ((Table)object).getTableName() : (String)object).equalsIgnoreCase(this.\u00e3.getTableName())) {
            return false;
        }
        String string2 = object2 instanceof Column ? ((Column)object2).getName() : (String)object2;
        return string2.equalsIgnoreCase(this.\u00e4);
    }

    public boolean allowsNull() {
        return this.\u00e9 ^ true;
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(this.\u00f5);
    }

    abstract boolean \u00c5(int var1, Object var2, int var3, boolean var4) throws SQLException;

    Object \u00c9(int n) throws SQLException {
        if (n == 0) {
            return String.valueOf(this.\u00e4) + '(' + typeNames[this.\u00ed] + ')';
        }
        ++\u00f8;
        Object object = this.\u00f3.get(n);
        if (object != null) {
            return object;
        }
        try {
            this.\u00e3.\u0261(n, this.\u00e5);
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
        }
        return null;
    }

    public int getColID() {
        return this.\u00f0;
    }

    Object \u00e4() {
        return this.\u00eb;
    }

    abstract int \u00ca(Object var1);

    public Object getLastValueInserted() {
        return this.\u00ec;
    }

    public int getLength() {
        return this.\u00e6;
    }

    public String getName() {
        return this.\u00e4;
    }

    Object \u00e5() {
        return this.\u00ef;
    }

    int \u00e6() {
        return this.\u00ca(this.\u00ef);
    }

    int \u00e7() {
        return this.\u00e5;
    }

    int getRowByValue(Object object, int n) throws SQLException {
        int n2 = 1;
        int n3 = this.\u00e3.\u01f5;
        indexTable indexTable2 = this.\u00e3.\u025c(this);
        if (indexTable2 != null) {
            int[] nArray = indexTable2.\u01a8(object, true);
            if (nArray == null) {
                return 0;
            }
            n2 = nArray[0];
            n3 = nArray[1];
        }
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = n4;
            if (indexTable2 != null) {
                n5 = indexTable2.\u01a2(n4);
            }
            if (n5 != n && this.\u00c5(n5, object, 1, false) && !this.\u00e3.rowDeleted(n5)) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public int getRowCount() {
        return this.\u00e3.getRowCount();
    }

    Table getTable() {
        return this.\u00e3;
    }

    public int getType() {
        return this.\u00ed;
    }

    Table getUnderlyingTable() {
        return this.\u00f6;
    }

    boolean \u00e8() {
        return this.\u00e3.\u025c(this) != null;
    }

    abstract boolean \u00cc();

    public boolean inPrimaryKey() {
        return this.\u00e7;
    }

    public abstract boolean isAutoIncrement();

    public abstract boolean isNull(Object var1);

    public boolean isReadOnly() {
        return this.\u00ea;
    }

    abstract boolean \u00cd();

    void \u00d0() {
        if (this.\u00f3 == null) {
            return;
        }
        this.\u00f3 = null;
    }

    void onDelete(RandomAccessFile randomAccessFile, int n, Transaction transaction) throws SQLException {
    }

    void \u00d1() {
    }

    void \u00d2(RandomAccessFile randomAccessFile) throws IOException {
        this.\u00f5 = randomAccessFile.getFilePointer();
    }

    void \u00e1(Object object) {
    }

    void \u00e9(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.\u00e7 = bl;
                break;
            }
            case 2: {
                this.\u00e8 = bl;
                break;
            }
            case 3: {
                this.\u00e9 = bl;
                break;
            }
            case 6: {
                this.\u00f2 = bl;
                break;
            }
        }
    }

    void setCacheCondition(int n, int n2) {
        this.setCacheCondition(n, n2, false);
    }

    void setCacheCondition(int n, int n2, boolean bl) {
        if (this.\u00e3.\u0256 == null && !bl) {
            return;
        }
        this.\u00f3.setCacheCondition(n, n2);
    }

    void \u00ea(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Column offset must be positive");
        }
        this.\u00e5 = n;
    }

    void \u00df(int n, Object object) {
        switch (n) {
            case 4: {
                this.\u00eb = object;
                break;
            }
        }
    }

    final void \u00eb(idbDataOutputStream idbDataOutputStream2, int n, Object object, Transaction transaction) throws SQLException {
        int n2;
        Object object2;
        if (object instanceof String && ((String)(object2 = (String)object)).equalsIgnoreCase("NULL")) {
            object = null;
        }
        if ((object2 = this.\u00d3(object)) == null) {
            throw new SQLException("Column " + this.\u00e4 + " cannot accept value " + object);
        }
        if (object2 == this.\u00ef && this.\u00e9) {
            throw new SQLException(String.valueOf(this.\u00e4) + " column does not allow nulls", "XOPEN?");
        }
        if (this.\u00e8 && object2 != this.\u00ef && (n2 = this.getRowByValue(object2, n)) != 0) {
            throw new SQLException("Value " + object2 + " already exists in column " + this.\u00e3.getTableName() + "." + this.\u00e4);
        }
        try {
            if (idbDataOutputStream2 != null) {
                this.\u00d5(idbDataOutputStream2, object2, transaction, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
        }
        this.\u00f3.add(object2, n);
        this.\u00ec = object2;
    }

    void \u00ec(Table table) {
        this.\u00f6 = table;
    }

    abstract Object \u00d3(Object var1);

    public abstract String toString(Object var1);

    void \u00d4(RandomAccessFile randomAccessFile) throws IOException {
        this.\u00f5 = randomAccessFile.getFilePointer();
    }

    abstract void \u00d5(idbDataOutputStream var1, Object var2, Transaction var3, int var4) throws IOException;
}

