/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BlobColumn;
import db.ByteColumn;
import db.Column;
import db.CurrencyColumn;
import db.Database;
import db.DateColumn;
import db.DoubleColumn;
import db.FloatColumn;
import db.Importer;
import db.IntegerColumn;
import db.LongColumn;
import db.StringColumn;
import db.Table;
import db.Transaction;
import db.matchedTokens;
import db.tokenList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

class FileImporter
implements Importer {
    boolean \u0178 = false;
    String \u0179 = ",";
    Vector \u017a = null;
    boolean \u017b = false;
    String \u017c = null;
    boolean \u017d = false;
    BufferedReader \u017e = null;
    int \u017f;
    tokenList \u0180;
    matchedTokens \u0181;
    int[] \u0182 = null;
    boolean \u0183;
    Table \u0184;
    Vector \u0185;

    FileImporter(Table table, String string, String string2, Transaction transaction, Database database) {
        int n;
        boolean bl;
        FileReader fileReader;
        File file;
        BufferedReader bufferedReader = null;
        if (string2 != null) {
            file = this.\u0179(string2, database.\u0126);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
        }
        file = this.\u0179(string, database.\u0126);
        fileReader = new FileReader(file);
        this.\u017e = new BufferedReader(fileReader);
        String string3 = file.getName();
        this.\u0184 = table;
        boolean bl2 = bl = table.getColCount() > 1;
        if (!bl && bufferedReader == null) {
            throw new SQLException("IMPORT must use a schema file for non-existent tables");
        }
        if (bufferedReader != null) {
            n = 0;
            while (bufferedReader.ready() && n < 2) {
                String string4;
                if (this.\u0181 != null) {
                    this.\u0181.finalize();
                }
                this.\u017c = bufferedReader.readLine();
                this.\u0180 = new tokenList(this.\u017c, false);
                if (this.\u0180.\u018a() == 0) continue;
                this.\u0181 = new matchedTokens(this.\u0180, Database.\u014e, database);
                if (n == 0) {
                    String string5;
                    if (!this.\u0181.\u01bf("header") || !(string4 = String.valueOf(string5 = (String)this.\u0181.get("tableName")) + "." + (String)this.\u0181.get("extension")).equalsIgnoreCase(string3)) continue;
                    n = 1;
                    continue;
                }
                if (n != 1) continue;
                if (this.\u0181.\u01bf("header")) {
                    n = 2;
                    break;
                }
                if (this.\u0181.\u01bf("header_spec") && this.\u0181.\u01bf("TRUE")) {
                    this.\u017d = true;
                }
                if (this.\u0181.\u01bf("format_spec")) {
                    if (this.\u0181.\u01bf("FIXEDLENGTH")) {
                        this.\u0178 = true;
                        this.\u017a = new Vector(10, 5);
                    }
                    if (this.\u0181.\u01bf("DELIMITED")) {
                        this.\u0179 = (String)this.\u0181.get("delimiter");
                    }
                    if (this.\u0181.\u01bf("CSVDELIMITED")) {
                        this.\u0179 = ",";
                    }
                    if (this.\u0181.\u01bf("TABDELIMITED")) {
                        this.\u0179 = "\t";
                    }
                    if (this.\u0181.\u01bf("AUTO")) {
                        this.\u0179 = "AUTO";
                    }
                    if (this.\u0181.\u01bf("STRICT")) {
                        this.\u017b = true;
                    }
                }
                if (!this.\u0181.\u01bf("col_spec")) continue;
                int n2 = 1;
                if (this.\u0181.\u01bf("WIDTH")) {
                    string4 = (String)this.\u0181.get("length");
                    n2 = Integer.parseInt(string4);
                    if (this.\u0178) {
                        this.\u017a.addElement(new Integer(n2));
                    }
                }
                if (bl) continue;
                string4 = (String)this.\u0181.get("colname");
                if (this.\u0181.\u01bf("BYTE") || this.\u0181.\u01bf("BIT")) {
                    new ByteColumn(table, string4);
                    continue;
                }
                if (this.\u0181.\u01bf("INTEGER")) {
                    new IntegerColumn(table, string4);
                    continue;
                }
                if (this.\u0181.\u01bf("DATE")) {
                    new DateColumn(table, string4, transaction.\u016a);
                    continue;
                }
                if (this.\u0181.\u01bf("CHAR")) {
                    new StringColumn(table, string4, n2);
                    continue;
                }
                if (this.\u0181.\u01bf("CURRENCY")) {
                    new CurrencyColumn(table, string4, transaction.\u02b3, transaction.\u02b4);
                    continue;
                }
                if (this.\u0181.\u01bf("SHORT")) {
                    new IntegerColumn(table, string4);
                    continue;
                }
                if (this.\u0181.\u01bf("LONG")) {
                    new LongColumn(table, string4);
                    continue;
                }
                if (this.\u0181.\u01bf("FLOAT") || this.\u0181.\u01bf("SINGLE")) {
                    new FloatColumn(table, string4);
                    continue;
                }
                if (this.\u0181.\u01bf("DOUBLE")) {
                    new DoubleColumn(table, string4);
                    continue;
                }
                if (this.\u0181.\u01bf("BINARY") || this.\u0181.\u01bf("VARBINARY") || this.\u0181.\u01bf("LONGVARBINARY") || this.\u0181.\u01bf("IMAGE") || this.\u0181.\u01bf("OLE")) {
                    new BlobColumn(table, string4, BlobColumn.BINARY_BLOB);
                    continue;
                }
                if (!this.\u0181.\u01bf("TEXT") && !this.\u0181.\u01bf("LONGCHAR")) continue;
                new BlobColumn(table, string4, BlobColumn.STRING_BLOB);
            }
            if (n == 0) {
                throw new SQLException("No entry in schema, or file not found: " + table.getTableName());
            }
        }
        if (this.\u0181 != null) {
            this.\u0181.finalize();
        }
        if (this.\u017d && this.\u017e.ready()) {
            this.\u017c = this.\u017e.readLine();
        }
        if (this.\u0178) {
            n = 0;
            this.\u0182 = new int[this.\u017a.size() + 2];
            int n3 = 1;
            while (n3 < this.\u0182.length - 1) {
                this.\u0182[n3] = n;
                n += ((Integer)this.\u017a.elementAt(n3 - 1)).intValue();
                ++n3;
            }
            this.\u0182[this.\u0182.length - 1] = n;
            this.\u017a = null;
        }
        this.\u0183 = this.\u017e.ready();
        if (this.\u0179.equals("AUTO")) {
            this.\u017c = this.\u017e.readLine();
            this.\u017f = Integer.parseInt(this.\u017c);
            this.\u0183 = true;
        }
    }

    public void close() throws SQLException, IOException {
        this.\u017e.close();
    }

    void \u0178(Vector vector, int n) {
        Integer n2 = new Integer(n - 1);
        int n3 = 1;
        while (n3 < this.\u0185.size()) {
            Column column = (Column)this.\u0185.elementAt(n3);
            Object object = column.\u00d3(n2);
            vector.setElementAt(object, n3);
            ++n3;
        }
        if (n >= this.\u017f) {
            this.\u0183 = false;
        }
    }

    public String getCurLine() throws SQLException, IOException {
        return this.\u017c;
    }

    File \u0179(String string, String string2) {
        String string3 = "Unable to find file: " + string + "\n";
        File file = new File(string);
        String string4 = file.getAbsolutePath();
        String string5 = file.getName();
        try {
            String string6 = file.getCanonicalPath();
            file = new File(string6);
        }
        catch (IOException iOException) {
            throw new SQLException(String.valueOf(string3) + iOException.toString());
        }
        if (file.exists()) {
            return file;
        }
        if (string4.length() == string.length()) {
            throw new SQLException(string3);
        }
        string = String.valueOf(string2) + File.separatorChar + string5;
        file = new File(string);
        if (file.exists()) {
            return file;
        }
        throw new SQLException(string3);
    }

    public void getNextRow(Vector vector, int n) throws SQLException, IOException {
        if (this.\u0185 == null) {
            this.\u0185 = this.\u0184.getColList();
        }
        if (this.\u017f > 0) {
            this.\u0178(vector, n);
            return;
        }
        this.\u017c = this.\u017e.readLine();
        if (!this.\u0178) {
            if (this.\u0180 == null) {
                this.\u0180 = new tokenList("", false);
            }
            this.\u0180.\u0161(this.\u017c, this.\u0179, this.\u017e, this.\u017b);
        }
        int n2 = 1;
        while (n2 < vector.size()) {
            CurrencyColumn currencyColumn;
            String string = null;
            Column column = (Column)this.\u0185.elementAt(n2);
            if (!this.\u0178) {
                string = this.\u0180.\u028b();
            } else {
                int n3 = this.\u0182[n2 + 1];
                int n4 = this.\u017c.length();
                if (n3 > n4) {
                    n3 = n4;
                }
                if (this.\u0182[n2] < n4) {
                    string = this.\u017c.substring(this.\u0182[n2], n3);
                    if (column.\u00ed != 3) {
                        string = string.trim();
                    }
                } else {
                    string = null;
                }
            }
            if (column.\u00ed == 6 && (currencyColumn = (CurrencyColumn)column).\u0103(string)) {
                string = this.\u0180.\u028b();
            }
            if (string == null) {
                vector.setElementAt(null, n2);
            } else if (string.equals(this.\u0179)) {
                vector.setElementAt(null, n2);
            } else {
                vector.setElementAt(string, n2);
                if (!this.\u0178) {
                    this.\u0180.\u028b();
                }
            }
            ++n2;
        }
        this.\u0183 = this.\u017e.ready();
    }

    public boolean hasMoreRows() throws SQLException, IOException {
        return this.\u0183;
    }
}

