/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BlobColumn;
import db.Column;
import db.Database;
import db.Table;
import db.Trace;
import db.Transaction;
import db.idbDataOutputStream;
import db.indexTable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Vector;

public class Journal {
    File \u01b6;
    RandomAccessFile \u01b7;
    FileDescriptor fd;
    int \u01b8;
    Vector \u01b9;
    long \u01ba;
    int \u0137;
    String \u01bb;
    String \u011a;
    Database \u00ee;
    idbDataOutputStream \u01bc;
    Table[] \u012e;
    static Integer \u0173 = new Integer(0);
    static Integer \u0174 = new Integer(1);

    public Journal(Database database) throws SQLException {
        this.\u00ee = database;
        this.\u01bc = new idbDataOutputStream(2048, 16);
        if (this.\u01b7 == null) {
            this.\u0137 = 1;
            this.\u011a = String.valueOf(this.\u00ee.\u011a) + ".jrl";
            this.\u01bb = this.\u00ee.\u0120;
            this.\u0137 = this.\u00ee.\u0137;
            this.\u01b9 = new Vector(10, 10);
            this.\u01ba = 1000L;
            this.\u01bc();
        }
    }

    synchronized void \u01b6(Transaction transaction) {
        this.\u01b9.addElement(transaction);
    }

    synchronized void \u01b7() {
        try {
            if (this.\u01b7 == null) {
                return;
            }
            this.\u01b7.close();
            this.\u01b7 = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Problem closing journal file: " + this.\u011a + " " + iOException.toString());
        }
    }

    void \u01b8() {
        Vector vector = this.\u01b9;
        synchronized (vector) {
            int n = 0;
            while (n < this.\u01b9.size()) {
                Transaction transaction = (Transaction)this.\u01b9.elementAt(n);
                transaction.commit(transaction.getSqlID());
                ++n;
            }
        }
    }

    public synchronized void doRecovery(boolean bl) throws IOException, SQLException {
        if (this.\u01b7 == null) {
            return;
        }
        if (this.\u01b7.length() < 9L) {
            return;
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("Recoverying incomplete transactions, systemOnly=" + bl);
        }
        int n = 0;
        Vector<Long> vector = new Vector<Long>(10, 10);
        long l = this.\u01b7.getFilePointer();
        int n2 = this.\u01b8;
        Transaction transaction = new Transaction(this.\u00ee);
        while (l > 16L) {
            int n3;
            long l2;
            this.\u01b7.seek(l);
            transaction.ID = l2 = this.\u01ba();
            if (l2 >= this.\u01ba) {
                this.\u01ba = l2 + 1L;
            }
            l = this.\u01b7.getFilePointer() - 12L;
            int n4 = this.\u01b7.readInt();
            if (n4 == 1130915179) break;
            boolean bl2 = false;
            int n5 = 0;
            while (n5 < vector.size()) {
                Long l3 = (Long)vector.elementAt(n5);
                if (l2 == l3) {
                    bl2 = true;
                    break;
                }
                ++n5;
            }
            if (bl2) continue;
            vector.addElement(new Long(l2));
            if (n4 == 1164275295 || n4 == 1113941870 || ((n3 = this.\u01b7.readInt()) > 1004 || !bl) && (n3 <= 1004 || bl)) continue;
            this.\u01b7.seek(this.\u01b7.length());
            this.\u01b8 = 2;
            transaction.\u02a5 = true;
            this.rollback(transaction);
            ++n;
        }
        this.\u01b8 = n2;
        this.removeFromTransactionList(transaction);
        this.\u01b7.seek(this.\u01b7.length());
        if (!bl) {
            this.\u01be(null, 1130915179, 0, null, null, null);
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("Recovery complete. " + vector.size() + " found, " + n + " rolled back");
        }
    }

    synchronized long \u01b9() {
        long l = ++this.\u01ba;
        if (Trace.traceIt(16)) {
            Trace.traceOut("Allocated trans ID " + this.\u01ba);
        }
        return l;
    }

    private long \u01ba() {
        long l = this.\u01b7.getFilePointer();
        this.\u01b7.seek(l - 4L);
        int n = this.\u01b7.readInt();
        l = l - (long)n - 4L;
        this.\u01b7.seek(l);
        int n2 = this.\u01b7.readInt();
        if (n2 != 1416782190) {
            throw new SQLException("Internal error - could not read transaction marker");
        }
        long l2 = this.\u01b7.readLong();
        if (l2 < 1000L) {
            throw new SQLException("Internal error - illegal transaction ID: " + l2);
        }
        return l2;
    }

    private Table \u01bb(int n) {
        int n2 = 0;
        while (n2 < this.\u012e.length) {
            if (this.\u012e[n2].getTableID() == n) {
                return this.\u012e[n2];
            }
            ++n2;
        }
        return null;
    }

    private void \u01bc() {
        if (this.\u0137 == 0) {
            return;
        }
        try {
            this.\u01b6 = new File(this.\u01bb, this.\u011a);
            this.\u01b7 = new RandomAccessFile(this.\u01b6, "rw");
            this.fd = this.\u01b7.getFD();
            if (this.\u01b7.length() > 15L) {
                int n = this.\u01b7.readInt();
                this.\u01b7.readInt();
                if (n > 3) {
                    throw new SQLException("Journal file created with a later version.");
                }
                this.\u01ba = this.\u01b7.readLong();
                if (this.\u01ba < 1000L) {
                    throw new SQLException("Internal error - illegal transaction ID: " + this.\u01ba);
                }
            } else {
                this.\u01b7.writeInt(3);
                this.\u01b7.writeInt(13);
                this.\u01b7.writeLong(this.\u01ba);
            }
            this.\u01b7.seek(this.\u01b7.length());
        }
        catch (IOException iOException) {
            throw new SQLException("Problem opening/creating journal file: " + this.\u011a + " " + iOException.toString());
        }
    }

    public synchronized void removeFromTransactionList(Transaction transaction) throws SQLException {
        this.\u01b9.removeElement(transaction);
    }

    public synchronized void rollback(Transaction transaction) throws SQLException {
        if (!transaction.\u02a5) {
            transaction.\u02a8(true);
            return;
        }
        transaction.\u02a7(false);
        this.\u012e = this.\u00ee.\u0123();
        if (Trace.traceIt(16)) {
            Trace.traceOut("Rolling back transaction " + transaction.ID);
        }
        long l = 0L;
        try {
            l = this.\u01b7.getFilePointer();
            if (l != this.\u01b7.length()) {
                throw new SQLException("Internal error - journal pointer not at end\nfp=" + l + " Journal length=" + this.\u01b7.length());
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        long l2 = l;
        while (true) {
            try {
                block17: while (true) {
                    BlobColumn blobColumn;
                    long l3;
                    Integer n;
                    Table table;
                    int n2;
                    this.\u01b7.seek(l2);
                    long l4 = this.\u01ba();
                    l2 = this.\u01b7.getFilePointer() - 12L;
                    if (l4 != transaction.ID) continue;
                    int n3 = this.\u01b7.readInt();
                    switch (n3) {
                        default: {
                            continue block17;
                        }
                        case 1113941870: {
                            this.\u01b7.seek(l);
                            this.\u01be(transaction, 1164275295, 2, null, null, null);
                            transaction.\u02a8(true);
                            this.\u01b9();
                            transaction.\u02a5 = false;
                            this.\u01bd(-1);
                            if (Trace.traceIt(16)) {
                                Trace.traceOut("Rollback complete");
                            }
                            this.\u012e = null;
                            return;
                        }
                        case 1164275295: {
                            int n4 = this.\u01b7.readInt();
                            if (!Trace.traceIt(16)) continue block17;
                            Trace.traceOut("End status=" + n4);
                            continue block17;
                        }
                        case 1231975028: {
                            n2 = this.\u01b7.readInt();
                            int n5 = this.\u01b7.readInt();
                            table = this.\u01bb(n2);
                            if (Trace.traceIt(16)) {
                                Trace.traceOut(" Un-Insert row=" + n5 + " Table " + table.getTableName());
                            }
                            table.deleteRow(n5, null);
                            continue block17;
                        }
                        case 1147497588: {
                            Object var21_18;
                            n2 = this.\u01b7.readInt();
                            int n5 = this.\u01b7.readInt();
                            byte by = this.\u01b7.readByte();
                            table = this.\u01bb(n2);
                            table.\u0281 = true;
                            if (Trace.traceIt(16)) {
                                Trace.traceOut(" Un-Delete row=" + n5 + " Table " + table.getTableName() + " noAutoInc=" + by);
                            }
                            Vector<Integer> vector = new Vector<Integer>(table.getColCount());
                            table.getRow(n5, vector);
                            vector.setElementAt(\u0173, 0);
                            boolean bl = table.\u0270;
                            try {
                                try {
                                    table.\u0270 = by == 1;
                                    table.\u0197(vector, n5, null);
                                }
                                catch (Exception exception) {
                                    System.out.println("Error un-deleting row: " + exception.toString());
                                }
                                var21_18 = null;
                                table.\u0270 = bl;
                                table.\u0281 = false;
                                continue block17;
                            }
                            catch (Throwable throwable) {
                                var21_18 = null;
                                table.\u0270 = bl;
                                table.\u0281 = false;
                                throw throwable;
                            }
                        }
                        case 1231187042: {
                            n2 = this.\u01b7.readInt();
                            n = new Integer(this.\u01b7.readInt());
                            l3 = this.\u01b7.readLong();
                            table = this.\u01bb(n2);
                            blobColumn = (BlobColumn)table.getColByID(n);
                            blobColumn.\u00c7(l3);
                            if (!Trace.traceIt(16)) continue block17;
                            Trace.traceOut(" Un-Insert Blob offset=" + l3 + " Column " + n);
                            continue block17;
                        }
                        case 1147300962: 
                    }
                    n2 = this.\u01b7.readInt();
                    n = new Integer(this.\u01b7.readInt());
                    l3 = this.\u01b7.readLong();
                    table = this.\u01bb(n2);
                    blobColumn = (BlobColumn)table.getColByID(n);
                    if (!Trace.traceIt(16)) continue;
                    Trace.traceOut(" Un-Delete Blob offset=" + l3 + " Column " + n);
                }
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + " Exception during rollback " + exception.toString());
                continue;
            }
            break;
        }
    }

    synchronized void \u01bd(int n) {
        this.\u01b8 += n;
        if (this.\u01b8 < 0 || this.\u01b8 > this.\u01b9.size()) {
            throw new SQLException("Internal error - active transaction count=" + this.\u01b8);
        }
        if (this.\u01b8 == 0) {
            if (this.\u0137 < 2) {
                try {
                    this.\u01b7.close();
                    this.\u01b6.delete();
                }
                catch (Exception exception) {
                    throw new SQLException("Problem deleting journal file " + exception.toString());
                }
                this.\u01bc();
            } else {
                this.\u01be(null, 1130915179, 0, null, null, null);
            }
        }
        if (Trace.traceIt(16)) {
            Trace.traceOut("Active transactions " + this.\u01b8);
        }
    }

    synchronized void \u01be(Transaction transaction, int n, int n2, Table table, Column column, Object object) {
        if (this.\u0137 == 0) {
            return;
        }
        long l = 1000L;
        if (n != 1130915179) {
            l = transaction.ID;
            if (l < 1000L) {
                throw new SQLException("Internal error - illegal transaction ID: " + transaction.ID);
            }
            if (!transaction.\u02a5) {
                transaction.\u02a5 = true;
                this.\u01bd(1);
                this.\u01be(transaction, 1113941870, 0, null, null, null);
            }
        }
        try {
            this.\u01bc.\u0161();
            this.\u01bc.\u018e(1416782190);
            this.\u01bc.\u018f(l);
            this.\u01bc.\u018e(n);
            long l2 = 0L;
            switch (n) {
                case 1164275295: {
                    this.\u01bc.\u0192(n2);
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " End status=" + n2);
                    break;
                }
                case 1231975028: {
                    Object object2;
                    this.\u01bc.\u0192(table.getTableID());
                    this.\u01bc.\u0192(n2);
                    if (table instanceof indexTable) {
                        object2 = (indexTable)table;
                        this.\u01bc.\u0192(((indexTable)object2).\u01a1(n2));
                        this.\u01bc.\u0192(((indexTable)object2).\u01a2(n2));
                    } else {
                        object2 = (byte[])object;
                        this.\u01bc.\u0191((byte[])object2);
                    }
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " Insert row=" + n2 + " Table = " + table.getTableName());
                    break;
                }
                case 1147497588: {
                    this.\u01bc.\u0192(table.getTableID());
                    this.\u01bc.\u0192(n2);
                    byte by = (byte)(table.\u0270 ? 1 : 0);
                    this.\u01bc.\u018b(by);
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " Delete row=" + n2 + " Table = " + table.getTableName() + " noAutoInc = " + by);
                    break;
                }
                case 1231187042: {
                    l2 = (Long)object;
                    this.\u01bc.\u0192(table.getTableID());
                    this.\u01bc.\u0192(column.getColID());
                    this.\u01bc.\u018f(l2);
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " Insert Blob offset=" + l2);
                    break;
                }
                case 1147300962: {
                    l2 = (Long)object;
                    this.\u01bc.\u0192(table.getTableID());
                    this.\u01bc.\u0192(column.getColID());
                    this.\u01bc.\u018f(l2);
                    transaction.\u02a6.addElement(column);
                    transaction.\u02a7.addElement(object);
                    if (!Trace.traceIt(16)) break;
                    Trace.traceOut("Trans " + l + " Delete Blob offset=" + l2);
                    break;
                }
            }
            this.\u01bc.\u0192(this.\u01bc.\u018b);
            RandomAccessFile randomAccessFile = this.\u01b7;
            synchronized (randomAccessFile) {
                this.\u01b7.write(this.\u01bc.\u018a, 0, this.\u01bc.\u018b);
                if (!this.\u00ee.\u013c && n == 1) {
                    this.fd.sync();
                }
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing transaction record: " + iOException.toString());
        }
    }
}

