/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BTree;
import db.BitMap;
import db.BlobColumn;
import db.ByteColumn;
import db.Char1Column;
import db.Column;
import db.CurrencyColumn;
import db.Database;
import db.DateColumn;
import db.DoubleColumn;
import db.FileImporter;
import db.FloatColumn;
import db.GrowArray;
import db.Importer;
import db.IntegerColumn;
import db.JdbcImporter;
import db.LongColumn;
import db.Search;
import db.StringColumn;
import db.Table;
import db.Trace;
import db.Transaction;
import db.expression;
import db.indexTable;
import db.matchedTokens;
import db.tokenList;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Vector;

public class SQLProg {
    Database db;
    boolean \u01f1 = false;
    tokenList \u0180;
    matchedTokens \u0181;
    String \u01f2;
    Table \u01f3;
    String \u01f4;
    int \u01f5;
    int \u01fa;
    int \u01fb;
    Transaction \u01ec;
    static Integer \u01fc = new Integer(0);
    indexTable \u01fd;
    BTree \u01fe;
    boolean \u016c;
    Vector \u01ed;
    Object[] \u01ee;
    boolean \u01ff;
    boolean \u0200;
    boolean \u0201;
    Table \u0202;
    Table \u0203;
    Search \u0204;
    Vector \u0205;
    Vector \u0206;

    SQLProg(Database database, matchedTokens matchedTokens2, Transaction transaction) {
        this.db = database;
        this.\u01ec = transaction;
        this.\u01f3 = null;
        this.\u01f5 = -1;
        this.\u0181 = matchedTokens2;
    }

    public SQLProg(Database database, String string, boolean bl, Transaction transaction) throws SQLWarning, SQLException {
        database.\u011c();
        if (transaction != null && transaction.\u02b5) {
            throw new SQLException("Cannot access database during commit or rollback");
        }
        this.db = database;
        this.\u01f2 = string;
        this.\u01ec = transaction;
        if (this.\u01ec != null) {
            this.\u01ec.\u02b2(string);
        }
        this.\u0180 = new tokenList(string, bl);
        this.\u01f3 = null;
        this.\u01f5 = -1;
        this.\u0180.\u0161(0);
        this.\u0181 = new matchedTokens(this.\u0180, Database.\u014e, this.db);
    }

    void \u01f1(Vector vector, Vector vector2, Vector vector3, Table table, int n) {
        Vector vector4 = table.getColList();
        int n2 = 1;
        while (n2 < vector4.size()) {
            Column column = (Column)vector4.elementAt(n2);
            expression expression2 = new expression(column, n);
            if (vector.size() > 1) {
                expression2.\u0162(String.valueOf((String)vector2.elementAt(n)) + "." + column.getName());
            }
            vector3.addElement(expression2);
            ++n2;
        }
    }

    String \u01f2(String string, Vector vector, String string2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (string != null) {
            stringBuffer.append(string);
        }
        int n = 0;
        while (n < vector.size()) {
            this.\u0181.\u01c3(vector.elementAt(n));
            String string3 = (String)this.\u0181.get("colName");
            stringBuffer.append(string3);
            if (n == vector.size() - 1) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(',');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void \u01f3(String string, Vector vector, Vector vector2) {
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string);
        }
        vector.addElement(table);
        String string2 = (String)this.\u0181.get("pseudoTable");
        if (string2 == null) {
            string2 = string;
        }
        vector2.addElement(string2);
    }

    public void clearParameters() {
        this.\u0181.clearParameters();
    }

    public void clearUp() {
        this.\u0181.finalize();
    }

    void \u01f4() {
        this.\u0181.\u01c4(0);
        String string = (String)this.\u0181.get("table");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table: " + string + ", not found");
        }
        table.\u025d(this.db.\u014a);
        String string2 = null;
        Column column = null;
        if (this.\u0181.\u01bf("column") && (column = table.getColByName(string2 = (String)this.\u0181.get("column"))) == null) {
            throw new SQLException("Column, " + string2 + " not found");
        }
        if (this.\u0181.\u01bf("add_col")) {
            if (this.\u0181.\u01bf("PRIMARY")) {
                throw new SQLException("Use ALTER TABLE ADD PRIMARY KEY col_list");
            }
            this.\u0205(table);
            try {
                table.\u025f();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        } else if (this.\u0181.\u01bf("alter_col")) {
            String string3 = (String)this.\u0181.get("value");
            column.\u00df(4, string3);
            String string4 = "UPDATE " + this.db.\u012f + " SET ColDefault = " + string3 + " WHERE ColID = " + column.getColID();
            this.db.execSQL(string4, this.db.\u014a);
        } else if (this.\u0181.\u01bf("drop_col")) {
            if (this.\u0181.\u01bf("PRIMARY")) {
                String string5 = String.valueOf(table.getTableName()) + "$pKey";
                String string6 = "DROP INDEX " + string5;
                this.db.execSQL(string6, this.db.\u014a);
            } else {
                try {
                    table.\u0258(string2, column);
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
            }
        } else if (this.\u0181.\u01bf("table_constraint")) {
            Vector vector = (Vector)this.\u0181.get("colName");
            if (this.\u0181.\u01bf("PRIMARY")) {
                String string7 = "CREATE INDEX " + string + "$pKey ON " + string + " (";
                string7 = this.\u01f2(string7, vector, ")");
                this.db.execSQL(string7, this.db.\u014a);
            } else if (this.\u0181.\u01bf("UNIQUE")) {
                String string8 = "UPDATE " + this.db.\u012f + " SET Flags = Flags+\".UNIQ\"" + " WHERE Flags NOT LIKE \"%UNIQ%\" AND TableID=" + table.getTableID() + " AND ColName IN (";
                string8 = this.\u01f2(string8, vector, ")");
                this.db.execSQL(string8, this.db.\u014a);
                Vector vector2 = table.getColList();
                int n = 0;
                while (n < vector2.size()) {
                    column = (Column)vector2.elementAt(n);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        this.\u0181.\u01c3(vector.elementAt(n2));
                        String string9 = (String)this.\u0181.get("colName");
                        if (column.getName().equalsIgnoreCase(string9)) {
                            column.\u00e9(2, true);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
    }

    void \u01f5() {
        this.\u0181.\u01c4(0);
        if (this.\u0181.\u01bf("COMMIT")) {
            this.\u01ec.commit(this.\u01ec.getSqlID());
        } else {
            this.db.\u014b.rollback(this.\u01ec);
        }
    }

    void \u01fa() {
        this.\u0181.\u01c4(0);
        String string = (String)this.\u0181.get("indexName");
        String string2 = (String)this.\u0181.get("tableName");
        Vector vector = this.\u0181.\u01c2("colName");
        boolean bl = this.\u0181.\u01bf("UNIQUE");
        if (vector.size() == 0) {
            throw new SQLException("No columns defined for index: " + string);
        }
        Table table = this.db.getTable(string2);
        if (table == null) {
            throw new SQLException("Table: " + string2 + ", not found");
        }
        table.\u025d(this.db.\u014a);
        new indexTable(table, vector, string, bl, this.db.\u014a, table.\u0280);
    }

    void \u01fb() {
        Object object;
        Vector vector;
        int n;
        this.\u0181.\u01c4(0);
        String string = (String)this.\u0181.get("tableName");
        Table table = null;
        int n2 = -1;
        if (this.\u0181.\u01bf("PARTITION")) {
            n2 = this.\u0181.getInt("partitionNumber");
        }
        table = this.\u0181.\u01bf("TEMPORARY") ? new Table(string, this.db, true, true) : new Table(string, this.db, this.db.\u014a, n2);
        Vector vector2 = this.\u0181.\u01c2("column_def");
        int n3 = 0;
        while (n3 < vector2.size()) {
            this.\u0181.\u01c3(vector2.elementAt(n3));
            this.\u0205(table);
            ++n3;
        }
        this.\u0181.\u01c3(null);
        Vector<Object> vector3 = new Vector<Object>(1, 1);
        if (this.\u0181.\u01bf("table_constraint")) {
            Vector vector4 = (Vector)this.\u0181.get("table_constraint");
            n = 0;
            while (n < vector4.size()) {
                this.\u0181.\u01c3(vector4.elementAt(n));
                vector = (Vector)this.\u0181.get("colName");
                if (vector != null) {
                    object = new Vector(5, 5);
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        this.\u0181.\u01c3(vector.elementAt(n4));
                        String string2 = (String)this.\u0181.get("colName");
                        Column column = table.getColByName(string2);
                        if (column == null) {
                            throw new SQLException("Column not found: " + string2);
                        }
                        this.\u0181.\u01c3(vector4.elementAt(n));
                        if (this.\u0181.\u01bf("PRIMARY")) {
                            column.\u00e9(1, true);
                        }
                        if (this.\u0181.\u01bf("UNIQUE")) {
                            ((Vector)object).addElement(string2);
                        }
                        ++n4;
                    }
                    if (((Vector)object).size() > 0) {
                        vector3.addElement(object);
                    }
                }
                ++n;
            }
        }
        try {
            table.\u0253(this.db.\u014a, true);
            int n5 = vector3.size();
            if (n5 > 0) {
                n = 0;
                while (n < n5) {
                    vector = (Vector)vector3.elementAt(n);
                    object = String.valueOf(string) + "$uniq" + n;
                    new indexTable(table, vector, (String)object, true, this.db.\u014a, n2);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            throw new SQLException("IO problem: " + exception.toString() + exception.getMessage());
        }
    }

    void \u01fc() {
        if (this.\u01ec != null && !this.\u01ec.\u02b1()) {
            throw new SQLException("Transaction " + this.\u01ec.ID + " has read only access.");
        }
        this.\u0181.\u01c4(0);
        String string = (String)this.\u0181.get("table");
        Table table = this.db.getTable(string);
        table.\u025d(this.\u01ec);
        this.\u01f5 = 0;
        if (!this.\u0181.\u01bf("WHERE")) {
            int n = table.getRowCount();
            int n2 = 1;
            while (n2 <= n) {
                if (!table.rowDeleted(n2)) {
                    table.deleteRow(n2, this.\u01ec);
                    ++this.\u01f5;
                }
                ++n2;
            }
        } else {
            int[] nArray;
            Vector<Table> vector = new Vector<Table>(1);
            vector.addElement(table);
            Vector<String> vector2 = new Vector<String>(1);
            vector2.addElement(table.getTableName());
            Search search = new Search(this, vector, vector2, null, false);
            BitMap bitMap = new BitMap(table.\u01f5 + 1);
            while ((nArray = search.\u01db()) != null) {
                bitMap.\u00c4(nArray[0]);
            }
            int n = -1;
            nArray = new int[1];
            while ((n = bitMap.\u00c3(n)) >= 0) {
                nArray[0] = n;
                table.deleteRow(nArray[0], this.\u01ec);
                ++this.\u01f5;
            }
        }
    }

    void \u01fd() {
        this.\u0181.\u01c4(0);
        String string = (String)this.\u0181.get("index");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Unable to drop unknown table: " + string);
        }
        if (!(table instanceof indexTable)) {
            throw new SQLException(String.valueOf(string) + " is not an index table");
        }
        table.\u025d(this.db.\u014a);
        table.dropTable(this.db.\u014a);
    }

    void \u01fe() {
        this.\u0181.\u01c4(0);
        String string = (String)this.\u0181.get("table");
        Table table = this.db.getTable(string);
        if (table != null) {
            table.\u025d(this.db.\u014a);
            table.dropTable(this.db.\u014a);
        }
    }

    void \u01ff() {
        Object object;
        if (!this.\u01ec.\u02b1()) {
            throw new SQLException("Transaction " + this.\u01ec.ID + " has read only access.");
        }
        this.\u0181.\u01c4(0);
        String string = (String)this.\u0181.get("table");
        String string2 = (String)this.\u0181.get("filename");
        String string3 = (String)this.\u0181.get("schema");
        Importer importer = null;
        boolean bl = false;
        Table table = this.db.getTable(string);
        if (table == null) {
            table = new Table(string, this.db, this.\u01ec, -1);
        } else {
            bl = true;
        }
        int n = 0;
        if (this.\u0181.\u01bf("BUFFER")) {
            n = this.\u0181.getInt("rows");
        }
        importer = this.\u0181.\u01bf("URL") ? new JdbcImporter(this.db, string2, string3, table, this.\u01ec, this.db.\u011b) : new FileImporter(table, string2, string3, this.\u01ec, this.db);
        if (!bl) {
            object = this.db.\u014a;
            synchronized (object) {
                try {
                    this.db.\u0128(this.db.\u014a);
                    table.\u0253(this.db.\u014a, true);
                    this.db.\u014a.commit(this.db.\u014a.getSqlID());
                }
                catch (SQLException sQLException) {
                    this.db.\u014b.rollback(this.db.\u014a);
                    throw sQLException;
                }
            }
        }
        if (n > 0) {
            table.\u0256(n);
        }
        object = new Vector(table.getColCount());
        int n2 = 0;
        while (n2 < table.getColCount()) {
            ((Vector)object).addElement(\u01fc);
            ++n2;
        }
        int n3 = 1;
        while (importer.hasMoreRows()) {
            try {
                importer.getNextRow((Vector)object, n3);
                table.\u0197((Vector)object, table.getRowCount() + 1, this.\u01ec);
            }
            catch (Exception exception) {
                System.out.println("Error importing line " + n3);
                System.out.println(importer.getCurLine());
                exception.printStackTrace();
            }
            if (++n3 % 100 == 0 && Trace.traceIt(32)) {
                Trace.traceOut(String.valueOf(n3) + " rows imported");
            }
            if (n3 % this.db.\u0138 == 0) {
                this.\u01ec.commit(this.\u01ec.getSqlID());
            }
            Thread.yield();
        }
        this.\u01f5 = n3;
        if (n > 0) {
            table.\u0268(true);
        }
        importer.close();
    }

    void \u0200() {
        int n;
        Vector vector;
        if (!this.\u01ec.\u02b1()) {
            throw new SQLException("Transaction " + this.\u01ec.ID + " has read only access.");
        }
        this.\u0181.\u01c3("insert_statement");
        this.\u0181.\u01c4(3);
        Object object = this.\u0181.\u01c1();
        String string = (String)this.\u0181.get("tableName");
        Hashtable hashtable = null;
        boolean bl = false;
        int n2 = 1;
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string);
        }
        table.\u025d(this.\u01ec);
        Vector vector2 = table.getColList();
        Vector<Object> vector3 = new Vector<Object>(20);
        Vector vector4 = this.\u0181.\u01c2("insert_item");
        if (vector4.size() == 1) {
            vector = (Vector)vector4.elementAt(0);
            n = 0;
            while (n < vector.size()) {
                this.\u0181.\u01c3(vector.elementAt(n));
                vector3.addElement(this.\u0181.get("value"));
                ++n;
            }
        }
        this.\u0181.\u01c3(object);
        this.\u0181.\u01c3("insert_list");
        vector = this.\u0181.\u01c2("colName");
        this.\u0181.\u01c3(object);
        this.\u0181.\u01c4(0);
        if (this.\u0181.\u01bf("select_statement")) {
            this.\u0201(null, null, null);
            if (this.\u01f3.\u01f5 == 0) {
                return;
            }
            bl = true;
        }
        this.\u01f5 = 0;
        do {
            if (bl) {
                this.\u01f3.getRow(n2++, vector3);
            }
            if (vector.size() > 0) {
                hashtable = new Hashtable(table.getColCount() * 2 + 1, 0.5f);
                if (bl) {
                    vector3.removeElementAt(0);
                }
                if (vector.size() != vector3.size()) {
                    throw new SQLException("Incorrect number of values");
                }
                n = 0;
                while (n < vector.size()) {
                    String string2 = (String)vector.elementAt(n);
                    if (!table.checkColName(string2)) {
                        throw new SQLException("Unknown column : " + string2);
                    }
                    if (vector3.elementAt(n) == null) {
                        vector3.setElementAt("NULL", n);
                    }
                    hashtable.put(table.getColByName(string2).getName(), vector3.elementAt(n));
                    ++n;
                }
                table.addRow(hashtable, this.\u01ec);
            } else {
                if (!bl) {
                    vector3.insertElementAt(\u01fc, 0);
                }
                if (vector2.size() != vector3.size()) {
                    throw new SQLException("Incorrect number of values");
                }
                table.addRow(vector3, this.\u01ec);
            }
            if (bl && n2 > this.\u01f3.getRowCount()) {
                bl = false;
            }
            ++this.\u01f5;
        } while (bl);
    }

    /*
     * Unable to fully structure code
     */
    Vector \u0201(Vector var1_1, Vector var2_2, int[] var3_3) {
        var9_4 = null;
        var11_5 = false;
        if (this.\u01ff) {
            var11_5 = true;
        }
        if (this.\u016c) {
            this.\u0181.\u0161();
            this.\u0181.\u01c3("group_condition");
        } else {
            this.\u0181.\u01c3("select_statement");
        }
        var9_4 = this.\u0181.\u01c1();
        this.\u0181.\u01c4(2);
        if (!this.\u0201 && !this.\u01ff && this.\u0181.\u01bf("group_condition")) {
            this.\u0207();
            return null;
        }
        if (this.\u0181.\u01bf("DISTINCT")) {
            var11_5 = true;
        }
        var12_6 = null;
        var13_7 = null;
        if (!this.\u01ff) {
            var14_8 = (Vector<expression>)this.\u0181.get("table_ref");
            var15_9 = 0;
            if (var14_8 != null) {
                var15_9 = var14_8.size();
            }
            if (var1_1 != null) {
                var15_9 += var1_1.size();
            }
            this.\u01fa = var15_9;
            var12_6 = new Vector<E>(var15_9);
            var13_7 = new Vector<E>(var15_9);
            if (var1_1 != null) {
                var16_12 = 0;
                while (var16_12 < var1_1.size()) {
                    var12_6.addElement(var1_1.elementAt(var16_12));
                    var13_7.addElement(var2_2.elementAt(var16_12));
                    ++var16_12;
                }
            }
            var16_12 = 0;
            while (var16_12 < var14_8.size()) {
                block69: {
                    var9_4 = this.\u0181.\u01c3(var14_8.elementAt(var16_12));
                    if (this.\u0181.\u01bf("select_statement")) {
                        var17_16 = new SQLProg(this.db, this.\u0181, this.\u01ec);
                        var4_15 = (String)this.\u0181.get("pseudoTable");
                        var17_16.\u0208(var4_15);
                        try {
                            var17_16.\u0201(null, null, null);
                            break block69;
                        }
                        catch (Exception var18_22) {
                            var19_26 = this.db.getTable(var4_15);
                            if (var19_26 != null) {
                                this.db.\u012b(var19_26);
                            }
                            var20_34 = 0;
                            ** while (var20_34 < var12_6.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            var19_26 = (Table)var12_6.elementAt(var20_34);
                            if (var19_26.\u027b) {
                                this.db.\u012b(var19_26);
                            }
                            ++var20_34;
                            continue;
                        }
lbl61:
                        // 1 sources

                        throw new SQLException(var18_22.toString());
                    }
                    if (this.\u0181.\u01bf("join_spec")) {
                        this.\u0181.\u01c4(3);
                        this.\u0181.\u01c3("join_item");
                        var4_15 = (String)this.\u0181.get("tableName");
                        this.\u01f3(var4_15, var12_6, var13_7);
                        this.\u0181.\u01c3(var14_8.elementAt(var16_12));
                        this.\u0181.\u01c3("join_item2");
                        var4_15 = (String)this.\u0181.get("tableName");
                        this.\u0181.\u01c4(2);
                    } else {
                        var4_15 = (String)this.\u0181.get("refTable");
                    }
                }
                this.\u01f3(var4_15, var12_6, var13_7);
                this.\u0181.\u01c3(var9_4);
                ++var16_12;
            }
            this.db.\u0129(var12_6, this.\u01ec);
        } else {
            var12_6 = new Vector<E>(1);
            var13_7 = new Vector<E>(1);
            var12_6.addElement(this.\u0202);
            var13_7.addElement(this.\u0202.getTableName());
        }
        var14_8 = new Vector<expression>(10, 5);
        this.\u0181.\u01c4(1);
        if (this.\u0181.\u01bf("*") || this.\u0201) {
            var15_9 = 0;
            if (var1_1 != null) {
                var15_9 = var1_1.size();
            }
            var16_12 = var15_9;
            while (var16_12 < var12_6.size()) {
                var7_36 = (Table)var12_6.elementAt(var16_12);
                this.\u01f1(var12_6, var13_7, var14_8, var7_36, var16_12);
                ++var16_12;
            }
        } else {
            var15_10 = (Vector)this.\u0181.get("select_item");
            var16_12 = 0;
            while (var16_12 < var15_10.size()) {
                this.\u0181.\u01c3(var15_10.elementAt(var16_12));
                var6_37 = (String)this.\u0181.get("pseudoCol");
                this.\u0181.\u01c3("expr");
                this.\u0181.\u01c4(3);
                if (this.\u0181.\u01bf("all_cols")) {
                    this.\u0181.\u01c3("all_cols");
                    var17_16 = (String)this.\u0181.get("tableName");
                    var18_23 = 0;
                    while (var18_23 < var12_6.size()) {
                        var19_27 = (Table)var12_6.elementAt(var18_23);
                        if (var19_27.getTableName().equalsIgnoreCase((String)var17_16)) {
                            this.\u01f1(var12_6, var13_7, var14_8, var19_27, var18_23);
                        }
                        ++var18_23;
                    }
                } else {
                    var10_38 = new expression(this.\u0181, var12_6, var13_7, this.\u01ff);
                    if (var6_37 != null) {
                        var10_38.\u0162(var6_37);
                    }
                    var14_8.addElement(var10_38);
                }
                ++var16_12;
            }
        }
        this.\u0181.\u01c3(var9_4);
        var15_11 = var14_8.size();
        if (this.\u01f3 == null) {
            var16_12 = 0;
            var17_17 = true;
            if (this.\u01f4 == null) {
                this.\u01f4 = this.db.\u0125();
            } else {
                var16_12 = 1;
            }
            if (this.\u0181.\u01bf("destTable") && !this.\u0201 && !this.\u016c) {
                this.\u01f4 = (String)this.\u0181.get("destTable");
                var17_17 = false;
            }
            this.\u01f3 = new Table(this.\u01f4, this.db, var17_17, (boolean)var16_12);
            if (var12_6.size() == 1) {
                this.\u01f3.\u027f = new GrowArray();
                this.\u01f3.\u00f6 = (Table)var12_6.elementAt(0);
            }
            this.\u01f4 = null;
            var18_23 = 0;
            while (var18_23 < var15_11) {
                var10_38 = (expression)var14_8.elementAt(var18_23);
                var10_38.\u0159(this.\u01f3);
                var19_28 = var10_38.\u015c();
                if (var19_28 < this.\u01fa) {
                    this.\u01fa = var19_28;
                }
                ++var18_23;
            }
            try {
                this.\u01f3.\u0253(this.\u01ec, true);
            }
            catch (Exception var19_29) {
                throw new SQLException("IO problem: " + var19_29.toString() + var19_29.getMessage());
            }
        }
        if (!this.\u01ff && !this.\u0201) {
            this.\u0200 = true;
        }
        this.\u0181.\u01c3(var9_4);
        this.\u0181.\u01c4(1);
        if (this.\u0181.\u01bf("ORDER") && this.\u0200) {
            var16_13 = (Vector)this.\u0181.get("order_clause");
            var17_18 = 0;
            while (var17_18 < var16_13.size()) {
                this.\u0181.\u01c3(var16_13.elementAt(var17_18));
                var18_23 = 0;
                if (this.\u0181.\u01bf("DESC")) {
                    var18_23 = 1;
                }
                var19_30 = (String)this.\u0181.get("colName");
                var4_15 = null;
                if (this.\u0181.\u01bf("tabName")) {
                    var4_15 = (String)this.\u0181.get("tabName");
                }
                this.\u01f3.\u0251(var4_15, var19_30, (boolean)var18_23);
                ++var17_18;
            }
        }
        this.\u0181.\u01c3(var9_4);
        this.\u0181.\u01c4(2);
        var16_14 = new Search(this, var12_6, var13_7, null, false);
        if (this.\u016c) {
            var16_14.\u016c = true;
            this.\u0204 = var16_14;
            this.\u0205 = var16_14.\u01d9();
            var17_19 = this.\u0205.size();
            this.\u0206 = new Vector<E>(var17_19);
            var18_23 = 0;
            while (var18_23 < var17_19) {
                var19_31 = (expression)this.\u0205.elementAt(var18_23);
                this.\u0206.addElement(var19_31.clone());
                ++var18_23;
            }
        } else if (this.\u01ff) {
            var17_20 = 0;
            while (var17_20 < this.\u0205.size()) {
                var14_8.addElement((expression)this.\u0205.elementAt(var17_20));
                ++var17_20;
            }
        }
        if (var3_3 != null) {
            var16_14.\u01e4(var3_3);
        }
        if ((var17_21 = var16_14.\u015c()) < this.\u01fa) {
            this.\u01fa = var17_21;
        }
        if (this.\u01ff && !this.\u016c) {
            var18_24 = new Vector<Object>(this.\u01ed.size());
            var19_32 = false;
            var20_35 = 0;
            while (var20_35 < this.\u01ed.size()) {
                var10_38 = (expression)this.\u01ed.elementAt(var20_35);
                var21_39 = var10_38.\u015b();
                if (var21_39 != null) {
                    var18_24.addElement(var21_39);
                    var16_14.\u0110[0].\u0107 = var21_39;
                    var19_32 = true;
                }
                ++var20_35;
            }
            var21_39 = null;
            if (var19_32) {
                var16_14.\u0110[0].\u00da = var21_39 = new indexTable(this.db, this.\u0202, var18_24);
                var16_14.\u0110[0].\u0117 = true;
            }
            var11_5 = false;
            var22_40 = this.\u01ed.size();
            var23_41 = this.\u0203.\u01f5;
            var24_42 = new Vector<E>(var22_40 + 1);
            var25_43 = 1;
            while (var25_43 <= var23_41) {
                this.\u0203.getRow(var25_43, var24_42);
                var26_44 = 0;
                while (var26_44 < this.\u01ee.length) {
                    this.\u01ee[var26_44] = var24_42.elementAt(var26_44 + 1);
                    ++var26_44;
                }
                var16_14.\u01e3(this.\u01ed, this.\u01ee, (indexTable)var21_39);
                this.\u0206(var14_8, var16_14, var15_11, var11_5, var12_6);
                this.\u0204.\u01e0(this.\u0205, this.\u0206);
                var16_14.\u0161();
                var16_14.\u01e1 = false;
                var27_45 = 0;
                while (var27_45 < var14_8.size()) {
                    var10_38 = (expression)var14_8.elementAt(var27_45);
                    var10_38.\u0161();
                    ++var27_45;
                }
                ++var25_43;
            }
            this.\u0200 = true;
            this.\u01fa = 0x7FFFFFFF;
        } else {
            this.\u0206(var14_8, var16_14, var15_11, var11_5, var12_6);
        }
        if (this.\u0200) {
            if (this.\u01f3.\u026f > 0 && this.\u01f3.\u01f5 > 0) {
                this.\u01fe.\u00dc();
            }
            var18_25 = this.\u01f3.\u0251;
            var19_33 = 1;
            while (var19_33 < var18_25.size()) {
                var10_38 = (expression)var14_8.elementAt(var19_33 - 1);
                var8_46 = (Column)var18_25.elementAt(var19_33);
                if (var10_38.\u015f == 1) {
                    var8_46.\u00e9(5, var10_38.\u0107.isAutoIncrement());
                    var8_46.\u00e9 = var10_38.\u0107.\u00e9;
                } else {
                    var8_46.\u00ea = true;
                }
                ++var19_33;
            }
            if (var1_1 == null && !this.\u01f3.\u027b) {
                if (this.db.\u0135 != 0 && this.db.\u0139 != null) {
                    this.\u01f3.exportText(this.\u01f2);
                } else {
                    this.\u01f3.exportText(null);
                }
            }
            var20_35 = 0;
            while (var20_35 < var12_6.size()) {
                var21_39 = (Table)var12_6.elementAt(var20_35);
                if (var21_39.\u027b) {
                    this.db.\u012b((Table)var21_39);
                }
                ++var20_35;
            }
        }
        return var14_8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void \u0202() {
        this.\u0181.\u01c4(0);
        String string = null;
        String string2 = null;
        string = (String)this.\u0181.get("date");
        if (string != null) {
            this.\u01ec.\u016a = string;
            return;
        }
        string = (String)this.\u0181.get("LITERALS");
        if (string != null) {
            string = (String)this.\u0181.get("STRICT_ON");
            this.db.\u013d = string != null;
            return;
        }
        string = (String)this.\u0181.get("DEFAULT_USERNAME");
        if (string != null) {
            this.db.\u014c = (String)this.\u0181.get("uname");
            if (!this.\u0181.\u01bf("DEFAULT_PASSWORD")) return;
            this.db.\u014d = (String)this.\u0181.get("pword");
            return;
        }
        string = (String)this.\u0181.get("cur");
        if (string != null) {
            this.\u01ec.\u02b3 = string.charAt(0);
            return;
        }
        string = (String)this.\u0181.get("dec");
        if (string != null) {
            this.\u01ec.\u02b4 = Integer.parseInt(string);
            return;
        }
        if (this.\u0181.\u01bf("INCREMENT_BASE")) {
            String string3 = (String)this.\u0181.get("base");
            Long l = null;
            if (string3 != null) {
                l = new Long(string3);
            }
            if (this.\u0181.\u01bf("ALL")) {
                int n = 0;
                while (n < this.db.\u012e.size()) {
                    Table table = (Table)this.db.\u012e.elementAt(n);
                    int n2 = 1;
                    while (n2 < table.\u0251.size()) {
                        Column column = (Column)table.\u0251.elementAt(n2);
                        if (column.isAutoIncrement()) {
                            column.\u00df(7, l);
                            try {
                                column.close(table.\u0256);
                            }
                            catch (IOException iOException) {
                                throw new SQLException(iOException.toString());
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
                return;
            }
            String string4 = (String)this.\u0181.get("table");
            String string5 = (String)this.\u0181.get("column");
            Table table = this.db.getTable(string4);
            if (table == null) {
                throw new SQLException("Table " + string4 + " not found");
            }
            Column column = table.getColByName(string5);
            if (column == null) {
                throw new SQLException("Table " + string4 + " column " + string5 + " not found");
            }
            column.\u00df(7, l);
            try {
                column.close(table.\u0256);
                return;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        }
        string = (String)this.\u0181.get("INCREMENT");
        if (string != null) {
            String string6 = (String)this.\u0181.get("table");
            Table table = this.db.getTable(string6);
            if (table == null) {
                throw new SQLException("Table " + string6 + " not found");
            }
            table.\u027c = this.\u0181.\u01bf("OFF");
            return;
        } else {
            string2 = (String)this.\u0181.get("filename");
            if (string2 == null) return;
            string = (String)this.\u0181.get("level");
            int n = 0;
            n = string == null ? 0 : Integer.parseInt(string);
            Trace trace = Trace.\u029b();
            trace.\u029e(string2, n + 2048);
            trace.\u029a = false;
            trace.\u029b = true;
            trace.\u029d = false;
            trace.\u029e = false;
            trace.\u029f = false;
            trace.\u013b = 0;
            trace.\u029c = false;
            trace.\u02a0 = false;
            if (this.\u0181.\u01bf("SQL")) {
                this.db.\u0135 = 1;
            }
            if (this.\u0181.\u01bf("NO")) {
                this.db.\u0135 = 0;
            }
            if (this.\u0181.\u01bf("TIME")) {
                trace.\u02a0 = true;
            }
            if (this.\u0181.\u01bf("CONSOLE")) {
                trace.\u013b = 1;
            }
            if (this.\u0181.\u01bf("COLNAMEHEADER")) {
                trace.\u029a = true;
            }
            if (this.\u0181.\u01bf("CSVDELIMITED")) {
                trace.\u029b = true;
                trace.\u0179 = (char)44;
            }
            if (this.\u0181.\u01bf("DELIMITED")) {
                trace.\u029b = true;
                string = (String)this.\u0181.get("delimiter");
                trace.\u0179 = string.charAt(0);
            }
            if (this.\u0181.\u01bf("FIXEDLENGTH")) {
                trace.\u029b = false;
            }
            if (this.\u0181.\u01bf("ROWNUMBERS")) {
                trace.\u029d = true;
            }
            if (this.\u0181.\u01bf("CONTROLCOL")) {
                trace.\u029f = true;
            }
            if (this.\u0181.\u01bf("SUMMARYHEADER")) {
                trace.\u029c = true;
            }
            if (!this.\u0181.\u01bf("QUOTE")) return;
            string = (String)this.\u0181.get("quoteChar");
            trace.\u029f(string.charAt(0));
        }
    }

    void \u0203() {
        boolean bl = false;
        this.\u0181.\u01c4(0);
        if (this.\u0181.\u01bf("NOWAIT")) {
            bl = true;
        }
        this.db.\u012e(bl);
    }

    void \u0204() {
        Object object;
        Object object2;
        Object object3;
        if (this.\u01ec != null && !this.\u01ec.\u02b1()) {
            throw new SQLException("Transaction " + this.\u01ec.ID + " has read only access.");
        }
        this.\u0181.\u01c4(0);
        String string = (String)this.\u0181.get("table");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table " + string + " not found");
        }
        table.\u025d(this.\u01ec);
        Vector<Table> vector = new Vector<Table>(1);
        vector.addElement(table);
        Vector<String> vector2 = new Vector<String>(1);
        vector2.addElement(table.getTableName());
        Search search = new Search(this, vector, vector2, null, false);
        this.\u0181.\u01c4(0);
        Vector vector3 = (Vector)this.\u0181.get("assignment");
        expression[] expressionArray = new expression[vector3.size()];
        Column[] columnArray = new Column[vector3.size()];
        int[] nArray = new int[vector3.size()];
        int n = 0;
        while (n < vector3.size()) {
            this.\u0181.\u01c3(vector3.elementAt(n));
            object3 = (String)this.\u0181.get("column");
            columnArray[n] = table.getColByName((String)object3);
            if (columnArray[n] == null) {
                throw new SQLException("Column: " + (String)object3 + ", not found");
            }
            nArray[n] = table.getRelColPosn((String)object3);
            if (this.\u0181.\u01bf("NULL")) {
                expressionArray[n] = null;
            } else if (this.\u0181.\u01bf("select_statement")) {
                this.\u0181.\u01c3("select_statement");
                this.\u0201(null, null, null);
                if (this.\u01f3.\u01f5 != 1 || this.\u01f3.\u0251.size() != 2) {
                    throw new SQLException("SET expression sub-query must return a single row and column");
                }
                object2 = (Column)this.\u01f3.\u0251.elementAt(1);
                this.\u01f3 = null;
                object = ((Column)object2).\u00c9(1);
                expressionArray[n] = new expression(this.db, object);
            } else {
                this.\u0181.\u01c3("expr");
                expressionArray[n] = new expression(this.\u0181, vector, vector2, new expression(columnArray[n], n));
            }
            ++n;
        }
        object2 = new BitMap(table.\u01f5 + 1);
        while ((object3 = search.\u01db()) != null) {
            ((BitMap)object2).\u00c4(object3[0]);
        }
        this.\u01f5 = 0;
        object = new Vector<Object>(table.getColCount());
        int n2 = -1;
        object3 = new int[1];
        while ((n2 = ((BitMap)object2).\u00c3(n2)) >= 0) {
            table.getRow(n2, (Vector)object);
            int n3 = 0;
            while (n3 < columnArray.length) {
                Object object4 = null;
                if (expressionArray[n3] != null) {
                    object3[0] = n2;
                    object4 = expressionArray[n3].evaluate((int[])object3);
                }
                ((Vector)object).setElementAt(columnArray[n3].\u00d3(object4), nArray[n3]);
                ++n3;
            }
            try {
                table.\u0270 = true;
                table.\u0272 = true;
                table.deleteRow(n2, this.\u01ec);
                table.addRow(object, this.\u01ec);
            }
            finally {
                Object var17_18 = null;
                table.\u0270 = false;
                table.\u0272 = false;
            }
            ++this.\u01f5;
        }
    }

    void \u0205(Table table) {
        int n;
        int n2;
        int n3;
        String string = (String)this.\u0181.get("colName");
        Column column = null;
        if (this.\u0181.\u01bf("INT") || this.\u0181.\u01bf("INTEGER") || this.\u0181.\u01bf("SMALLINT")) {
            column = new IntegerColumn(table, string);
        } else if (this.\u0181.\u01bf("CHAR") || this.\u0181.\u01bf("VARCHAR")) {
            n3 = this.\u0181.getInt("length");
            column = new StringColumn(table, string, n3);
        } else if (this.\u0181.\u01bf("SMALLCHAR")) {
            n3 = this.\u0181.getInt("length");
            column = new Char1Column(table, string, n3);
        } else if (this.\u0181.\u01bf("BYTE")) {
            column = new ByteColumn(table, string);
        } else if (this.\u0181.\u01bf("TINYINT")) {
            column = new ByteColumn(table, string);
        } else if (this.\u0181.\u01bf("LONG")) {
            column = new LongColumn(table, string);
        } else if (this.\u0181.\u01bf("NUMERIC") || this.\u0181.\u01bf("DECIMAL")) {
            n3 = 108;
            n2 = 0;
            n = 0;
            if (this.\u0181.\u01bf("precision")) {
                n2 = this.\u0181.getInt("precision");
            }
            if (this.\u0181.\u01bf("scale")) {
                n = this.\u0181.getInt("scale");
            }
            column = n != 0 ? new DoubleColumn(table, string) : (n2 == 0 || n2 > 9 ? new LongColumn(table, string) : new IntegerColumn(table, string));
        } else if (this.\u0181.\u01bf("DATE")) {
            column = new DateColumn(table, string, this.\u01ec.\u016a);
        } else if (this.\u0181.\u01bf("FLOAT") || this.\u0181.\u01bf("SHORT") || this.\u0181.\u01bf("SINGLE")) {
            column = new FloatColumn(table, string);
        } else if (this.\u0181.\u01bf("CURRENCY")) {
            column = new CurrencyColumn(table, string, this.\u01ec.\u02b3, this.\u01ec.\u02b4);
        } else if (this.\u0181.\u01bf("DOUBLE")) {
            column = new DoubleColumn(table, string);
        } else if (this.\u0181.\u01bf("BINARY") || this.\u0181.\u01bf("VARBINARY") || this.\u0181.\u01bf("LONGVARBINARY") || this.\u0181.\u01bf("IMAGE") || this.\u0181.\u01bf("OLE")) {
            column = new BlobColumn(table, string, BlobColumn.BINARY_BLOB);
        } else if (this.\u0181.\u01bf("TEXT") || this.\u0181.\u01bf("LONGCHAR")) {
            column = new BlobColumn(table, string, BlobColumn.STRING_BLOB);
        } else {
            throw new SQLException("Unknown data type");
        }
        String string2 = (String)this.\u0181.get("default");
        if (string2 != null) {
            column.\u00df(4, string2);
        }
        if (this.\u0181.\u01bf("CACHE")) {
            n2 = this.\u0181.getInt("rows");
            n = 2;
            if (this.\u0181.\u01bf("ROWS")) {
                n = 1;
            }
            column.setCacheCondition(n, n2);
        }
        if (this.\u0181.\u01bf("NOT")) {
            column.\u00e9(3, true);
        }
        if (this.\u0181.\u01bf("AUTO")) {
            column.\u00e9(5, true);
        }
        if (this.\u0181.\u01bf("UNIQUE")) {
            column.\u00e9(2, true);
        }
        if (this.\u0181.\u01bf("PRIMARY")) {
            column.\u00e9(1, true);
        }
    }

    void \u0206(Vector vector, Search search, int n, boolean bl, Vector vector2) {
        int n2;
        Object object;
        int[] nArray;
        boolean bl2;
        boolean bl3 = false;
        int n3 = 0;
        boolean bl4 = true;
        do {
            if (++n3 % 100 == 0 && Trace.traceIt(32)) {
                Trace.traceOut(String.valueOf(n3) + " rows selected");
            }
            bl3 = false;
            bl2 = true;
            this.\u01fd = null;
            do {
                Object object2;
                nArray = search.\u01db();
                if (this.\u01ec.\u02b1) {
                    this.\u01ec.\u02b1 = false;
                    throw new SQLException("Query: " + this.\u01f2 + "\nis taking too long.");
                }
                Vector<Object> vector3 = new Vector<Object>(n + 1);
                vector3.addElement(\u01fc);
                boolean bl5 = false;
                if (nArray == null && bl4) {
                    bl5 = true;
                }
                bl4 = false;
                object = null;
                n2 = 0;
                while (n2 < vector.size()) {
                    object2 = (expression)vector.elementAt(n2);
                    object = ((expression)object2).evaluate(nArray);
                    if (!((expression)object2).\u0160()) {
                        bl2 = false;
                    }
                    if (object == null) {
                        bl5 = true;
                    }
                    if (((expression)object2).\u016b) {
                        bl3 = true;
                    } else if (!bl5 && n2 < n) {
                        vector3.addElement(object);
                    }
                    ++n2;
                }
                if (bl5) continue;
                if (bl) {
                    if (this.\u01fd == null) {
                        this.\u01fd = new indexTable(this.db, this.\u01f3, null);
                    }
                    if ((object2 = (Object)this.\u01fd.\u01a8(vector3, true)) != null && this.\u01fd.\u019a((int)object2[0], (int)object2[1], vector3) != -1) {
                        bl5 = true;
                    }
                }
                if (!bl5 && this.\u01ff && !this.\u016c) {
                    bl5 = this.\u0204.evaluate(nArray) ^ true;
                    bl2 = true;
                }
                if (!bl5) {
                    int n4 = 0;
                    n4 = nArray != null ? this.\u01f3.addRow(vector3, null, nArray[0]) : this.\u01f3.addRow(vector3, null);
                    if (this.\u01fd != null) {
                        this.\u01fd.\u0198(n4);
                    }
                    if (this.\u0200 && this.\u01f3.\u026f > 0) {
                        if (this.\u01f3.\u01f5 == 1) {
                            this.\u01fe = new BTree(this.\u01f3, 0);
                        } else {
                            this.\u01fe.add(n4 - 1);
                        }
                        if (this.\u01f3.getValidRowCount() > this.\u01fb && this.\u01fb > 0) {
                            int n5 = this.\u01fe.\u00d9();
                            this.\u01f3.deleteRow(n5 + 1, null);
                            this.\u01f3.\u026a = this.\u01f3.\u01f5 + 1;
                            this.\u01fe = this.\u01fe.\u00d6();
                            this.\u01f3.\u00f6 = null;
                            this.\u01f3.\u027f = null;
                            if (this.\u01fd != null) {
                                this.\u01fd.\u019b(n5 + 1);
                            }
                        }
                    }
                }
                if (this.\u01f3.getValidRowCount() >= this.\u01fb && this.\u01fb > 0 && this.\u01f3.\u026f == 0) break;
            } while (!bl2 && nArray != null);
            search.\u0161();
        } while (bl3);
        bl2 = false;
        if (search.\u01d4 != null && search.\u01d5 != null) {
            search.\u01d5 = null;
            bl2 = true;
            search.\u01d7();
        }
        nArray = new int[vector2.size()];
        int n6 = 0;
        while (n6 < search.\u0110.length) {
            if (search.\u0110[n6].\u0118 != null) {
                BitMap bitMap = search.\u0110[n6].\u0118;
                object = search.\u0110[n6].\u0106;
                n2 = 0;
                while ((n2 = bitMap.\u00c2(n2)) <= ((Table)object).\u01f5 && n2 != -1) {
                    if (((Table)object).rowDeleted(n2)) continue;
                    nArray[n6] = n2;
                    if (bl2 && !search.evaluate(nArray)) continue;
                    Vector<Object> vector4 = new Vector<Object>(n + 1);
                    vector4.addElement(\u01fc);
                    Object object3 = null;
                    int n7 = 0;
                    while (n7 < vector.size()) {
                        expression expression2 = (expression)vector.elementAt(n7);
                        object3 = expression2.evaluate(nArray);
                        vector4.addElement(object3);
                        ++n7;
                    }
                    this.\u01f3.addRow(vector4, this.\u01ec, nArray[0]);
                }
                nArray[n6] = 0;
            }
            ++n6;
        }
    }

    public void execute() throws SQLException {
        block40: {
            if (this.\u0180.\u018a() == 0) {
                return;
            }
            if (Trace.traceIt(2)) {
                if (this.\u0180.\u028f > 0) {
                    Trace.traceOut(this.\u0180.\u028c(this.\u0181));
                } else {
                    Trace.traceOut(this.\u01f2);
                }
            }
            this.db.\u011c();
            if (this.\u01f3 != null) {
                this.\u01f3.dropTable(this.\u01ec);
            }
            this.\u01f3 = null;
            this.\u01f5 = -1;
            if (this.\u0180.\u01c3() < this.\u0180.\u018a()) {
                if (Trace.traceIt(512)) {
                    Trace.traceOut(this.\u0181.toString());
                }
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.\u01f2) + "\n Don't understand SQL after: \"" + this.\u0180.\u028b() + "\"");
                if (this.\u0181.\u01c4 > 0) {
                    stringBuffer.append("\n Expected: \"" + this.\u0181.\u01c2 + "\"");
                    stringBuffer.append(" found: \"" + this.\u0181.\u01c3 + "\"");
                    if (this.\u0181.\u01c6) {
                        stringBuffer.append(" (reserved word)");
                    }
                }
                Trace.traceOut(stringBuffer.toString());
                throw new SQLException(stringBuffer.toString());
            }
            if (Trace.traceIt(512)) {
                Trace.traceOut(this.\u0181.toString());
            }
            this.\u0181.\u0161();
            this.\u0181.\u01c4(2);
            try {
                if (this.\u0181.\u01bf("select_statement")) {
                    this.\u016c = false;
                    this.\u0201 = false;
                    this.\u0200 = false;
                    this.\u01ff = false;
                    this.\u0201(null, null, null);
                    break block40;
                }
                if (this.\u0181.\u01bf("insert_statement")) {
                    this.\u0200();
                    break block40;
                }
                if (this.\u0181.\u01bf("update_statement")) {
                    this.\u0204();
                    break block40;
                }
                if (this.\u0181.\u01bf("delete_statement")) {
                    this.\u01fc();
                    break block40;
                }
                if (this.\u0181.\u01bf("set_statement")) {
                    this.\u0202();
                    break block40;
                }
                if (this.\u0181.\u01bf("shutdown_statement")) {
                    this.\u0203();
                    break block40;
                }
                if (this.\u0181.\u01bf("commit_statement")) {
                    this.\u01f5();
                    break block40;
                }
                if (this.\u0181.\u01bf("import_statement")) {
                    try {
                        this.\u01ff();
                        break block40;
                    }
                    catch (Exception exception) {
                        if (Trace.traceIt(4)) {
                            exception.printStackTrace();
                        }
                        throw exception.fillInStackTrace();
                    }
                }
                Transaction transaction = this.db.\u014a;
                synchronized (transaction) {
                    try {
                        this.\u01ec.commit(this.\u01ec.getSqlID());
                        this.db.\u014a.\u02b2(this.\u01f2);
                        this.db.\u0128(this.db.\u014a);
                        if (this.\u0181.\u01bf("create_table_statement")) {
                            this.\u01fb();
                        } else if (this.\u0181.\u01bf("create_index_statement")) {
                            this.\u01fa();
                        } else if (this.\u0181.\u01bf("drop_index_statement")) {
                            this.\u01fd();
                        } else if (this.\u0181.\u01bf("drop_table_statement")) {
                            this.\u01fe();
                        } else if (this.\u0181.\u01bf("alter_table_statement")) {
                            this.\u01f4();
                        } else {
                            throw new SQLException("Invalid SQL: " + this.\u01f2);
                        }
                        this.db.\u014a.commit(this.db.\u014a.getSqlID());
                        Object var2_5 = null;
                        return;
                    }
                    catch (Exception exception) {
                        this.db.\u014b.rollback(this.db.\u014a);
                        Trace.traceOut(exception.toString());
                        if (Trace.traceIt(4)) {
                            exception.printStackTrace();
                        }
                        throw exception.fillInStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                this.db.\u014b.rollback(this.\u01ec);
                Trace.traceOut(throwable.toString());
                if (Trace.traceIt(4)) {
                    throwable.printStackTrace();
                }
                throw new SQLException(throwable.getMessage());
            }
        }
    }

    protected void finalize() throws Throwable {
        this.\u01f3 = null;
    }

    public int getParameterCount() {
        return this.\u0181.getParameterCount();
    }

    public Object[] getParams() {
        return (Object[])this.\u0181.\u01c7.clone();
    }

    public Table getResultSet() {
        return this.\u01f3;
    }

    public int getRowCount() {
        return this.\u01f5;
    }

    void \u0207() {
        Object object = this.\u0181.\u01c1();
        String string = this.\u01f4;
        this.\u01f4 = null;
        this.\u0201 = true;
        this.\u0201(null, null, null);
        this.\u0201 = false;
        this.\u0202 = this.\u01f3;
        this.\u01f3 = null;
        this.\u01ff = true;
        this.\u016c = true;
        this.\u01ed = this.\u0201(null, null, null);
        this.\u016c = false;
        this.\u0204.\u016c = false;
        int n = this.\u01ed.size();
        this.\u0203 = this.\u01f3;
        this.\u01f3 = null;
        int n2 = this.\u0203.\u01f5;
        this.\u01ee = new Object[n];
        this.\u01f4 = string;
        this.\u0181.\u01c3(object);
        this.\u0200 = true;
        this.\u0201(null, null, null);
        this.\u0202.dropTable(this.\u01ec);
    }

    public void setMaxRows(int n) {
        this.\u01fb = n;
    }

    public void setParam(int n, Object object) throws SQLException {
        this.\u0181.setParam(n, object);
    }

    public void setParams(Object[] objectArray) {
        this.\u0181.\u01c7 = objectArray;
    }

    void \u0208(String string) {
        this.\u01f4 = string;
    }
}

