/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.Column;
import db.Database;
import db.Table;
import db.TableEncrypt;
import db.Trace;
import db.Transaction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import jdbc.idbDatabaseMetaData;
import jdbc.idbDriver;
import jdbc.idbPreparedStatement;
import jdbc.idbStatement;

public class idbConnection
implements Connection {
    static int \u0394;
    static idbDriver \u0395;
    Database db;
    String \u0396;
    String \u0397;
    String \u0398;
    Properties \u0399;
    idbDatabaseMetaData \u039a;
    boolean \u0260;
    boolean \u039b;
    int id;
    boolean \u039c;
    String \u039d;
    Transaction \u01ec;
    boolean \u039e;

    idbConnection(idbDriver idbDriver2, String string, Properties properties) {
        String string2;
        this.\u0396 = string2 = String.valueOf(string.substring(0, 8)) + ":" + string.substring(9);
        \u0395 = idbDriver2;
        this.\u0399 = properties;
        this.\u0397 = string2.substring(9);
        Object object = \u0395;
        synchronized (object) {
            this.db = Database.getDatabase(this.\u0396);
            if (this.db == null) {
                this.db = new Database(this.\u0396);
                Database.addDatabase(this.db);
            }
            this.id = ++\u0394;
        }
        this.\u0396("connecting to URL: " + string2 + " Open count=" + this.db.getOpenCount());
        this.\u0398 = properties.getProperty("UserID", "guest");
        object = properties.getProperty("Password");
        String string3 = properties.getProperty("crashExit", "0");
        if (!string3.equals("0")) {
            this.\u039e = true;
        }
        try {
            this.\u01ec = this.db.dbOpen(this.\u0397, this.\u0398, (String)object);
            this.\u01ec.setConnection(this);
            this.\u039a = new idbDatabaseMetaData(this);
            this.\u0260 = true;
        }
        catch (Exception exception) {
            this.db = null;
            this.\u0260 = false;
            this.\u0396 = null;
            throw new SQLException(exception.getMessage());
        }
        this.\u039c = true;
        this.\u039d = "default";
    }

    void \u0394(int n) {
        if (Trace.traceIt(16)) {
            Trace.traceOut("Checking transaction autoCommit: callersID=" + n + ", cur ID=" + this.\u01ec.getSqlID());
        }
        if (n != this.\u01ec.getSqlID()) {
            return;
        }
        Transaction transaction = this.\u01ec;
        synchronized (transaction) {
            if (this.\u039c) {
                this.\u01ec.commit(n);
            }
        }
    }

    private synchronized void \u0395() {
        if (!this.\u0260) {
            this.\u0396("Generating SQLException: The connection is closed");
            throw new SQLException("The connection is closed", "8002");
        }
    }

    public synchronized void clearWarnings() throws SQLException {
        this.\u0396("clearWarnings");
        this.\u0395();
    }

    public synchronized void close() throws SQLException {
        this.\u0395();
        this.\u0260 = false;
        this.\u0396("close Open count=" + this.db.getOpenCount());
        idbDriver idbDriver2 = \u0395;
        synchronized (idbDriver2) {
            if (this.\u039e) {
                this.db.close(true);
            } else {
                this.\u01ec.commit(this.\u01ec.getSqlID());
                this.db.getJournal().removeFromTransactionList(this.\u01ec);
                this.db.close();
            }
            int n = this.db.getOpenCount();
            if (n == 0) {
                Database.removeDatabase(this.db);
                this.db = null;
                this.\u0396 = null;
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.\u0396("commit");
        if (!this.\u0260) {
            return;
        }
        Transaction transaction = this.\u01ec;
        synchronized (transaction) {
            this.\u01ec.commit(this.\u01ec.getSqlID());
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        this.\u0396("Creating statement");
        this.\u0395();
        return new idbStatement(this, 1007);
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.\u0396("Creating statement");
        this.\u0395();
        return new idbStatement(this, n2);
    }

    protected void finalize() throws Throwable {
        if (this.\u0260) {
            this.close();
        }
    }

    public boolean getAutoClose() {
        return false;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.\u0396("getAutoCommit: " + this.\u039c);
        this.\u0395();
        return this.\u039c;
    }

    public synchronized String getCatalog() throws SQLException {
        this.\u0396("getCatalog: " + this.\u039d);
        this.\u0395();
        return null;
    }

    public Object getLastValueInserted(String string, String string2) throws SQLException {
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table: " + string + ", not found");
        }
        Column column = table.getColByName(string2);
        if (column == null) {
            throw new SQLException("Column: " + string2 + ", not found");
        }
        return column.getLastValueInserted();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.\u0396("getMetaData");
        this.\u0395();
        return this.\u039a;
    }

    public Properties getProperties() {
        return this.\u0399;
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        int n = this.\u01ec.getTransactionIsolation();
        this.\u0396("getTransactionIsolation: " + n);
        this.\u0395();
        return n;
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.\u0396("getWarnings");
        this.\u0395();
        return null;
    }

    public synchronized boolean isClosed() throws SQLException {
        this.\u0396("isClosed: open=" + this.\u0260);
        return this.\u0260 ^ true;
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.\u0396("isReadOnly " + this.\u039b);
        this.\u0395();
        return this.\u039b;
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        this.\u0396("Native SQL: " + string);
        this.\u0395();
        return string;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.\u0396("Creating callable statement");
        this.\u0395();
        return null;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.\u0396("Creating prepared statement");
        this.\u0395();
        return new idbPreparedStatement(this, string, 1007);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new idbPreparedStatement(this, string, n2);
    }

    public synchronized void rollback() throws SQLException {
        this.\u0396("rollback");
        this.\u0395();
        Transaction transaction = this.\u01ec;
        synchronized (transaction) {
            this.db.getJournal().rollback(this.\u01ec);
        }
    }

    public void setAutoClose(boolean bl) {
        bl = false;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.\u0396("setAutoCommit " + bl);
        this.\u0395();
        this.\u039c = bl;
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.\u0396("setCatalog: " + string);
        this.\u0395();
        this.\u039d = string;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.\u0396("setReadOnly " + bl);
        this.\u0395();
        this.\u039b = bl;
    }

    public void setTableEncryption(String string, TableEncrypt tableEncrypt) throws SQLException {
        this.db.setTableEncryption(string, tableEncrypt);
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.\u0396("setTransactionIsolation: " + n);
        this.\u0395();
        this.\u01ec.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("Not implemented");
    }

    private synchronized void \u0396(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut("Con " + this.id + " " + string);
        }
    }
}

