/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import db.Database;
import db.IdbVector;
import db.SQLProg;
import db.Table;
import db.Trace;
import db.Transaction;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import jdbc.idbConnection;
import jdbc.idbDatabaseMetaData;
import jdbc.idbDriver;
import jdbc.idbResultsSet;

public class idbStatement
implements Statement {
    static int \u0394;
    idbConnection \u01b1;
    idbDriver \u039f;
    Database db;
    SQLProg \u02b7;
    idbDatabaseMetaData \u039a;
    Table \u01f3;
    idbResultsSet \u03ad;
    int \u01f5;
    boolean \u0124;
    int \u03ae;
    int \u01fb;
    boolean \u03af;
    int \u03b0;
    int id;
    boolean \u03b1;
    int \u02b8;
    int \u03b2;
    int \u03aa;
    int \u03ab;
    IdbVector \u03b3;

    idbStatement(idbConnection idbConnection2, int n) {
        this.\u01b1 = idbConnection2;
        this.\u039f = idbConnection.\u0395;
        this.db = this.\u01b1.db;
        this.\u039a = this.\u01b1.\u039a;
        this.\u03ae = this.\u039a.getMaxRowSize();
        this.\u01fb = Integer.MAX_VALUE;
        this.\u03af = true;
        this.id = ++\u0394;
        this.\u03b2 = n;
        this.\u0396("Created");
    }

    public void addBatch(String string) throws SQLException {
        if (this.\u03b3 == null) {
            this.\u03b3 = new IdbVector(5, 5);
        }
        this.\u03b3.addElement(string);
    }

    public synchronized void cancel() throws SQLException {
        this.\u0396("cancel");
        this.\u03a5();
    }

    void \u03a5() {
        if (this.\u0124) {
            this.\u0396("Throwing SQLException: Statement is closed");
            throw new SQLException("Statement is closed");
        }
    }

    public void clearBatch() throws SQLException {
        if (this.\u03b3 == null) {
            return;
        }
        this.\u03b3.removeAllElements();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.\u0396("clearWarnings");
    }

    public synchronized void close() throws SQLException {
        this.\u0396("close");
        this.\u03a5();
        this.\u0124 = true;
        if (this.\u02b7 != null) {
            this.\u02b7.clearUp();
        }
        this.\u03ad = null;
        this.\u01b1 = null;
        this.\u039f = null;
        this.db = null;
        this.\u02b7 = null;
        this.\u039a = null;
        this.\u01f3 = null;
        this.\u03ad = null;
    }

    void \u03ad() {
        if (this.\u03ad != null && !this.\u03ad.\u0124) {
            this.\u03ad.close();
            this.\u02b7 = null;
            this.\u01f3 = null;
            this.\u03ad = null;
        }
    }

    public synchronized boolean execute(String string) throws SQLException {
        this.\u0396("execute " + string);
        this.\u03a5();
        if (!this.\u03af) {
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '{') {
                    throw new SQLException("Escape processing is disabled");
                }
                ++n;
            }
        }
        this.\u02b8 = this.\u01b1.\u01ec.allocateSqlID();
        Transaction transaction = this.\u01b1.\u01ec;
        synchronized (transaction) {
            this.\u03ad();
            this.\u01b1.\u0394(this.\u02b8);
            this.\u02b7 = new SQLProg(this.db, string, false, this.\u01b1.\u01ec);
            this.\u02b7.setMaxRows(this.\u01fb);
            boolean bl = this.\u01b1.\u039c;
            this.\u01b1.\u039c = false;
            try {
                this.db.addToTimerQueue(this.\u01b1.\u01ec, this.\u03b0);
                this.\u02b7.execute();
            }
            finally {
                Object var6_5 = null;
                if (this.\u03b0 != 0) {
                    this.db.removeFromTimerQueue(this.\u01b1.\u01ec);
                }
                this.\u01b1.\u039c = bl;
                this.\u02b7.clearUp();
            }
        }
        this.\u01f5 = this.\u02b7.getRowCount();
        if (this.\u01f5 == -1) {
            this.\u01f3 = this.\u02b7.getResultSet();
            if (this.\u01f3 != null) {
                this.\u03ad = new idbResultsSet(this, this.\u01f3, this.\u02b8);
                this.\u0396(String.valueOf(this.\u01f3.getRowCount()) + " rows returned");
                if (this.\u03b2 == 1007) {
                    this.\u01b1.\u0394(this.\u02b8);
                }
                return true;
            }
            this.\u01b1.\u0394(this.\u02b8);
        } else {
            this.\u01b1.\u0394(this.\u02b8);
            this.\u0396(String.valueOf(this.\u01f5) + " rows modified");
        }
        return false;
    }

    public int[] executeBatch() throws SQLException {
        int n = this.getBatchCount();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = this.\u03b3.getStringAt(n3);
            boolean bl = false;
            try {
                bl = this.execute(string);
                if (bl) {
                    throw new Exception("Cannot perform queries in batch updates");
                }
                ++n2;
            }
            catch (Exception exception) {
                this.clearBatch();
                int[] nArray2 = new int[n2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                throw new BatchUpdateException(exception.toString(), nArray2);
            }
            ++n3;
        }
        this.clearBatch();
        return nArray;
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.\u0396("executeQuery " + string);
        this.\u03a5();
        this.\u03b1 = true;
        this.execute(string);
        this.\u03b1 = false;
        int n = 0;
        if (this.\u01f3 != null) {
            n = this.\u01f3.getRowCount();
        }
        this.\u0396(String.valueOf(n) + " rows updated");
        return this.\u03ad;
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        this.\u0396("executeUpdate " + string);
        this.\u03a5();
        this.\u03b1 = true;
        this.execute(string);
        this.\u03b1 = false;
        int n = this.\u01f5;
        this.\u0396(String.valueOf(n) + " rows updated");
        return n;
    }

    protected void finalize() throws Throwable {
        if (!this.\u0124) {
            this.close();
        }
    }

    public int getBatchCount() {
        if (this.\u03b3 == null) {
            return 0;
        }
        return this.\u03b3.size();
    }

    public Connection getConnection() throws SQLException {
        return this.\u01b1;
    }

    public int getFetchDirection() throws SQLException {
        return this.\u03aa;
    }

    public int getFetchSize() throws SQLException {
        return this.\u03ab;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        this.\u0396("getMaxFieldSize " + this.\u03ae);
        this.\u03a5();
        return this.\u03ae;
    }

    public synchronized int getMaxRows() throws SQLException {
        this.\u0396("getMaxRows " + this.\u01fb);
        this.\u03a5();
        return this.\u01fb;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        this.\u0396("getMoreResults");
        this.\u03a5();
        this.\u01f5 = -1;
        return this.\u03ad != null;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        this.\u0396("getQueryTimeout " + this.\u03b0);
        this.\u03a5();
        return this.\u03b0;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.\u0396("getResultSet");
        this.\u03a5();
        idbResultsSet idbResultsSet2 = this.\u03ad;
        this.\u03ad = null;
        return idbResultsSet2;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1008;
    }

    public int getResultSetType() throws SQLException {
        return 1004;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.\u0396("getUpdateCount " + this.\u01f5);
        this.\u03a5();
        return this.\u01f5;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.\u0396("getWarnings");
        return null;
    }

    public synchronized void setCursorName(String string) throws SQLException {
        this.\u0396("setCursorName " + string);
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.\u0396("setEscapeProcessing " + bl);
        this.\u03a5();
        this.\u03af = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.\u03aa = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.\u03ab = n;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        this.\u0396("setMaxFieldSize " + n);
        this.\u03a5();
        this.\u03ae = n;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        this.\u0396("setMaxRows " + n);
        this.\u03a5();
        this.\u01fb = n;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.\u0396("setQueryTimeout " + n);
        this.\u03a5();
        this.\u03b0 = n;
    }

    private void \u0396(String string) {
        if (Trace.traceIt(1024)) {
            Trace.traceOut(" Stm " + this.id + " " + string);
        }
    }
}

