/*
 * Decompiled with CFR 0.152.
 */
package nlbean;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import nlbean.Help;
import nlbean.NLEngine;
import nlbean.Util;

public class NLBean
extends Panel
implements Serializable {
    protected NLEngine engine = null;
    private boolean usingAWT = false;
    private boolean loadSynonyms = true;
    private boolean loadDB = true;
    private Choice choice;
    private transient boolean choiceChanged = false;
    private Help help;
    private TextArea outputText;
    private TextField inputText;
    private TextArea sqlText;
    private List list1;
    private List list2;
    private List list3;
    private int list1_last_selection;
    private int list2_last_selection;
    private int list3_last_selection;
    private String[] examples = new String[]{"list email address where name equals Mark", "list salary where employee name equals Mark", "list salary where hire date is after 1993/1/5 and employee name equals Mark", "list name, phone number, and email address where name equals Mark", "list employee name, salary, and hire date where hire date is after January 10, 1993", "list salary where hire date is after January 1, 1993 or employee name equals Carol", "list product name where cost is less than $20"};
    private String[] synonyms = new String[]{"employee name=EmpName", "hire date=HireDate", "phone number=PhoneNumber", "email address=Email", "product name=productname", "products=productname", "product=productname"};
    private String[] databaseNames = new String[]{"jdbc:idb:database/nlbean.prp"};
    private String[] userNames = new String[]{"Admin"};
    private String[] passwords = new String[]{"sammy"};
    private String[] tableLists = new String[]{"NameTable;products;Employees"};
    protected transient int startWordPos = 0;
    protected transient int stopWordPos = 0;

    public NLBean() {
        this.reset();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        System.out.println("Beginning writeObject");
        objectOutputStream.defaultWriteObject();
        System.out.println("Ending writeObject");
    }

    private void resetExamples() {
        this.choiceChanged = false;
        this.choice.removeAll();
        this.choice.addItem("Examples                                        ");
        int n = this.examples.length - 1;
        while (n >= 0) {
            this.choice.insert(this.examples[n], 1);
            --n;
        }
    }

    private void resetSynonyms() {
        this.engine.clearSynonyms();
        int n = 0;
        while (n < this.synonyms.length) {
            this.addSynonym(this.synonyms[n]);
            ++n;
        }
    }

    private void reset() {
        this.engine = new NLEngine();
        this.AWTsetup();
    }

    private void AWTsetup() {
        Frame frame = new Frame();
        this.help = new Help(frame);
        this.setFont(new Font("Dialog", 0, 12));
        this.setLayout(null);
        Label label = new Label("Natural Language Database Access");
        label.setFont(new Font("Dialog", 1, 28));
        this.add(label);
        label.setBounds(2, 1, 600, 34);
        this.list1 = new List(3, false);
        int n = 0;
        while (n < this.databaseNames.length) {
            this.list1.add(this.databaseNames[n]);
            ++n;
        }
        this.list2 = new List(3, false);
        this.list3 = new List(3, false);
        this.add(this.list1);
        this.add(this.list2);
        this.add(this.list3);
        this.list1.setBounds(2, 40, 220, 90);
        this.list2.setBounds(232, 40, 170, 90);
        this.list3.setBounds(412, 40, 170, 90);
        this.list1.addMouseListener(new MouseSelect1());
        this.list2.addMouseListener(new MouseSelect2());
        this.list3.addMouseListener(new MouseSelect3());
        Button button = new Button("Do query");
        button.addMouseListener(new MouseQuery());
        this.add(button);
        button.setBounds(2, 140, 160, 30);
        Button button2 = new Button("Help");
        button2.addMouseListener(new MouseHelp());
        this.add(button2);
        button2.setBounds(172, 140, 40, 30);
        Label label2 = new Label("Query:");
        label2.setFont(new Font("Dialog", 1, 14));
        this.add(label2);
        label2.setBounds(2, 180, 60, 22);
        label2.setVisible(true);
        this.inputText = new TextField("list Salary where EmpName equals Mark", 64);
        this.add(this.inputText);
        this.inputText.setBounds(80, 180, 500, 22);
        this.choice = new Choice();
        this.choiceChanged = false;
        this.choice.addItem("Examples                                        ");
        int n2 = this.examples.length - 1;
        while (n2 >= 0) {
            this.choice.insert(this.examples[n2], 1);
            --n2;
        }
        this.choice.addItemListener(new ChoiceListener());
        this.add(this.choice);
        this.choice.setBounds(2, 210, 582, 25);
        Label label3 = new Label("Generated SQL:");
        label3.setFont(new Font("Dialog", 1, 12));
        this.add(label3);
        label3.setBounds(2, 240, 120, 30);
        this.sqlText = new TextArea("", 1, 80, 3);
        this.sqlText.setEditable(false);
        this.add(this.sqlText);
        this.sqlText.setBounds(130, 240, 455, 40);
        this.outputText = new TextArea("NLBean(tm) natural language interface\nCopyright 1997, Mark Watson.  All rights reserved.\n", 8, 74);
        this.add(this.outputText);
        this.outputText.setBounds(2, 285, 582, 150);
        Label label4 = new Label("NLBean Copyright 1997-1999 by Mark Watson.  www.markwatson.com");
        label4.setFont(new Font("Dialog", 2, 14));
        this.add(label4);
        label4.setBounds(5, 442, 540, 16);
        this.list1_last_selection = -1;
        this.list2_last_selection = -1;
        this.list3_last_selection = -1;
        this.setBounds(20, 20, 590, 464);
        this.setupHelper();
    }

    private void setupHelper() {
        int n;
        if (this.loadSynonyms) {
            n = 0;
            while (n < this.synonyms.length) {
                this.addSynonym(this.synonyms[n]);
                ++n;
            }
        }
        if (this.loadDB) {
            n = 0;
            while (n < this.databaseNames.length) {
                this.engine.addDB(this.databaseNames[n], this.userNames[n], this.passwords[n], this.tableLists[n]);
                ++n;
            }
        }
        this.engine.initDB();
    }

    private synchronized void putText(String string, boolean bl) {
        if (!bl) {
            this.outputText.append(string);
        } else {
            this.outputText.setText(string);
        }
    }

    private synchronized String inText(String string, boolean bl) {
        if (bl) {
            this.inputText.setText(string);
            return "";
        }
        return this.inputText.getText();
    }

    private synchronized void query() {
        System.out.println("Entering query()");
        this.sqlText.setText("");
        String string = this.inText("", false);
        System.out.println("query(): a_query=" + string);
        String string2 = null;
        if (string.startsWith("SELECT") || string.startsWith("select")) {
            string2 = string;
        } else {
            this.engine.parse(string);
            string2 = this.engine.getSQL();
        }
        if (string2 == null) {
            System.out.println("No SQL for " + string);
            return;
        }
        System.out.println("SQL query: " + string2);
        this.sqlText.setText(string2);
        try {
            this.engine.createResultSet(string2, this.databaseNames[0], this.userNames[0], this.passwords[0]);
            this.putText("Query results:\n", false);
            String string3 = this.engine.getRows(string2, this.databaseNames[0], this.userNames[0], this.passwords[0]);
            this.putText(this.engine.toEnglish(string3) + "\n", false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addSynonym(String string) {
        int n = string.indexOf("=");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (this.engine != null) {
            this.engine.addSynonym(string3, string2);
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        NLBean nLBean = new NLBean();
        frame.add(nLBean);
        frame.setTitle("NLBean version 4.0");
        frame.pack();
        frame.show();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    class SmartTextField
    extends TextField
    implements Serializable {
        private transient String[] words = null;
        transient int num_words;
        private transient int charWidth = -1;
        private transient FontMetrics fm = null;
        private transient int my_char_pos = 0;

        public SmartTextField(String string, int n) {
            super(string, n);
            this.helper();
        }

        public SmartTextField(String string) {
            super(string);
            this.helper();
        }

        public SmartTextField() {
            this.helper();
        }

        private void helper() {
            this.addMouseListener(new MouseText());
            this.addKeyListener(new MyKeyAdapter());
            this.setEditable(true);
            this.setFont(new Font("default", 0, 12));
            this.words = new String[20];
            int n = 0;
            while (n < 20) {
                this.words[n] = "";
                ++n;
            }
            this.num_words = 0;
        }

        public String getWord(int n) {
            NLBean.this.stopWordPos = -1;
            NLBean.this.startWordPos = -1;
            String string = this.getText();
            int n2 = n - 1;
            try {
                while (n2 >= 0 && string.charAt(n2) != ' ') {
                    --n2;
                }
                ++n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n3 = n;
            try {
                while (n3 < string.length() && string.charAt(n3) != ' ') {
                    ++n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 < 0) {
                n2 = 0;
            }
            System.out.println("getWord(): start=" + n2 + ", stop=" + n3);
            int n4 = n3;
            if (n3 > this.my_char_pos) {
                n3 = this.my_char_pos;
                System.out.println("    stop reset to " + n3);
            }
            if (n2 < n3) {
                NLBean.this.startWordPos = n2;
                NLBean.this.stopWordPos = n4;
                System.out.println("getWord() returning: |" + string.substring(n2, n3) + "|");
                return string.substring(n2, n3);
            }
            return "";
        }

        public void setUpperCase(int n) {
            String string = this.getText();
            int n2 = n - 1;
            try {
                while (n2 >= 0 && string.charAt(n2) != ' ') {
                    --n2;
                }
                ++n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n3 = n;
            try {
                while (n3 < string.length() && string.charAt(n3) != ' ') {
                    ++n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > string.length()) {
                n3 = string.length();
            }
            if (n3 > this.my_char_pos) {
                n3 = this.my_char_pos;
            }
            if (n2 < n3) {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n4 = n2;
                while (n4 < n3) {
                    char c = stringBuffer.charAt(n4);
                    if (c >= 'a' && c <= 'z') {
                        c = (char)(c - 32);
                    }
                    stringBuffer.setCharAt(n4, c);
                    ++n4;
                }
                this.setText(new String(stringBuffer));
                this.setCaretPosition(n3);
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics();
            }
        }

        private int getPixelWidth(String string) {
            if (this.fm == null) {
                return 1;
            }
            return this.fm.stringWidth(string);
        }

        public int getCharPos(int n) {
            String string = this.getText();
            this.my_char_pos = -1;
            if (this.getPixelWidth(string) < n) {
                return -1;
            }
            int n2 = string.length();
            int n3 = 1;
            while (n3 < n2) {
                if (this.getPixelWidth(string.substring(0, n3)) > n - 12) {
                    this.my_char_pos = n3;
                    return n3;
                }
                ++n3;
            }
            this.my_char_pos = n2 - 1;
            return n2 - 1;
        }

        class MyKeyAdapter
        extends KeyAdapter
        implements Serializable {
            MyKeyAdapter() {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == ',' || keyEvent.getKeyChar() == '.') {
                    int n = SmartTextField.this.getCaretPosition();
                    SmartTextField.this.my_char_pos = n;
                    System.out.println("** charPos=" + n);
                    String string = SmartTextField.this.getWord(n);
                    System.out.println("** word =" + string);
                }
            }
        }

        class MouseText
        extends MouseAdapter
        implements Serializable {
            MouseText() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = SmartTextField.this.getCharPos(n);
                if (n2 < 0) {
                    return;
                }
                SmartTextField.this.my_char_pos = 1000;
                String string = SmartTextField.this.getWord(n2);
                System.out.println("MouseText.mousePressed(): getWord returned: " + string);
                if (string.length() < 1) {
                    return;
                }
                System.out.println("x=" + n + ", charPos=" + n2 + ", word=" + string);
            }
        }
    }

    class MouseHelp
    extends MouseAdapter
    implements Serializable {
        MouseHelp() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            NLBean.this.help.setVisible(true);
        }
    }

    class ChoiceListener
    implements ItemListener {
        ChoiceListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            System.out.println("choice menu: " + itemEvent.paramString());
            System.out.println("choice menu: " + (String)itemEvent.getItem());
            String string = (String)itemEvent.getItem();
            if (string.equals("Examples")) {
                return;
            }
            NLBean.this.inText(string, true);
            if (!NLBean.this.choiceChanged) {
                NLBean.this.choice.remove(0);
                NLBean.this.choiceChanged = true;
            }
            System.out.println("choice menu: <returning>");
        }
    }

    class MouseSelect3
    extends MouseAdapter
    implements Serializable {
        MouseSelect3() {
        }

        public synchronized void mouseReleased(MouseEvent mouseEvent) {
            if (NLBean.this.list3_last_selection != NLBean.this.list3.getSelectedIndex()) {
                System.out.println("TESTING 3rd list selection");
                NLBean.this.list3_last_selection = NLBean.this.list3.getSelectedIndex();
                String[] stringArray = NLBean.this.list1.getSelectedItems();
                if (stringArray != null && stringArray.length > 0) {
                    String[] stringArray2 = NLBean.this.list2.getSelectedItems();
                    String[] stringArray3 = NLBean.this.list3.getSelectedItems();
                    if (stringArray2 != null && stringArray3 != null && stringArray3.length > 0) {
                        String string = "";
                        String string2 = "";
                        if (NLBean.this.list1_last_selection >= 0 && NLBean.this.list1_last_selection < NLBean.this.userNames.length) {
                            string = NLBean.this.userNames[NLBean.this.list1_last_selection];
                            string2 = NLBean.this.passwords[NLBean.this.list1_last_selection];
                        }
                        try {
                            String string3 = NLBean.this.engine.getRows("SELECT " + stringArray3[0] + " FROM " + stringArray2[0], stringArray[0], string, string2);
                            if (string3 == null) {
                                return;
                            }
                            NLBean.this.putText(string3 + "\n", false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    class MouseSelect2
    extends MouseAdapter
    implements Serializable {
        MouseSelect2() {
        }

        public synchronized void mouseReleased(MouseEvent mouseEvent) {
            if (NLBean.this.list2_last_selection != NLBean.this.list2.getSelectedIndex()) {
                String[] stringArray;
                NLBean.this.list2_last_selection = NLBean.this.list2.getSelectedIndex();
                NLBean.this.list3.removeAll();
                String[] stringArray2 = NLBean.this.list1.getSelectedItems();
                if (stringArray2 != null && stringArray2.length > 0 && (stringArray = NLBean.this.list2.getSelectedItems()) != null && stringArray.length > 0) {
                    String string = "";
                    String string2 = "";
                    if (NLBean.this.list1_last_selection >= 0 && NLBean.this.list1_last_selection < NLBean.this.userNames.length) {
                        string = NLBean.this.userNames[NLBean.this.list1_last_selection];
                    }
                    try {
                        String[] stringArray3 = NLBean.this.engine.getColumnNames(stringArray[0], stringArray2[0], string, string2);
                        if (stringArray3 != null) {
                            int n = 0;
                            while (n < stringArray3.length) {
                                NLBean.this.list3.addItem(stringArray3[n]);
                                ++n;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class MouseSelect1
    extends MouseAdapter
    implements Serializable {
        MouseSelect1() {
        }

        public synchronized void mouseReleased(MouseEvent mouseEvent) {
            if (NLBean.this.list1_last_selection != NLBean.this.list1.getSelectedIndex()) {
                NLBean.this.list1_last_selection = NLBean.this.list1.getSelectedIndex();
                String string = "";
                if (NLBean.this.list1_last_selection >= 0 && NLBean.this.list1_last_selection < NLBean.this.tableLists.length) {
                    string = NLBean.this.tableLists[NLBean.this.list1_last_selection];
                }
                System.out.println("s=" + string);
                String[] stringArray = Util.parseStrings(string);
                NLBean.this.list2.removeAll();
                NLBean.this.list3.removeAll();
                int n = 0;
                while (n < stringArray.length) {
                    NLBean.this.list2.addItem(stringArray[n]);
                    ++n;
                }
            }
        }
    }

    class MouseQuery
    extends MouseAdapter
    implements Serializable {
        MouseQuery() {
        }

        public synchronized void mouseReleased(MouseEvent mouseEvent) {
            NLBean.this.query();
        }
    }
}

