/*
 * Decompiled with CFR 0.152.
 */
package nlbean;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import nlbean.DBInfo;
import nlbean.DBInterface;
import nlbean.NLP;
import nlbean.Util;

public class NLEngine
implements Serializable {
    private int num_rows_from_database = 0;
    public DBInfo dbinfo;
    private NLP nlp;
    private String[] synonymColumnName = new String[11];
    private String[] synonymDescription = new String[11];
    private int numSynonyms = 0;
    private String[] syns = new String[11];
    private String[] origs = new String[11];
    private int numSynReplacements = 0;
    private String[] databaseName = new String[5];
    private String[] userName = new String[5];
    private String[] password = new String[5];
    private String[] tableList = new String[5];
    private int numDB = 0;

    public NLEngine() {
        this.dbinfo = new DBInfo();
        this.nlp = new NLP(this.dbinfo);
    }

    public void addDB(String string, String string2, String string3, String string4) {
        if (this.numDB < 4) {
            this.databaseName[this.numDB] = string;
            this.userName[this.numDB] = string2;
            this.password[this.numDB] = string3;
            this.tableList[this.numDB] = string4;
            ++this.numDB;
        }
    }

    public void initDB() {
        int n = 0;
        while (n < this.numDB) {
            String[] stringArray;
            if (this.databaseName[n] != null && (stringArray = Util.parseStrings(this.tableList[n])) != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    try {
                        String[] stringArray2 = DBInterface.getColumnNames(stringArray[n2], this.databaseName[n], this.userName[n], this.password[n]);
                        if (stringArray2 != null) {
                            this.dbinfo.addTable(stringArray[n2], this.databaseName[n], this.userName[n], this.password[n], stringArray2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.dbinfo.debug();
    }

    public void parse(String string) {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < 20) {
            n2 = string.indexOf(",");
            if (n2 <= -1) break;
            string = string.substring(0, n2) + string.substring(n2 + 1);
            ++n3;
        }
        n2 = 0;
        while (n2 < 10) {
            n = string.indexOf(".");
            if (n <= -1) break;
            string = string.substring(0, n) + string.substring(n + 1);
            ++n2;
        }
        string = " " + Util.removeExtraSpaces(string).toLowerCase() + " ";
        this.numSynReplacements = 0;
        n = 0;
        while (n < this.numSynonyms) {
            int n4 = 0;
            while (n4 < 4) {
                int n5 = string.indexOf(this.synonymDescription[n]);
                if (n5 <= -1) break;
                string = string.substring(0, n5 + 1) + this.synonymColumnName[n] + string.substring(n5 + this.synonymDescription[n].length() - 1);
                this.syns[this.numSynReplacements] = this.synonymColumnName[n];
                this.origs[this.numSynReplacements] = this.synonymDescription[n];
                ++this.numSynReplacements;
                ++n4;
            }
            ++n;
        }
        string = Util.removeExtraSpaces(string);
        this.nlp.parse(string);
    }

    public String getSQL() {
        return this.nlp.getSQL();
    }

    public String[] breakLines(String string) {
        String[] stringArray = new String[40];
        int n = 0;
        this.num_rows_from_database = 0;
        try {
            int n2;
            Object object;
            StringReader stringReader = new StringReader(string);
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            block2: while ((object = bufferedReader.readLine()) != null && object.length() >= 1) {
                ++this.num_rows_from_database;
                n2 = 0;
                while (true) {
                    if ((n2 = object.indexOf(",")) == -1) {
                        if (n > 38) continue block2;
                        stringArray[n++] = object.trim();
                        continue block2;
                    }
                    if (n > 38) continue block2;
                    stringArray[n++] = object.substring(0, n2);
                    object = object.substring(n2 + 1);
                }
            }
            object = new String[n];
            n2 = 0;
            while (n2 < n) {
                object[n2] = stringArray[n2];
                ++n2;
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toEnglish(String string) {
        System.out.println("NLEngineLocal.toEnglish(" + string + ")");
        return this.nlp.toEnglish(this.breakLines(string), this.syns, this.origs, this.numSynReplacements, this.num_rows_from_database);
    }

    public void createResultSet(String string, String string2, String string3, String string4) {
    }

    public String[] getColumnNames(String string, String string2, String string3, String string4) {
        try {
            return DBInterface.getColumnNames(string, string2, string3, string4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getRows(String string, String string2, String string3, String string4) {
        try {
            return DBInterface.query(string, string2, string3, string4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clearSynonyms() {
        this.numSynonyms = 0;
    }

    public void addSynonym(String string, String string2) {
        if (this.numSynonyms < 10) {
            this.synonymColumnName[this.numSynonyms] = string;
            this.synonymDescription[this.numSynonyms] = " " + string2 + " ";
            ++this.numSynonyms;
        }
    }
}

