/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class ExecutorsExample
extends ConcurrentExample {
    private Executor executor;
    private int nextIndex;
    private final JButton executeButton = new JButton("execute");
    private boolean initialized = false;
    private int sleepTime = 1000;
    public static final String FIXED_TYPE = "FixedThreadPool";
    public static final String SINGLE_TYPE = "SingleThreadExecutor";
    public static final String CACHED_TYPE = "CachedThreadPool";
    private final JTextField threadCountField = this.createThreadCountField();

    public ExecutorsExample(String string, Container container, int n) {
        super(string, container, ExampleType.BLOCKING, 390, false, n);
    }

    @Override
    protected void setDefaultState() {
        if (this.getTitle().equals(FIXED_TYPE)) {
            this.setState(0);
        } else if (this.getTitle().equals(SINGLE_TYPE)) {
            this.setState(1);
        } else if (this.getTitle().equals(CACHED_TYPE)) {
            this.setState(2);
        }
    }

    @Override
    protected String getSnippet() {
        return "<html><PRE><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// FixedThreadPool Construction</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> Executor executor = </FONT>\n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\">     Executors.newFixedThreadPool(4);\n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// SingleThreadExecutor Construction</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Executor executor = </FONT>\n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">     Executors.newSingleThreadExecutor(); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// CachedThreadPool Construction</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Executor executor = </FONT>\n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">     Executors.newCachedThreadPool(); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Use the Executor to launch some Runnable </I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> \n      executor.execute(</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>new</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> Runnable(){ \n        </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>public</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>void</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> run(){ \n          </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#808080>\"><I>// do work</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> \n        } \n    </FONT></PRE></html";
    }

    @Override
    protected void initializeComponents() {
        if (!this.initialized) {
            this.initializeExecuteButton();
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
        this.reset();
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    private void initializeFixedThreadPool() {
        this.executor = Executors.newFixedThreadPool(4);
    }

    private void initializeSingleThreadPool() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    private void initializeCachedThreadPool() {
        this.executor = Executors.newCachedThreadPool();
    }

    private void initializeExecuteButton() {
        this.initializeButton(this.executeButton, new Runnable(){

            @Override
            public void run() {
                int n = ExecutorsExample.this.getThreadCount(ExecutorsExample.this.threadCountField);
                for (int i = 0; i < n; ++i) {
                    final int n2 = ExecutorsExample.this.nextIndex++;
                    ExecutorsExample.this.message1("Executing index " + n2, ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
                    final ConcurrentSprite concurrentSprite = ExecutorsExample.this.createAcquiringSprite();
                    ExecutorsExample.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ExecutorsExample.this.setState(3);
                            concurrentSprite.setAcquired();
                            try {
                                int n = ExecutorsExample.this.sleepTime + (int)(Math.random() * 500.0);
                                Thread.sleep(n);
                                concurrentSprite.setReleased();
                            }
                            catch (InterruptedException interruptedException) {
                                concurrentSprite.setReleased();
                                Thread.currentThread().interrupt();
                            }
                            ExecutorsExample.this.message2("Completed executing index " + n2, ConcurrentExampleConstants.MESSAGE_COLOR);
                        }
                    });
                }
            }
        });
    }

    @Override
    protected void reset() {
        if (this.executor != null) {
            ((ExecutorService)this.executor).shutdown();
        }
        if (this.getTitle().equals(FIXED_TYPE)) {
            this.initializeFixedThreadPool();
        } else if (this.getTitle().equals(SINGLE_TYPE)) {
            this.initializeSingleThreadPool();
        } else if (this.getTitle().equals(CACHED_TYPE)) {
            this.initializeCachedThreadPool();
        }
        this.resetThreadCountField(this.threadCountField);
        this.nextIndex = 1;
        this.message1(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.message2(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.setState(0);
        super.reset();
    }
}

