/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Color;
import java.awt.Container;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class ReadWriteLockExample
extends ConcurrentExample {
    private static final Logger logger = Logger.getLogger(ReadWriteLockExample.class.getCanonicalName());
    private ReadWriteLock lock;
    private final Object MUTEX = new Object();
    private final JButton readAcquireButton = new JButton("   lock.readLock().lock()    ");
    private final JButton readReleaseButton = new JButton("    unlock()   ");
    private final JButton writeAcquireButton = new JButton("   lock.writeLock().lock()   ");
    private final JButton writeDowngradeButton = new JButton("(Downgrade to read)");
    private boolean initialized = false;
    private static int minSnippetPosition = 390;
    private boolean downgrade = false;
    private boolean writerOwned = false;
    private final JTextField threadCountField = this.createThreadCountField();

    public ReadWriteLockExample(String string, Container container, boolean bl, int n) {
        super(string, container, ExampleType.BLOCKING, minSnippetPosition, bl, n);
    }

    @Override
    protected void initializeComponents() {
        if (!this.initialized) {
            this.initializeReadAcquireButton();
            this.initializeWriteAcquireButton();
            this.addButtonSpacer();
            this.initializeReadReleaseButton();
            this.initializeWriteDowngradeToReadButton();
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
    }

    @Override
    protected void setDefaultState() {
        if (this.isFair()) {
            this.setState(6);
        } else {
            this.setState(0);
        }
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    private void initializeReadAcquireButton() {
        this.initializeButton(this.readAcquireButton, new Runnable(){

            @Override
            public void run() {
                ReadWriteLockExample.this.setAnimationCanvasVisible(true);
                ReadWriteLockExample.this.setState(1);
                int n = ReadWriteLockExample.this.getThreadCount(ReadWriteLockExample.this.threadCountField);
                for (int i = 0; i < n; ++i) {
                    ReadWriteLockExample.this.threadCountExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ReadWriteLockExample.this.readAcquire();
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAcquire() {
        this.message1(new Date() + " Waiting to acquire READ lock", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
        Lock lock = this.lock.readLock();
        logger.info("Acquiring read lock " + lock);
        ConcurrentSprite concurrentSprite = this.createAcquiringSprite();
        lock.lock();
        this.writerOwned = false;
        concurrentSprite.setAcquired();
        this.message1(new Date() + " Acquired read lock ", ConcurrentExampleConstants.MESSAGE_COLOR);
        Object object = this.MUTEX;
        synchronized (object) {
            try {
                this.MUTEX.wait();
                logger.info("read waking");
                lock.unlock();
                concurrentSprite.setReleased();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void initializeWriteAcquireButton() {
        this.initializeButton(this.writeAcquireButton, new Runnable(){

            @Override
            public void run() {
                ReadWriteLockExample.this.setState(3);
                int n = ReadWriteLockExample.this.getThreadCount(ReadWriteLockExample.this.threadCountField);
                for (int i = 0; i < n; ++i) {
                    ReadWriteLockExample.this.threadCountExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ReadWriteLockExample.this.writeAcquire();
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAcquire() {
        this.message2(new Date() + " Waiting to acquire WRITE lock", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
        ConcurrentSprite concurrentSprite = this.createAcquiringSprite();
        Lock lock = this.lock.writeLock();
        concurrentSprite.setColor(Color.RED);
        lock.lock();
        concurrentSprite.setAcquired();
        this.message2(new Date() + " Acquired write lock ", ConcurrentExampleConstants.MESSAGE_COLOR);
        try {
            Object object = this.MUTEX;
            synchronized (object) {
                this.writerOwned = true;
                this.MUTEX.wait();
                if (this.downgrade) {
                    this.lock.readLock().lock();
                    lock.unlock();
                    this.writerOwned = false;
                    this.downgrade = false;
                    concurrentSprite.setColor(ConcurrentExampleConstants.ACQUIRING_COLOR);
                    this.MUTEX.notify();
                    this.MUTEX.wait();
                    this.lock.readLock().unlock();
                } else {
                    lock.unlock();
                }
                concurrentSprite.setReleased();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDowngradeToRead() {
        if (this.writerOwned) {
            this.setState(5);
            this.message2(new Date() + " Waiting to Downgrade WRITE lock...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            this.downgrade = true;
            Object object = this.MUTEX;
            synchronized (object) {
                this.MUTEX.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRelease() {
        this.message1(new Date() + " Waiting to release READ lock...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
        Object object = this.MUTEX;
        synchronized (object) {
            this.setState(4);
            this.downgrade = false;
            this.MUTEX.notify();
        }
        this.message1(".", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
    }

    private void initializeReadReleaseButton() {
        this.initializeButton(this.readReleaseButton, new Runnable(){

            @Override
            public void run() {
                ReadWriteLockExample.this.setState(2);
                ReadWriteLockExample.this.readRelease();
            }
        });
    }

    private void initializeWriteDowngradeToReadButton() {
        this.initializeButton(this.writeDowngradeButton, new Runnable(){

            @Override
            public void run() {
                ReadWriteLockExample.this.writeDowngradeToRead();
            }
        });
    }

    @Override
    protected void reset() {
        this.resetExample();
        this.lock = new ReentrantReadWriteLock(this.isFair());
        this.resetThreadCountField(this.threadCountField);
        this.setState(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetExample() {
        Object object = this.MUTEX;
        synchronized (object) {
            this.downgrade = false;
            this.MUTEX.notifyAll();
        }
        object = this.MUTEX;
        synchronized (object) {
            this.MUTEX.notifyAll();
        }
        super.reset();
        this.message1("  ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.message2("  ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
    }

    @Override
    protected String getSnippet() {
        String string = "<html><PRE>     <FONT style=\"font-family:monospaced;\" COLOR=\"#606060\"><I>// Construct the ReadWriteLock</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> ReadWriteLock lock =  \n        </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>new</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> ReentrantReadWriteLock(); \n        </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state6:#000080>\"><B>new</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state6:#000000>\"> ReentrantReadWriteLock(true); \n     \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#808080>\"><I>// Acquire the read lock</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>try</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> { \n      lock.readLock().lock(); \n      </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#808080>\"><I>// or</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> \n      lock.readLock().tryLock(</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000099>\">1000L, TimeUnit.MILLISECONDS</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">); \n    } </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>catch</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">(InterruptedException e) { }\n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#808080>\"><I>// Release the read lock</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> \n    lock.readLock().unlock(); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#808080>\"><I>// Acquire the write lock</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>try</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> { \n      lock.writeLock().lock(); \n      </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#808080>\"><I>// or</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> \n      lock.writeLock().tryLock(</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000099>\">1000L, TimeUnit.MILLISECONDS</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">); \n    } </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>catch</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">(InterruptedException e) { }\n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state4:#808080>\"><I>// Release the lock</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state4:#000000>\"> \n    lock.writeLock().unlock(); \n    // or \n    lock.readLock().unlock(); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state5:#808080>\"><I>// Downgrade the write lock</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state5:#000080>\"><B>try</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state5:#000000>\"> { \n      lock.readLock().lock(); \n      lock.writeLock().unlock();\n    } </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state5:#000080>\"><B>catch</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state5:#000000>\">(InterruptedException e) {} \n \n</FONT></PRE></html>";
        return string;
    }
}

