/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;
import vgrazi.concurrent.samples.sprites.ConcurrentSpriteCanvas;

public class SemaphoreExample
extends ConcurrentExample {
    private Semaphore semaphore;
    private final JButton timedtryAcquireButton = new JButton("tryAcquire(timeoutMS, TimeUnit.MILLISECONDS)");
    private final JButton acquireButton = new JButton("acquire");
    private final JButton releaseButton = new JButton("release");
    private final JButton immediatetryAcquireButton = new JButton("tryAcquire()");
    private boolean initialized = false;
    private String timeoutString = "";
    private final List<ConcurrentSprite> acquiredSprites = new ArrayList<ConcurrentSprite>();
    private static final int MIN_SNIPPET_POSITION = 320;
    private JTextField threadCountField = this.createThreadCountField();

    public SemaphoreExample(String string, Container container, boolean bl, int n) {
        super(string, container, ExampleType.BLOCKING, 320, bl, n);
        if (bl) {
            this.initializeFair();
        } else {
            this.initializeNonFair();
        }
    }

    @Override
    protected String getSnippet() {
        String string = "<html><PRE>\n<font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Constructor - pass in the permit count</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>final</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> Semaphore semaphore = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> Semaphore(4); \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state6:#000080>\"><B>final</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state6:#000000>\"> Semaphore semaphore = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state6:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state6:#000000>\"> Semaphore(4, true); \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Threads attempting to acquire will block</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// until the specified number of releases are counted</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\">Thread acquireThread = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Thread(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Runnable() { \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> run() { \n        </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>try</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> { \n          semaphore.acquire(); \n        } </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>catch</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">(InterruptedException e) { }\n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\">Thread releaseThread = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Thread(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Runnable() { \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> run() { \n        semaphore.release(); \n      } \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// tryAcquire is like acquire except that it</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// times out after the specified timeout period</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\">Thread tryAcquire = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> Thread(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> Runnable() { \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> run() { \n        </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>try</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> { \n          semaphore.tryAcquire(" + this.timeoutString + "</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">); \n" + "        } </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>catch</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">(InterruptedException e) { }\n" + "</FONT></PRE></html>";
        return string;
    }

    @Override
    protected void initializeComponents() {
        this.reset();
        if (!this.initialized) {
            this.initializeButton(this.timedtryAcquireButton, new Runnable(){

                @Override
                public void run() {
                    SemaphoreExample.this.timeoutString = "1000L, TimeUnit.MILLISECONDS";
                    int n = SemaphoreExample.this.getThreadCount(SemaphoreExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        SemaphoreExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                SemaphoreExample.this.tryTimedAcquire();
                            }
                        });
                    }
                }
            });
            this.initializeButton(this.immediatetryAcquireButton, new Runnable(){

                @Override
                public void run() {
                    SemaphoreExample.this.timeoutString = "";
                    int n = SemaphoreExample.this.getThreadCount(SemaphoreExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        SemaphoreExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                SemaphoreExample.this.tryUntimedAcquire();
                            }
                        });
                    }
                }
            });
            this.initializeButton(this.acquireButton, new Runnable(){

                @Override
                public void run() {
                    SemaphoreExample.this.setAnimationCanvasVisible(true);
                    int n = SemaphoreExample.this.getThreadCount(SemaphoreExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        SemaphoreExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                SemaphoreExample.this.acquire();
                            }
                        });
                    }
                }
            });
            this.initializeButton(this.releaseButton, new Runnable(){

                @Override
                public void run() {
                    int n = SemaphoreExample.this.getThreadCount(SemaphoreExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        SemaphoreExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                SemaphoreExample.this.release();
                            }
                        });
                    }
                }
            });
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
    }

    private void initializeNonFair() {
        this.reset();
        this.semaphore = new Semaphore(4, false);
    }

    private void initializeFair() {
        this.reset();
        this.setState(6);
        this.semaphore = new Semaphore(4, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        if (!this.acquiredSprites.isEmpty()) {
            ConcurrentSprite concurrentSprite;
            int n = this.semaphore.isFair() ? 0 : this.getRandomIndex();
            ConcurrentSprite concurrentSprite2 = concurrentSprite = this.acquiredSprites.remove(n);
            synchronized (concurrentSprite2) {
                concurrentSprite.notify();
            }
        }
    }

    private void _release(ConcurrentSprite concurrentSprite) {
        this.setState(2);
        this.message2("Attempting release ", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
        this.semaphore.release();
        this.shuffleSprites();
        concurrentSprite.setReleased();
        this.message2("Released ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire() {
        try {
            this.message1("Waiting for acquire...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            this.setState(1);
            ConcurrentSprite concurrentSprite = this.createAcquiringSprite();
            this.semaphore.acquire();
            this.acquiredSprites.add(concurrentSprite);
            concurrentSprite.setAcquired();
            this.message1("Acquired", ConcurrentExampleConstants.MESSAGE_COLOR);
            this.setState(1);
            ConcurrentSprite concurrentSprite2 = concurrentSprite;
            synchronized (concurrentSprite2) {
                concurrentSprite.wait();
            }
            this._release(concurrentSprite);
            this.acquiredSprites.remove(concurrentSprite);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryTimedAcquire() {
        block6: {
            try {
                this.setState(3);
                this.message1("Trying acquire..", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
                ConcurrentSprite concurrentSprite = this.createAttemptingSprite();
                if (this.semaphore.tryAcquire(3000L, TimeUnit.MILLISECONDS)) {
                    this.message1("Acquire succeeded", ConcurrentExampleConstants.MESSAGE_COLOR);
                    concurrentSprite.setAcquired();
                    this.setState(3);
                    this.acquiredSprites.add(concurrentSprite);
                    ConcurrentSprite concurrentSprite2 = concurrentSprite;
                    synchronized (concurrentSprite2) {
                        concurrentSprite.wait();
                    }
                    this._release(concurrentSprite);
                    this.acquiredSprites.remove(concurrentSprite);
                    break block6;
                }
                Thread.sleep(ConcurrentSpriteCanvas.getTimeToAcquireBorder());
                this.message1("Acquire failed", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
                concurrentSprite.setRejected();
                this.setState(3);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryUntimedAcquire() {
        block6: {
            this.setState(3);
            this.timeoutString = "";
            this.message1("Trying acquire..", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            ConcurrentSprite concurrentSprite = this.createAttemptingSprite();
            try {
                if (this.semaphore.tryAcquire()) {
                    this.message1("Acquire succeeded", ConcurrentExampleConstants.MESSAGE_COLOR);
                    concurrentSprite.setAcquired();
                    this.setState(3);
                    this.acquiredSprites.add(concurrentSprite);
                    ConcurrentSprite concurrentSprite2 = concurrentSprite;
                    synchronized (concurrentSprite2) {
                        concurrentSprite.wait();
                    }
                    this._release(concurrentSprite);
                    this.acquiredSprites.remove(concurrentSprite);
                    break block6;
                }
                Thread.sleep(ConcurrentSpriteCanvas.getTimeToAcquireBorder());
                this.message1("Acquire failed", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
                concurrentSprite.setRejected();
                this.setState(3);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reset() {
        super.reset();
        this.semaphore = new Semaphore(4, this.isFair());
        Iterator<ConcurrentSprite> iterator = this.acquiredSprites.iterator();
        while (iterator.hasNext()) {
            ConcurrentSprite concurrentSprite;
            ConcurrentSprite concurrentSprite2 = concurrentSprite = iterator.next();
            synchronized (concurrentSprite2) {
                concurrentSprite.notify();
            }
        }
        this.acquiredSprites.clear();
        this.resetThreadCountField(this.threadCountField);
        this.message1(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.message2(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
    }

    @Override
    protected void setDefaultState() {
        if (this.isFair()) {
            this.setState(6);
        } else {
            this.setState(0);
        }
    }

    private int getRandomIndex() {
        return 0;
    }
}

