/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.ImagePanel;
import vgrazi.concurrent.samples.MessageLabel;
import vgrazi.concurrent.samples.examples.ConcurrentExampleLayout;
import vgrazi.concurrent.samples.slides.ConcurrentSlideShow;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;
import vgrazi.concurrent.samples.sprites.ConcurrentSpriteCanvas;
import vgrazi.util.StringUtils;

public abstract class ConcurrentExample
extends JPanel {
    private Container container;
    protected final long timeout = 3000L;
    protected final JLabel message1Label = new MessageLabel(" ");
    protected final JLabel message2Label = new MessageLabel(" ");
    protected final JPanel imagePanel = new ImagePanel(this);
    protected final JButton resetButton = new JButton("Reset");
    private final ConcurrentSpriteCanvas canvas;
    protected final Random random = new Random();
    private AtomicInteger acquiring = new AtomicInteger(0);
    private AtomicInteger releasing = new AtomicInteger(0);
    public static final String FONT_SIZE = "5";
    private final JLabel snippetLabel = new JLabel();
    private final JScrollPane snippetPane = new JScrollPane(this.snippetLabel);
    protected final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if ((keyEvent.getModifiers() & 2) != 0) {
                if (keyEvent.getKeyCode() == 65) {
                    ConcurrentExample.this.setState(-1);
                } else if (keyEvent.getKeyCode() == 67) {
                    ConcurrentExample.this.reset();
                } else if (keyEvent.getKeyCode() == 83) {
                    ConcurrentExample.this.canvas.togglePauseResume();
                } else if (keyEvent.getKeyCode() == 82) {
                    ConcurrentExample.this.reset();
                } else if (keyEvent.getKeyCode() == 88) {
                    ConcurrentExample.this.message1("Canvas:" + this.toString(ConcurrentExample.this.canvas.getBounds()) + " " + (ConcurrentExample.this.canvas.isVisible() ? "Visible" : "Hidden"), Color.BLACK);
                    ConcurrentExample.this.message2("imagePanel:" + this.toString(ConcurrentExample.this.imagePanel.getBounds()) + " " + (ConcurrentExample.this.canvas.isVisible() ? "Visible" : "Hidden"), Color.BLACK);
                }
            }
            if (keyEvent.getKeyCode() == 34) {
                ConcurrentSlideShow.nextSlide();
            } else if (keyEvent.getKeyCode() == 33) {
                ConcurrentSlideShow.previousSlide();
            }
        }

        private String toString(Rectangle rectangle) {
            return "(" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height + ")";
        }
    };
    protected ConcurrentSprite acquiredSprite;
    private static final int RELEASING_DELTA = 10;
    private static final Font SNIPPET_FONT = new Font("Arial", 0, 12);
    private String title;
    private ExampleType exampleType;
    private boolean fair;
    private final int slideNumber;
    private final ConcurrentLinkedQueue<JButton> buttons = new ConcurrentLinkedQueue();
    protected final Executor threadCountExecutor = Executors.newCachedThreadPool();
    private static final Logger logger = Logger.getLogger(ConcurrentExample.class.getName());

    public ConcurrentExample(String string, Container container, ExampleType exampleType, int n, boolean bl, int n2) {
        this.title = string;
        this.exampleType = exampleType;
        this.fair = bl;
        this.slideNumber = n2;
        this.canvas = new ConcurrentSpriteCanvas(this, this.getTitle());
        this.setContainer(container);
        this.setLayout(new ConcurrentExampleLayout(n));
        this.setBackgroundColors();
        this.message1Label.setFont(ConcurrentExampleConstants.LABEL_FONT);
        this.message1Label.setOpaque(false);
        this.message2Label.setFont(ConcurrentExampleConstants.LABEL_FONT);
        this.message2Label.setOpaque(false);
        this.imagePanel.setBorder(BorderFactory.createEtchedBorder());
        this.snippetLabel.setOpaque(true);
        this.snippetLabel.setFocusable(true);
        this.snippetLabel.setFocusTraversalKeysEnabled(true);
        this.snippetPane.setFocusable(true);
        this.snippetPane.setFocusTraversalKeysEnabled(true);
        this.snippetLabel.addKeyListener(this.keyListener);
        this.snippetLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (((long)mouseEvent.getModifiersEx() & 0x100L) != 0L) {
                    ConcurrentSlideShow.previousSlide();
                } else {
                    ConcurrentSlideShow.nextSlide();
                }
            }
        });
        this.snippetLabel.setFont(SNIPPET_FONT);
        this.imagePanel.setOpaque(true);
    }

    public boolean isFair() {
        return this.fair;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    private void setBackgroundColors() {
        this.setBackground(ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.imagePanel.setBackground(ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.snippetLabel.setBackground(Color.white);
    }

    public void setAnimationCanvasVisible(boolean bl) {
        this.canvas.setVisible(bl);
        this.imagePanel.setVisible(!bl);
    }

    private void setContainer(Container container) {
        this.container = container;
    }

    protected synchronized ConcurrentSprite createAcquiringSprite() {
        return this.createAcquiringSprite(ConcurrentSprite.SpriteType.ARROW);
    }

    protected synchronized ConcurrentSprite createAcquiringSprite(ConcurrentSprite.SpriteType spriteType) {
        int n = this.getNextAcquiringIndex();
        return this.createAcquiringSprite(n, spriteType);
    }

    public void shuffleSprites() {
        this.canvas.shuffleSprites();
    }

    public synchronized ConcurrentSprite createAcquiringSprite(int n, ConcurrentSprite.SpriteType spriteType) {
        ConcurrentSprite concurrentSprite = new ConcurrentSprite(n);
        concurrentSprite.setType(spriteType);
        concurrentSprite.setAcquiring();
        this.canvas.addSprite(concurrentSprite);
        return concurrentSprite;
    }

    protected ConcurrentSprite createReleasingSprite() {
        ConcurrentSprite concurrentSprite = new ConcurrentSprite(this.getNextReleasingIndex());
        concurrentSprite.moveToAcquiringBorder();
        concurrentSprite.setColor(Color.ORANGE);
        concurrentSprite.setReleased();
        this.canvas.addSprite(concurrentSprite);
        return concurrentSprite;
    }

    public String getTitle() {
        return this.title;
    }

    protected ConcurrentSprite createAttemptingSprite() {
        return this.createAttemptingSprite(ConcurrentSprite.SpriteType.ARROW);
    }

    protected ConcurrentSprite createAttemptingSprite(ConcurrentSprite.SpriteType spriteType) {
        ConcurrentSprite concurrentSprite = new ConcurrentSprite(this.getNextAcquiringIndex());
        concurrentSprite.setType(spriteType);
        concurrentSprite.setAttempting();
        this.canvas.addSprite(concurrentSprite);
        return concurrentSprite;
    }

    protected abstract String getSnippet();

    public void bumpMutexVerticalIndex() {
        this.canvas.bumpVerticalMutexIndex();
    }

    public void resetMutexVerticalIndex() {
        this.canvas.resetMutexVerticalIndex();
    }

    protected void reset() {
        this.acquiring = new AtomicInteger(0);
        this.releasing = new AtomicInteger(0);
        this.canvas.clearSprites();
        if (!this.canvas.isVisible()) {
            this.imagePanel.setVisible(true);
        }
        this.canvas.resumeClock();
    }

    protected int getNextAcquiringIndex() {
        if (this.canvas.getSpriteCount() == 0) {
            this.acquiring.set(0);
            this.releasing.set(0);
        }
        return this.acquiring.incrementAndGet();
    }

    protected int getNextReleasingIndex() {
        return this.releasing.incrementAndGet() + 10;
    }

    protected abstract void initializeComponents();

    public abstract String getDescriptionHtml();

    public final void launchExample() {
        this.reset();
        this.initializeFrame();
    }

    protected void initializeFrame() {
        this.container.add(this);
        this.initializeComponents();
        this.initializeSnippet();
        this.initializeOutput();
        this.initializeAnimationCanvas();
        this.setDefaultState();
        this.validateTree();
        this.repaint();
    }

    protected void setDefaultState() {
        this.setState(0);
    }

    private void initializeAnimationCanvas() {
        this.canvas.setVisible(false);
        this.canvas.setExampleType(this.exampleType);
        this.add(this.canvas);
    }

    protected void initializeButton(JButton jButton, final Runnable runnable) {
        jButton.addKeyListener(this.keyListener);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(runnable);
                thread.start();
            }
        });
        this.add(jButton);
    }

    public Component add(JButton jButton) {
        this.buttons.add(jButton);
        return super.add(jButton);
    }

    protected void addButtonSpacer() {
        JLabel jLabel = new JLabel("                   ");
        jLabel.setBackground(ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        jLabel.setOpaque(true);
        this.add(jLabel);
    }

    protected final void initializeOutput() {
        this.add(this.message1Label);
        this.add(this.message2Label);
        this.add(this.imagePanel);
    }

    protected JTextField createThreadCountField() {
        JTextField jTextField = new JTextField(3);
        jTextField.setHorizontalAlignment(0);
        return jTextField;
    }

    protected void initializeThreadCountField(JTextField jTextField) {
        this.initializeThreadCountField(jTextField, "Thread Count:");
    }

    protected void initializeThreadCountField(final JTextField jTextField, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.white);
        jPanel.add(jLabel);
        final JSpinner jSpinner = new JSpinner();
        jSpinner.setEditor(jTextField);
        final boolean[] blArray = new boolean[]{false};
        jSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)jSpinner.getValue();
                if (n < 1) {
                    jSpinner.setValue(1);
                } else if (!blArray[0]) {
                    jTextField.setText(String.valueOf(n));
                }
            }
        });
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setSpinnerFromField();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setSpinnerFromField();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setSpinnerFromField();
            }

            private void setSpinnerFromField() {
                blArray[0] = true;
                jSpinner.setValue(ConcurrentExample.this.getThreadCount(jTextField));
                blArray[0] = false;
            }
        });
        Dimension dimension = jSpinner.getPreferredSize();
        dimension.width = 45;
        jSpinner.setPreferredSize(dimension);
        jPanel.add(jSpinner);
        this.resetThreadCountField(jTextField);
        jSpinner.setValue(this.getThreadCount(jTextField));
        this.add(jPanel);
    }

    protected int getThreadCount(JTextField jTextField) {
        int n = 1;
        String string = jTextField.getText();
        if (!StringUtils.isBlank(string)) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.info("User entered incorrect value, using 1");
            }
        }
        return n;
    }

    protected void resetThreadCountField(JTextField jTextField) {
        jTextField.setText("1");
    }

    protected void message1(String string, Color color) {
        JLabel jLabel = this.message1Label;
        this.message(jLabel, color, string);
    }

    protected void message2(String string, Color color) {
        JLabel jLabel = this.message2Label;
        this.message(jLabel, color, string);
    }

    private void message(final JLabel jLabel, Color color, final String string) {
        jLabel.setForeground(color);
        jLabel.setText(string);
        if (color == ConcurrentExampleConstants.MESSAGE_COLOR) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        if (jLabel.getText().equals(string) && jLabel.getForeground() == ConcurrentExampleConstants.MESSAGE_COLOR) {
                            jLabel.setForeground(ConcurrentExampleConstants.MESSAGE_FLASH_COLOR);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
            thread.start();
        }
    }

    protected void message1(Color color) {
        this.message1Label.setForeground(color);
        this.message1Label.setText(this.message1Label.getText());
    }

    protected void message2(Color color) {
        this.message2Label.setForeground(color);
        this.message2Label.setText(this.message2Label.getText());
    }

    protected void initializeResetButton() {
        this.initializeButton(this.resetButton, new Runnable(){

            @Override
            public void run() {
                ConcurrentExample.this.reset();
            }
        });
    }

    protected void setState(int n) {
        String string = this.getSnippet();
        if (string != null) {
            if (n == -1) {
                string = string.replaceAll("<state\\d:(#\\d\\d\\d\\d\\d\\d)>", "$1");
            } else {
                string = string.replaceAll("<state" + n + ":(#\\d\\d\\d\\d\\d\\d)>", "$1");
                string = string.replaceAll("<state\\d:(#\\d\\d\\d\\d\\d\\d)>", "#808080");
            }
            this.getSnippetLabel().setText(string);
        }
    }

    private JLabel getSnippetLabel() {
        return this.snippetLabel;
    }

    protected void initializeSnippet() {
        this.add(this.snippetPane);
    }

    public static void main(String[] stringArray) {
        String string = "COLOR=\"<state0:#808080>\"><I>";
        String string2 = string.replaceAll("<state0:(#\\d\\d\\d\\d\\d\\d)>", "$1");
        System.out.println(string2);
    }

    public ConcurrentSpriteCanvas getAnimationCanvas() {
        return this.canvas;
    }

    public JPanel getImagePanel() {
        return this.imagePanel;
    }

    protected synchronized void setAcquiredSprite(ConcurrentSprite concurrentSprite) {
        this.acquiredSprite = concurrentSprite;
    }

    public void sleepRandom(long l) throws InterruptedException {
        long l2 = this.random.nextInt((int)l);
        Thread.sleep(l2);
    }

    public void sleepRandom(long l, long l2) throws InterruptedException {
        long l3 = this.random.nextInt((int)(l2 - l + l));
        Thread.sleep(l3);
    }

    public void spriteRemoved(ConcurrentSprite concurrentSprite) {
    }

    public void setButtonsVisible(boolean bl) {
        for (JButton jButton : this.buttons) {
            jButton.setVisible(bl);
        }
    }

    public int getSlideNumber() {
        return this.slideNumber;
    }

    public Map<Integer, ActionListener> getSlideShowSlides() {
        return ConcurrentSlideShow.slideShowSlides;
    }
}

