/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JButton;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class ConditionExample
extends ConcurrentExample {
    private ReentrantLock lock;
    private Condition condition;
    private final JButton awaitButton = new JButton("await");
    private final JButton signalButton = new JButton("signal");
    private final JButton signalAllButton = new JButton("signalAll");
    private boolean initialized = false;
    private static final int MIN_SNIPPET_POSITION = 300;

    public ConditionExample(String string, Container container, int n) {
        super(string, container, ExampleType.WORKING, 300, false, n);
        this.reset();
    }

    @Override
    protected void initializeComponents() {
        if (!this.initialized) {
            this.initializeButton(this.awaitButton, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ConditionExample.this.setState(1);
                        ConcurrentSprite concurrentSprite = ConditionExample.this.createAcquiringSprite();
                        ConditionExample.this.lock.lock();
                        ConditionExample.this.condition.await();
                        concurrentSprite.setReleased();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        ConditionExample.this.lock.unlock();
                    }
                }
            });
            this.initializeButton(this.signalButton, new Runnable(){

                @Override
                public void run() {
                    ConditionExample.this.createReleasingSprite();
                    ConditionExample.this.setState(2);
                    ConditionExample.this.lock.lock();
                    ConditionExample.this.condition.signal();
                    ConditionExample.this.lock.unlock();
                }
            });
            this.initializeButton(this.signalAllButton, new Runnable(){

                @Override
                public void run() {
                    ConditionExample.this.createReleasingSprite();
                    ConditionExample.this.setState(3);
                    ConditionExample.this.lock.lock();
                    ConditionExample.this.condition.signalAll();
                    ConditionExample.this.lock.unlock();
                }
            });
            this.initialized = true;
        }
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void reset() {
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.message1(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.message2(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.setState(0);
        super.reset();
    }

    @Override
    protected String getSnippet() {
        return "<html><PRE><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\">    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"><B>Lock lock = </B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> ReentrantLock(); \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"><B>Condition condition = </B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> lock.newCondition(); \n\n<font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#808080>\"></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> \n    lock.lock();\n    try {\n      condition.await(); \n    } catch(InterruptedException e) {}\n</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> \n    finally {\n      lock.unlock();\n    } \n</FONT>\n<font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> \n    lock.lock();\n    condition.signal();\n    lock.unlock();\n</FONT>\n<font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> \n    lock.lock();\n    condition.signalAll();\n    lock.unlock();\n</FONT></PRE></html>";
    }
}

