/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.Date;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class CyclicBarrierExample
extends ConcurrentExample {
    private CyclicBarrier barrier;
    private final JButton barrierButton = new JButton("await()");
    private final JButton attemptButton = new JButton("await(timeMS, TimeUnit.MILLISECONDS)");
    private final JButton createButton = new JButton("barrier.reset()");
    private boolean initialized;
    private static final int MIN_SNIPPET_POSITION = 360;
    private JTextField threadCountField = this.createThreadCountField();

    public CyclicBarrierExample(String string, Container container, int n) {
        super(string, container, ExampleType.WORKING, 360, false, n);
    }

    @Override
    protected void initializeComponents() {
        if (!this.initialized) {
            this.initializeButton(this.barrierButton, new Runnable(){

                @Override
                public void run() {
                    int n = CyclicBarrierExample.this.getThreadCount(CyclicBarrierExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        CyclicBarrierExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                CyclicBarrierExample.this.release();
                            }
                        });
                    }
                }
            });
            this.initializeButton(this.attemptButton, new Runnable(){

                @Override
                public void run() {
                    int n = CyclicBarrierExample.this.getThreadCount(CyclicBarrierExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        CyclicBarrierExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                CyclicBarrierExample.this.attempt();
                            }
                        });
                    }
                }
            });
            this.initializeButton(this.createButton, new Runnable(){

                @Override
                public void run() {
                    CyclicBarrierExample.this.reset();
                    CyclicBarrierExample.this.setState(3);
                }
            });
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
        this.reset();
    }

    private void release() {
        ConcurrentSprite concurrentSprite = null;
        try {
            this.setAnimationCanvasVisible(true);
            this.message1("Waiting for barrier...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            this.setState(1);
            this.message2(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
            concurrentSprite = this.createAcquiringSprite();
            int n = this.barrier.await();
            concurrentSprite.setReleased();
            this.message1("barrier complete " + n, ConcurrentExampleConstants.MESSAGE_COLOR);
        }
        catch (BrokenBarrierException brokenBarrierException) {
            System.out.println("CyclicBarrierExample.attempt " + brokenBarrierException);
            this.message1("BrokenBarrierException.", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
            concurrentSprite.setRejected();
            this.resetBarrier();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void attempt() {
        ConcurrentSprite concurrentSprite = null;
        try {
            this.setAnimationCanvasVisible(true);
            this.message1("Waiting for barrier...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            this.setState(2);
            this.message2(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
            concurrentSprite = this.createAttemptingSprite();
            int n = this.barrier.await(3000L, TimeUnit.MILLISECONDS);
            concurrentSprite.setReleased();
            this.message1("barrier complete " + n, ConcurrentExampleConstants.MESSAGE_COLOR);
        }
        catch (BrokenBarrierException brokenBarrierException) {
            System.out.println("CyclicBarrierExample.attempt " + brokenBarrierException);
            this.message1("BrokenBarrierException.", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
            concurrentSprite.setRejected();
            this.resetBarrier();
        }
        catch (TimeoutException timeoutException) {
            concurrentSprite.setRejected();
            this.message1("TimeoutException.", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
            System.out.println("CyclicBarrierExample.attempt " + timeoutException);
            this.resetBarrier();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void resetBarrier() {
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void reset() {
        super.reset();
        this.createBarrier();
        this.resetThreadCountField(this.threadCountField);
        this.message1(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.message2(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.setState(0);
    }

    private void createBarrier() {
        if (this.barrier != null) {
            this.barrier.reset();
        } else {
            this.barrier = new CyclicBarrier(4, new Runnable(){

                @Override
                public void run() {
                    CyclicBarrierExample.this.setState(2);
                    CyclicBarrierExample.this.message2(new Date() + " Runnable hit", ConcurrentExampleConstants.MESSAGE_COLOR);
                }
            });
        }
    }

    @Override
    protected String getSnippet() {
        String string = "<html><PRE><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\">    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Contructor specifies number of parties, and an<br>    // optional Runnable that gets called when the</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// barrier is opened.</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>final</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> CyclicBarrier cyclicBarrier = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><br>    <B>    new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> CyclicBarrier(4</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\">, </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> Runnable(){ \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> run(){ \n        System.out.println(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> Date() + </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#008000>\"><B>&quot; Runnable hit&quot;</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\">); \n      } \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Each call to await() blocks, until<br>    // the number specified in the constructor is reached.</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Then the Runnable is executed and all can pass. </I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\">    <font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> \n    Thread thread = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Thread(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Runnable(){ \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> run() { \n        </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>try</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> { \n          cyclicBarrier.await(); \n        } </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>catch</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">(BrokenBarrierException e) {} \n \n    <font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> \n    Thread thread = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Thread(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Runnable(){ \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> run() { \n        </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>try</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> { \n          cyclicBarrier.await(timeout, TimeUnit.MILLISECONDS); \n        } </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>catch</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">(BrokenBarrierException e) {} \n \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// reset() allows the barrier to be reused.</I></FONT><font style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Any waiting threads will throw a BrokenBarrierException</I></FONT><font style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    <font style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">cyclicBarrier.reset()</FONT><font style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">); \n</FONT></PRE></html>";
        return string;
    }
}

