/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JButton;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class FutureExample
extends ConcurrentExample {
    private final JButton launchButton = new JButton("(Launch)");
    private final JButton getButton = new JButton("get");
    private Future<Object> future;
    private ConcurrentSprite sprite;
    private boolean initialized = false;
    private static final int MIN_SNIPPET_POSITION = 300;

    private void executorApproach() throws ExecutionException, InterruptedException {
        this.setAnimationCanvasVisible(true);
        this.sprite = this.createAcquiringSprite();
        this.sprite.setAcquired();
        this.sprite.moveToAcquiringBorder();
        this.future = Executors.newCachedThreadPool().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Thread.sleep(1000L);
                    FutureExample.this.sleepRandom(500L, 1000L);
                    FutureExample.this.sprite.setActionCompleted();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                return "execution completed.";
            }
        });
    }

    @Override
    public String getTitle() {
        return "Future";
    }

    @Override
    protected String getSnippet() {
        return "<html><PRE><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"000000\"><I>// Future objects are returned from Executors</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"000000\"><I>//   or can be created by developers.</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"000000\"><I>// The Future.get() method blocks</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"000000\"><I>//   until some result is available.</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Executors submit() methods return Future objects</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> final Future&lt;Object> future = </FONT>\n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">     Executors.newCachedThreadPool().submit(someCallable); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">//  Finally, the Future task completes</FONT>\n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">//       and the block passes through.</FONT>\n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\">Object result = future.get(); \n \n    </FONT></PRE></html";
    }

    public FutureExample(String string, Container container, int n) {
        super(string, container, ExampleType.ONE_USE, 300, false, n);
    }

    @Override
    protected void initializeComponents() {
        if (!this.initialized) {
            this.initializeButton(this.launchButton, new Runnable(){

                @Override
                public void run() {
                    try {
                        FutureExample.this.setState(1);
                        FutureExample.this.enableSetButton();
                        FutureExample.this.executorApproach();
                    }
                    catch (ExecutionException executionException) {
                        executionException.printStackTrace();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            });
            this.initializeButton(this.getButton, new Runnable(){

                @Override
                public void run() {
                    FutureExample.this.setState(2);
                    if (FutureExample.this.future != null) {
                        try {
                            FutureExample.this.future.get();
                            if (FutureExample.this.sprite != null) {
                                FutureExample.this.sprite.setReleased();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException executionException) {
                            executionException.printStackTrace();
                        }
                    }
                    FutureExample.this.getButton.setEnabled(false);
                }
            });
            this.initialized = true;
        }
    }

    @Override
    public void spriteRemoved(ConcurrentSprite concurrentSprite) {
        this.bumpMutexVerticalIndex();
        this.enableGetButton();
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void reset() {
        this.message1(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.message2(" ", ConcurrentExampleConstants.MESSAGE_COLOR);
        this.resetMutexVerticalIndex();
        this.setState(0);
        this.enableGetButton();
        super.reset();
    }

    private void enableGetButton() {
        this.getButton.setEnabled(false);
        this.launchButton.setEnabled(true);
        this.launchButton.requestFocus();
    }

    private void enableSetButton() {
        this.getButton.setEnabled(true);
        this.launchButton.setEnabled(false);
        this.getButton.requestFocus();
    }
}

