/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.CAS;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class AtomicIntegerExample
extends ConcurrentExample {
    private AtomicInteger atomicInteger;
    private static ExecutorService threadPool = Executors.newCachedThreadPool();
    private final JButton compareAndSetButton = new JButton("compareAndSet");
    private final JButton incrementAndGetButton = new JButton("incrementAndGet");
    private boolean initialized = false;
    private JTextField threadCountField = this.createThreadCountField();
    private static final int MIN_SNIPPET_POSITION = 400;
    private int value;

    public AtomicIntegerExample(String string, Container container, int n) {
        super(string, container, ExampleType.CAS, 400, true, n);
        this.reset();
        this.setState(6);
    }

    @Override
    protected String getSnippet() {
        String string = "<html><PRE>\n<FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Construct the AtomicVariable with the initial value</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> AtomicInteger atomicVariable = </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>new</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> AtomicInteger(</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#0000ff>\">1</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\">); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// compareAndSet does an atomic &quot;check and set if&quot;.</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Value is only set if the original value == assumedValue</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>int</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> assumedValue = </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#0000ff>\">10</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">, newValue = </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#0000ff>\">5</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">; \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>boolean</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> success = atomicVariable.compareAndSet(assumedValue, newValue); \n \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Arithmetic functions such as add, subtract, multiply,</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// divide, perform their function in an atomic fashion</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// and return the result.</I></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>final</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> </FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>int</B></FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> result = atomicVariable.incrementAndGet(</FONT><FONT style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\">); \n \n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n</PRE></html>";
        return string;
    }

    @Override
    protected void initializeComponents() {
        this.reset();
        if (!this.initialized) {
            this.initializeButton(this.compareAndSetButton, new Runnable(){

                @Override
                public void run() {
                    AtomicIntegerExample.this.compareAndSet();
                }
            });
            this.initializeButton(this.incrementAndGetButton, new Runnable(){

                @Override
                public void run() {
                    AtomicIntegerExample.this.incrementAndGet();
                }
            });
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
    }

    private void compareAndSet() {
        try {
            ConcurrentSprite concurrentSprite;
            int n;
            this.setState(1);
            ArrayList<ConcurrentSprite> arrayList = new ArrayList<ConcurrentSprite>();
            int n2 = this.getThreadCount(this.threadCountField);
            for (n = 0; n < n2; ++n) {
                concurrentSprite = this.createAcquiringSprite();
                concurrentSprite.setType(ConcurrentSprite.SpriteType.CAS);
                concurrentSprite.setExpectedValue(CAS.getValue());
                concurrentSprite.setValue(++this.value);
                arrayList.add(concurrentSprite);
            }
            Thread.sleep(1500L);
            while (!arrayList.isEmpty()) {
                n = this.random.nextInt(arrayList.size());
                concurrentSprite = (ConcurrentSprite)arrayList.remove(n);
                System.out.printf("Checking integer:%2d  expected:%2d   new:%2d%n", this.atomicInteger.get(), concurrentSprite.getExpectedValue(), concurrentSprite.getValue());
                boolean bl = this.atomicInteger.compareAndSet(concurrentSprite.getExpectedValue(), concurrentSprite.getValue());
                if (bl) {
                    concurrentSprite.setAcquired();
                    Thread.sleep(700L);
                    CAS.setValue(concurrentSprite.getValue());
                    concurrentSprite.setValue(ConcurrentSprite.NO_VALUE);
                    concurrentSprite.setReleased();
                    continue;
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(700L);
                            concurrentSprite.setRejected();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                };
                threadPool.submit(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void incrementAndGet() {
        try {
            ConcurrentSprite concurrentSprite;
            int n;
            this.setState(2);
            ArrayList<ConcurrentSprite> arrayList = new ArrayList<ConcurrentSprite>();
            int n2 = this.getThreadCount(this.threadCountField);
            for (n = 0; n < n2; ++n) {
                concurrentSprite = this.createAcquiringSprite();
                concurrentSprite.setType(ConcurrentSprite.SpriteType.CAS);
                concurrentSprite.setValue(ConcurrentSprite.NO_VALUE);
                concurrentSprite.setExpectedValue(ConcurrentSprite.NO_VALUE);
                arrayList.add(concurrentSprite);
            }
            Thread.sleep(1500L);
            while (!arrayList.isEmpty()) {
                n = this.random.nextInt(arrayList.size());
                concurrentSprite = (ConcurrentSprite)arrayList.remove(n);
                int n3 = this.atomicInteger.incrementAndGet();
                concurrentSprite.setExpectedValue(ConcurrentSprite.NO_VALUE);
                concurrentSprite.setAcquired();
                Thread.sleep(700L);
                CAS.setValue(n3);
                concurrentSprite.setReleased();
                concurrentSprite.setType(ConcurrentSprite.SpriteType.CAS);
                concurrentSprite.setValue(n3);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void reset() {
        super.reset();
        this.resetThreadCountField(this.threadCountField);
        this.setState(0);
        this.value = 1;
        this.atomicInteger = new AtomicInteger(this.value);
        CAS.setValue(this.atomicInteger.intValue());
        this.message1(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.message2(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
    }

    @Override
    protected void setDefaultState() {
        this.setState(0);
    }
}

