/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.examples;

import java.awt.Container;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JTextField;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ExampleType;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.sprites.ConcurrentSprite;

public class BlockingQueueExample
extends ConcurrentExample {
    private BlockingQueue<ConcurrentSprite> queue;
    private final JButton putButton = new JButton("put");
    private final JButton pollButton = new JButton("poll");
    private final JButton offerButton = new JButton("offer");
    private int index;
    private boolean initialized = false;
    private static final int MIN_SNIPPET_POSITION = 340;
    private JTextField threadCountField = this.createThreadCountField();

    @Override
    public String getTitle() {
        return "BlockingQueue";
    }

    public BlockingQueueExample(String string, Container container, int n) {
        super(string, container, ExampleType.BLOCKING, 340, false, n);
    }

    @Override
    protected void initializeComponents() {
        this.reset();
        if (!this.initialized) {
            this.initializeButton(this.putButton, new Runnable(){

                @Override
                public void run() {
                    BlockingQueueExample.this.setAnimationCanvasVisible(true);
                    int n = BlockingQueueExample.this.getThreadCount(BlockingQueueExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        BlockingQueueExample.this.put();
                    }
                }
            });
            this.initializeButton(this.pollButton, new Runnable(){

                @Override
                public void run() {
                    int n = BlockingQueueExample.this.getThreadCount(BlockingQueueExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        BlockingQueueExample.this.poll();
                    }
                }
            });
            this.initializeButton(this.offerButton, new Runnable(){

                @Override
                public void run() {
                    int n = BlockingQueueExample.this.getThreadCount(BlockingQueueExample.this.threadCountField);
                    for (int i = 0; i < n; ++i) {
                        BlockingQueueExample.this.threadCountExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                BlockingQueueExample.this.offer();
                            }
                        });
                    }
                }
            });
            this.initializeThreadCountField(this.threadCountField);
            this.initialized = true;
        }
    }

    private void put() {
        try {
            this.message1("Waiting for acquire...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            this.setState(1);
            ConcurrentSprite concurrentSprite = this.createAcquiringSprite(ConcurrentSprite.SpriteType.OVAL);
            this.queue.put(concurrentSprite);
            concurrentSprite.setAcquired();
            this.message1("Acquired", ConcurrentExampleConstants.MESSAGE_COLOR);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private void poll() {
        this.setState(2);
        int n = this.index++;
        this.message2("Attempting removal " + n, ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
        ConcurrentSprite concurrentSprite = (ConcurrentSprite)this.queue.poll();
        if (concurrentSprite != null) {
            concurrentSprite.setReleased();
            this.message2("Removed index " + n, ConcurrentExampleConstants.MESSAGE_COLOR);
        }
    }

    private void offer() {
        try {
            this.message1("Waiting for acquire...", ConcurrentExampleConstants.WARNING_MESSAGE_COLOR);
            this.setState(3);
            ConcurrentSprite concurrentSprite = this.createAttemptingSprite(ConcurrentSprite.SpriteType.OVAL);
            if (this.queue.offer(concurrentSprite, 3000L, TimeUnit.MILLISECONDS)) {
                concurrentSprite.setAcquired();
                this.message1("Acquired", ConcurrentExampleConstants.MESSAGE_COLOR);
            } else {
                concurrentSprite.setRejected();
                this.message1("Rejected", ConcurrentExampleConstants.ERROR_MESSAGE_COLOR);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String getDescriptionHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    protected void reset() {
        super.reset();
        this.resetThreadCountField(this.threadCountField);
        this.queue = new ArrayBlockingQueue<ConcurrentSprite>(4);
        this.index = 1;
        this.message1(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.message2(" ", ConcurrentExampleConstants.DEFAULT_BACKGROUND);
        this.setState(0);
    }

    @Override
    protected String getSnippet() {
        String string = "<html><PRE>\n<font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Constructor - pass in the upper bound</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>final</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> BlockingQueue queue = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state0:#000000>\"> ArrayBlockingQueue<ConcurrentSprite>(4); \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Threads attempting to put will block</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// until the there is room in the buffer</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\">Thread putThread = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Thread(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> Runnable() { \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> run() { \n        </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>try</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\"> { \n          queue.put(); \n        } </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000080>\"><B>catch</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state1:#000000>\">(InterruptedException e) { }\n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// Threads attempting to poll will block</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// until the there is something to take</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\">Thread pollThread = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Thread(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> Runnable() { \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state2:#000000>\"> run() { \n        queue.poll(); \n      } \n \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// offer is like put except that it</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#808080\"><I>// times out after the specified timeout period</I></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"#000000\"> \n    </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\">Thread offerThread = </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> Thread(</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>new</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> Runnable() { \n      </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>public</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>void</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> run() { \n        </FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>try</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\"> { \n          queue.offer(someObject, 1000L, TimeUnit.MILLISECONDS</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">); \n        }</FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000080>\"><B>catch</B></FONT><font 'style=\"font-family:monospaced;\" COLOR=\"<state3:#000000>\">(InterruptedException e) { }\n</FONT></PRE></html>";
        return string;
    }
}

