/*
 * Decompiled with CFR 0.152.
 */
package vgrazi.concurrent.samples.launcher;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vgrazi.concurrent.samples.Alignment;
import vgrazi.concurrent.samples.ConcurrentExampleConstants;
import vgrazi.concurrent.samples.ImagePanel;
import vgrazi.concurrent.samples.ImagePanelActionListener;
import vgrazi.concurrent.samples.examples.AtomicIntegerExample;
import vgrazi.concurrent.samples.examples.BlockingQueueExample;
import vgrazi.concurrent.samples.examples.CompletionServiceExample;
import vgrazi.concurrent.samples.examples.ConcurrentExample;
import vgrazi.concurrent.samples.examples.ConditionExample;
import vgrazi.concurrent.samples.examples.CountDownLatchExample;
import vgrazi.concurrent.samples.examples.CyclicBarrierExample;
import vgrazi.concurrent.samples.examples.ExampleActionListener;
import vgrazi.concurrent.samples.examples.ExecutorsExample;
import vgrazi.concurrent.samples.examples.FutureExample;
import vgrazi.concurrent.samples.examples.ReadWriteLockExample;
import vgrazi.concurrent.samples.examples.ReentrantLockExample;
import vgrazi.concurrent.samples.examples.SemaphoreExample;
import vgrazi.concurrent.samples.slides.ConcurrentSlideShow;
import vgrazi.util.IOUtils;
import vgrazi.util.UIUtils;

public class ConcurrentExampleLauncher {
    private static final Logger logger = Logger.getLogger(ConcurrentExampleLauncher.class.getCanonicalName());
    private final JFrame frame = new JFrame();
    private final Container container = this.frame.getContentPane();
    private JLabel backgroundImage;
    private ConcurrentExample examplePanel;
    private final MenuBar menuBar = new MenuBar();
    private final TreeMap<Integer, ActionListener> slideShowSlides = new TreeMap();
    private static int left;
    private static int top;
    private static int width;
    private static int height;
    private static final String REFERENCES = "References";
    private static final String HELP = "Help";
    private static ConcurrentExampleLauncher instance;
    private ImagePanel imagePanel;
    private static int delta;
    private static final KeyAdapter keyListener;
    private static String SPLASH_LABEL;
    private static String REFERENCES_LABEL;
    JPanel splashPanel = new JPanel();
    JPanel referencesPanel = new JPanel();
    boolean flip = false;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length >= 4) {
            left = Integer.parseInt(stringArray[0]);
            top = Integer.parseInt(stringArray[1]);
            width = Integer.parseInt(stringArray[2]);
            height = Integer.parseInt(stringArray[3]);
        }
        instance = new ConcurrentExampleLauncher();
    }

    private void initializeMenuItems() {
        this.warmup();
        this.initializeImageSlide("images/concurrent.gif", SPLASH_LABEL, delta++, false, Alignment.CENTER);
        this.initializeImageSlide("images/concurrentPackage.jpg", delta++, false, Alignment.CENTER);
        this.initializeImageSlide("images/executors.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("Executors", new ExecutorsExample("FixedThreadPool", this.container, delta++), new ExecutorsExample("SingleThreadExecutor", this.container, delta++), new ExecutorsExample("CachedThreadPool", this.container, delta++));
        this.initializeMenuItem("Semaphore", new SemaphoreExample("Semaphore", this.container, false, delta++), new SemaphoreExample("Semaphore (fair)", this.container, true, delta++));
        this.initializeImageSlide("images/future.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("Future", new FutureExample("Future", this.container, delta++));
        this.initializeImageSlide("images/reentrantLock.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("ReentrantLock", new ReentrantLockExample("ReentrantLock", this.container, delta++));
        this.initializeImageSlide("images/condition.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("Condition", new ConditionExample("Condition", this.container, delta++));
        this.initializeImageSlide("images/reentrantRWLock.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("ReadWriteLock", new ReadWriteLockExample("ReadWriteLock (default)", this.container, false, delta++), new ReadWriteLockExample("ReadWriteLock (fair)", this.container, false, -1));
        this.initializeImageSlide("images/blockingQueue.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("BlockingQueue", new BlockingQueueExample("BlockingQueue", this.container, delta++));
        this.initializeImageSlide("images/cyclicBarrier.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("CyclicBarrier", new CyclicBarrierExample("CyclicBarrier", this.container, delta++));
        this.initializeImageSlide("images/countdownLatch.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("CountDownLatch", new CountDownLatchExample("CountDownLatch", this.container, delta++));
        this.initializeImageSlide("images/AtomicInteger.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("AtomicInteger", new AtomicIntegerExample("Atomic Integer", this.container, delta++));
        this.initializeImageSlide("images/completionService.jpg", delta++, false, Alignment.CENTER);
        this.initializeMenuItem("CompletionService", new CompletionServiceExample("CompletionService", this.container, delta++));
        this.initializeImageSlide("images/concurrent.gif", REFERENCES_LABEL, delta++, false, Alignment.CENTER);
        this.initializeReferencesMenuItem();
        this.initializeHelpMenuItem();
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ConcurrentExampleLauncher.this.container.repaint();
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void warmup() {
        int n = delta++;
        new ExecutorsExample("FixedThreadPool", this.container, n);
    }

    private ConcurrentExampleLauncher() throws IOException {
        SPLASH_LABEL = IOUtils.readHtmlText("/images/instructions.html");
        REFERENCES_LABEL = IOUtils.readHtmlText("/images/references.html");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setMenuBar(this.menuBar);
        this.initializeMenuItems();
        UIUtils.center(this.frame, 0.9f, 0.9f);
        ((JComponent)this.container).setOpaque(true);
        this.setBackgroundColors();
        this.showSplash();
        this.frame.setVisible(true);
    }

    private void setBackgroundColors() {
        this.container.setBackground(ConcurrentExampleConstants.DEFAULT_BACKGROUND);
    }

    private void showSplash() {
        JLabel jLabel = new JLabel(SPLASH_LABEL);
        this.splashPanel.add(jLabel);
        this.showTitlePane(jLabel);
    }

    private void showReferences() {
        JLabel jLabel = new JLabel(REFERENCES_LABEL);
        this.referencesPanel.add(jLabel);
        this.showTitlePane(jLabel);
    }

    private void showTitlePane(JLabel jLabel) {
        this.showTitlePane(jLabel, "Visualizing the Java Concurrent API", "images/concurrent.gif", false, Alignment.CENTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showTitlePane(JLabel jLabel, String string, String string2, boolean bl, Alignment alignment) {
        try {
            this.clearFrame();
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
            if (string != null) {
                this.frame.setTitle(string);
            }
            ImageIcon imageIcon = this.getImageIcon(string2, bl);
            this.clearFrame();
            this.backgroundImage = new JLabel(imageIcon);
            this.backgroundImage.setHorizontalAlignment(alignment.getHorizontal());
            this.backgroundImage.setVerticalAlignment(alignment.getVertical());
            this.backgroundImage.setBackground(Color.white);
            this.backgroundImage.setOpaque(true);
            this.backgroundImage.setFocusable(true);
            this.backgroundImage.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (((long)mouseEvent.getModifiersEx() & 0x100L) != 0L) {
                        ConcurrentSlideShow.previousSlide();
                    } else {
                        ConcurrentSlideShow.nextSlide();
                    }
                }
            });
            this.container.add(this.backgroundImage);
            this.frame.getGlassPane().setVisible(true);
            if (jLabel != null) {
                ((Container)this.frame.getGlassPane()).add(jLabel);
            }
            this.frame.getGlassPane().validate();
            this.backgroundImage.addKeyListener(keyListener);
            this.backgroundImage.requestFocus();
            this.container.validate();
        }
        finally {
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private ImageIcon getImageIcon(String string, boolean bl) {
        URL uRL = ConcurrentExampleLauncher.class.getClassLoader().getResource(string);
        logger.log(Level.INFO, "ConcurrentExampleLauncher.showTitlePane image: " + uRL);
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (bl) {
            Dimension dimension = this.getImageSize(imageIcon);
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(dimension.width, dimension.height, 0));
        }
        return imageIcon;
    }

    private Dimension getImageSize(ImageIcon imageIcon) {
        return this.frame.getSize();
    }

    public void launchExamplePanel(ConcurrentExample concurrentExample) {
        this.clearFrame();
        this.examplePanel = concurrentExample;
        this.imagePanel = null;
        this.frame.setVisible(true);
        if (concurrentExample != null) {
            this.container.add(concurrentExample);
            concurrentExample.launchExample();
            if (concurrentExample.getSlideNumber() != -1) {
                ConcurrentSlideShow.setSlideShowIndex(concurrentExample.getSlideNumber());
            }
            concurrentExample.setAnimationCanvasVisible(true);
        } else {
            this.showSplashes();
        }
    }

    public void launchImagePanel(ImagePanel imagePanel) {
        this.clearFrame();
        this.examplePanel = null;
        this.imagePanel = imagePanel;
        imagePanel.setVisible(true);
        this.container.add(imagePanel);
        this.container.validate();
        this.container.doLayout();
    }

    private void showSplashes() {
        if (this.flip) {
            this.showSplash();
        } else {
            this.showReferences();
        }
        this.flip = !this.flip;
    }

    private void clearFrame() {
        if (this.backgroundImage != null) {
            this.container.remove(this.backgroundImage);
            this.backgroundImage = null;
        }
        if (this.examplePanel != null) {
            this.container.remove(this.examplePanel);
            this.backgroundImage = null;
        }
        if (this.imagePanel != null) {
            this.container.remove(this.imagePanel);
            this.imagePanel = null;
        }
        if (((Container)this.frame.getGlassPane()).getComponentCount() > 0) {
            ((Container)this.frame.getGlassPane()).remove(0);
        }
    }

    private void initializeMenuItem(String string, ConcurrentExample ... concurrentExampleArray) {
        Menu menu = new Menu(string + " ");
        this.menuBar.add(menu);
        if (concurrentExampleArray != null && concurrentExampleArray.length > 0) {
            for (ConcurrentExample concurrentExample : concurrentExampleArray) {
                ConcurrentSlideShow.setSlideShowSlides(this.slideShowSlides);
                ExampleActionListener exampleActionListener = new ExampleActionListener(concurrentExample);
                if (concurrentExample.getSlideNumber() != -1) {
                    this.slideShowSlides.put(concurrentExample.getSlideNumber(), exampleActionListener);
                }
                MenuItem menuItem = new MenuItem(concurrentExample.getTitle());
                menuItem.addActionListener(exampleActionListener);
                menu.add(menuItem);
            }
        }
    }

    private void initializeReferencesMenuItem() {
        Menu menu = new Menu(REFERENCES);
        this.menuBar.add(menu);
        MenuItem menuItem = new MenuItem(REFERENCES);
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConcurrentExampleLauncher.this.launchExamplePanel(null);
                ConcurrentExampleLauncher.this.container.repaint(50L);
            }
        });
    }

    private void initializeHelpMenuItem() {
        Menu menu = new Menu(HELP);
        this.menuBar.add(menu);
        MenuItem menuItem = new MenuItem("About");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.info(System.getProperties().toString());
                ConcurrentExampleLauncher.this.infoDialog();
                ConcurrentExampleLauncher.this.container.repaint(50L);
            }
        });
    }

    private void initializeImageSlide(String string, int n, boolean bl, Alignment alignment) {
        this.initializeImageSlide(string, null, n, bl, alignment);
    }

    private void initializeImageSlide(String string, String string2, int n, boolean bl, Alignment alignment) {
        if (n != -1) {
            ImagePanelActionListener imagePanelActionListener = new ImagePanelActionListener(string, string2, bl, alignment);
            this.slideShowSlides.put(n, imagePanelActionListener);
        }
    }

    private void infoDialog() {
        String string = "Java VM version:" + System.getProperty("java.vm.version") + '\n' + System.getProperty("sun.os.patch.level") + '\n' + "Java version:" + System.getProperty("java.version") + '\n' + "Runtime version:" + System.getProperty("java.runtime.version") + '\n' + "CPU:" + System.getProperty("sun.cpu.isalist") + '\n';
        JOptionPane.showInternalMessageDialog(this.frame.getContentPane(), string, "System info", 1);
    }

    public static ConcurrentExampleLauncher getInstance() {
        return instance;
    }

    static {
        delta = 0;
        keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                logger.log(Level.INFO, "ConcurrentExampleLauncher.keyPressed " + keyEvent);
                if (keyEvent.getKeyCode() == 34) {
                    ConcurrentSlideShow.nextSlide();
                } else if (keyEvent.getKeyCode() == 33) {
                    ConcurrentSlideShow.previousSlide();
                }
            }
        };
    }
}

