Glossary of Internet Terms          DD                TEXtREAd            @o    @o  @o   @o  0@o  @@o  P@o  `@o  p@o  @o	  @o
  @o             Glossary of Internet Terminology 
AportisDOC Conversion by Jason Perlow 
New York Palm Pilot Users Group 
http://www.nypalm.org 
 
The URL of this document is:  which is where you can look for the latest, most complete version.  
 
 
ADN 
(Advanced Digital Network) -- Usually refers to a 56Kbps leased-line.  
 
 
ADSL 
(Asymmetric Digital Subscriber Line) -- A method for moving data over regular phone lines. An ADSL circuit is much faster than a regular phone connection, and the wires coming into the subscriber's premises are the same (copper) wires used for regular phone service. An ADSL circuit must be configured to connect two specific locations, similar to a leased line.

 
A commonly discussed configuration of ADSL would allow a subscriber to receive data (download) at speeds of up to 1.544 megabits (not megabytes) per second, and to send (upload) data at speeds of 128 kilobits per second. Thus the "Asymmetric" part of the acronym.  
 
Another commonly discussed configuration would be symmetrical: 384 Kilobits per second in both directions. In theory ADSL allows download speeds of up to 9 megabits per second and upload speeds of up to 640 kilobits per second.

 
ADSL is often discussed as an alternative to ISDN, allowing higher speeds in cases where the connection is always to the same place.  
See Also: bit , bps , ISDN  
 
 
Anonymous FTP 
See: FTP  
 
 
Applet 
A small Java program that can be embedded in an HTML page. Applets differ from full-fledged Java applications in that they are not allowed to access certain resources on the local computer, such as files and serial devices (modems, printers, etc.), and are prohibited from communicating with most other computers across a network. The current rule is that an applet can only make an Internet connection to the computer from which the applet was sent.  
See Also: HTML , Java  
 
 
Archie 
A tool (software) for finding files stored on anonymous FTP sites. You need to know the exact file name or a substring of it.  
 
 
ARPANet 
(Advanced Research Projects Agency Network) -- The precursor to the Internet. Developed in the late 60's and early 70's by the US Department of Defense as an experiment in wide-area-networking that would survive a nuclear war.  
See Also: Internet  
 
 
ASCII 
(American Standard Code for Information Interchange) -- This is the de facto world-wide standard for the code numbers used by computers to represent all the upper and lower-case Latin letters, numbers, punctuation, etc. There are 128 standard ASCII codes each of which can be represented by a 7 digit binary number: 0000000 through 1111111.  
 
 
Backbone 
A high-speed line or series of connections that forms a major pathway within a network. The term is relative as a backbone in a small network will likely be much smaller than many non-backbone lines in a large network.  
See Also: Network  
 
 
Bandwidth 
How much stuff you can send through a connection. Usually measured in bits-per-second. A full page of English text is about 16,000 bits. A fast modem can move about 15,000 bits in one second. Full-motion full-screen video would require roughly 10,000,000 bits-per-second, depending on compression.  
See Also: Bps , Bit , T-1  
 
 
Baud 
In common usage the baud rate of a modem is how many bits it can send or receive per second. Technically, baud is the number of times per second that the carrier signal shifts value - for example a 1200 bit-per-second modem actually runs at 300 baud, but it moves 4 bits per baud (4 x 300 = 1200 bits per second).  
See Also: Bit , Modem  
 
 
BBS 
(Bulletin Board System) -- A computerized meeting and announcement system that allows people to carry on discussions, upload and download files, and make announcements without the people being connected to the computer at the same time. There are many thousands (millions?) of BBS's around the world, most are very small, running on a single IBM clone PC with 1 or 2 phone lines. Some are very large and the line between a BBS and a system like CompuServe gets crossed at some point, but it is not clearly drawn.  
 
 
Binhex 
(BINary HEXadecimal) -- A method for converting non-text files (non-ASCII) into ASCII. This is needed because Internet e-mail can only handle ASCII.  
See Also: ASCII , MIME , UUENCODE  
 
 
Bit 
(Binary DigIT) -- A single digit number in base-2, in other words, either a 1 or a zero. The smallest unit of computerized data. Bandwidth is usually measured in bits-per-second.  
See Also: Bandwidth , Bps , Byte , Kilobyte , Megabyte  
 
 
BITNET 
(Because It's Time NETwork (or Because It's There NETwork)) -- A network of educational sites separate from the Internet, but e-mail is freely exchanged between BITNET and the Internet. Listservs, the most popular form of e-mail discussion groups, originated on BITNET. BITNET machines are usually mainframes running the VMS operating system, and the network is probably the only international network that is shrinking.  
 
 
Bps 
(Bits-Per-Second) -- A measurement of how fast data is moved from one place to another. A 28.8 modem can move 28,800 bits per second.  
See Also: Bandwidth , Bit  
 
 
Browser 
A Client program (software) that is used to look at various kinds of Internet resources.  
See Also: Client , URL , WWW , Netscape , Mosaic , Home Page (or Homepage)  
 
 
BTW 
(By The Way) -- A shorthand appended to a comment written in an online forum.  
See Also: IMHO , TTFN  
 
 
Byte 
A set of Bits that represent a single character. Usually there are 8 Bits in a Byte, sometimes more, depending on how the measurement is being made.  
See Also: Bit  
 
 
Certificate Authority 
An issuer of Security Certificates used in SSL connections.  
See Also: Security Certificate , SSL  
 
 
CGI 
(Common Gateway Interface) -- A set of rules that describe how a Web Server communicates with another piece of software on the same machine, and how the other piece of software (the "CGI program") talks to the web server. Any piece of software can be a CGI program if it handles input and output according to the CGI standard.

 
Usually a CGI program is a small program that takes data from a web server and does something with it, like putting the content of a form into an e-mail message, or turning the data into a database query.

 
You can often see that a CGI program is being used by seeing "cgi-bin" in a URL, but not always.  
See Also: cgi-bin , Web  
 
 
cgi-bin 
The most common name of a directory on a web server in which CGI programs are stored.

The "bin" part of "cgi-bin" is a shorthand version of "binary", because once upon a time, most programs were refered to as "binaries". In real life, most programs found in cgi-bin directories are text files -- scripts that are executed by binaries located elsewhere on the same machine.  
See Also: CGI  
 
 
Client 
A software program that is used to contact and obtain data from a Server software program on another computer, often across a great distance. Each Client program is designed to work with one or more specific kinds of Server programs, and each Server requires a specific kind of Client. A Web Browser is a specific kind of Client.  
See Also: Browser , Server  
 
 
co-location 
Most often used to refer to having a server that belongs to one person or group physically located on an Internet-connected network that belongs to another person or group. Usually this is done because the server owner wants their machine to be on a high-speed Internet connection and/or they do not want the security risks of having the server on thier own network.  
See Also: Internet , Server , Network  
 
 
Cookie 
The most common meaning of "Cookie" on the Internet refers to a piece of information sent by a Web Server to a Web Browser that the Browser software is expected to save and to send back to the Server whenever the browser makes additional requests from the Server.

 
Depending on the type of Cookie used, and the Browser's settings, the Browser may accept or not accept the Cookie, and may save the Cookie for either a short time or a long time.

 
Cookies might contain information such as login or registration information, online "shopping cart" information, user preferences, etc.

 
When a Server receives a request from a Browser that includes a Cookie, the Server is able to use the information stored in the Cookie. For example, the Server might customize what is sent back to the user, or keep a log of particular user's requests.

 
Cookies are usually set to expire after a predetermined amount of time and are usually saved in memory until the Browser software is closed down, at which time they may be saved to disk if their "expire time" has not been reached.

 
Cookies do not read your hard drive and send your life story to the CIA, but they can be used to gather more information about a user than would be possible without them.  
See Also: Browser , Server  
 
 
Cyberpunk 
Cyberpunk was originally a cultural sub-genre of science fiction taking place in a not-so-distant, dystopian, over-industrialized society. The term grew out of the work of William Gibson and Bruce Sterling and has evolved into a cultural label encompassing many different kinds of human, machine, and punk attitudes. It includes clothing and lifestyle choices as well.  
See Also: Cyberspace  
 
 
Cyberspace 
Term originated by author William Gibson in his novel Neuromancer the word Cyberspace is currently used to describe the whole range of information resources available through computer networks.  
 
 
Digerati 
The digital version of literati, it is a reference to a vague cloud of people seen to be knowledgeable, hip, or otherwise in-the-know in regards to the digital revolution.  
 
 
Domain Name 
The unique name that identifies an Internet site. Domain Names always have 2 or more parts, separated by dots. The part on the left is the most specific, and the part on the right is the most general. A given machine may have more than one Domain Name but a given Domain Name points to only one machine. For example, the domain names: 
 
matisse.net 
mail.matisse.net 
workshop.matisse.net 
 
can all refer to the same machine, but each domain name can refer to no more than one machine.

 
Usually, all of the machines on a given Network will have the same thing as the right-hand portion of their Domain Names (matisse.net in the examples above). It is also possible for a Domain Name to exist but not be connected to an actual machine. This is often done so that a group or business can have an Internet e-mail address without having to establish a real Internet site. In these cases, some real Internet machine must handle the mail on behalf of the listed Domain Name.  
See Also: IP Number  
 
 
E-mail 
(Electronic Mail) -- Messages, usually text, sent from one person to another via computer. E-mail can also be sent automatically to a large number of addresses (Mailing List).  
See Also: Listserv , Maillist  
 
 
Ethernet 
A very common method of networking computers in a LAN. Ethernet will handle about 10,000,000 bits-per-second and can be used with almost any kind of computer.  
See Also: Bandwidth , LAN  
 
 
FAQ 
(Frequently Asked Questions) -- FAQs are documents that list and answer the most common questions on a particular subject. There are hundreds of FAQs on subjects as diverse as Pet Grooming and Cryptography. FAQs are usually written by people who have tired of answering the same question over and over.  
 
 
FDDI 
(Fiber Distributed Data Interface) -- A standard for transmitting data on optical fiber cables at a rate of around 100,000,000 bits-per-second (10 times as fast as Ethernet, about twice as fast as T-3).  
See Also: Bandwidth , Ethernet , T-1 , T-3  
 
 
Finger 
An Internet software tool for locating people on other Internet sites. Finger is also sometimes used to give access to non-personal information, but the most common use is to see if a person has an account at a particular Internet site. Many sites do not allow incoming Finger requests, but many do.  
 
 
Fire Wall 
A combination of hardware and software that separates a LAN into two or more parts for security purposes.  
See Also: Network , LAN  
 
 
Flame 
Originally, flame meant to carry forth in a passionate manner in the spirit of honorable debate. Flames most often involved the use of flowery language and flaming well was an art form. More recently flame has come to refer to any kind of derogatory comment no matter how witless or crude.  
See Also: Flame War  
 
 
Flame War 
When an online discussion degenerates into a series of personal attacks against the debators, rather than discussion of their positions. A heated exchange.  
See Also: Flame  
 
 
FTP 
(File Transfer Protocol) -- A very common method of moving files between two Internet sites. FTP is a special way to login to another Internet site for the purposes of retrieving and/or sending files. There are many Internet sites that have established publicly accessible repositories of material that can be obtained using FTP, by logging in using the account name anonymous, thus these sites are called anonymous ftp servers.  
 
 
Gateway 
The technical meaning is a hardware or software set-up that translates between two dissimilar protocols, for example Prodigy has a gateway that translates between its internal, proprietary e-mail format and Internet e-mail format. Another, sloppier meaning of gateway is to describe any mechanism for providing access to another system, e.g. AOL might be called a gateway to the Internet.  
 
 
GIF 
(Graphic Interchange Format) -- A common format for image files, especially suitable for images containing large areas of the same color. GIF format files of simple images are often smaller than the same file would be if stored in JPEG format, but GIF format does not store photographic images as well as JPEG.  
See Also: JPEG  
 
 
Gigabyte 
1000 or 1024 Megabytes, depending on who is measuring.  
See Also: Byte , Megabyte  
 
 
Gopher 
A widely successful method of making menus of material available over the Internet. Gopher is a Client and Server style program, which requires that the user have a Gopher Client program. Although Gopher spread rapidly across the globe in only a couple of years, it has been largely supplanted by Hypertext, also known as WWW (World Wide Web). There are still thousands of Gopher Servers on the Internet and we can expect they will remain for a while.  
See Also: Client , Server , WWW , Hypertext  
 
 
hit 
As used in reference to the World Wide Web, "hit" means a single request from a web browser for a single item from a web server; thus in order for a web browser to display a page that contains 3 graphics, 4 "hits" would occur at the server: 1 for the HTML page, and one for each of the 3 graphics.

 
"hits" are often used as a very rough measure of load on a server, e.g. "Our server has been getting 300,000 hits per month." Because each "hit" can represent anything from a request for a tiny document (or even a request for a missing document) all the way to a request that requires some significant extra processing (such as a complex search request), the actual load on a machine from 1 hit is almost impossible to define.  
 
 
Home Page (or Homepage) 
Several meanings. Originally, the web page that your browser is set to use when it starts up. The more common meaning refers to the main web page for a business, organization, person or simply the main page out of a collection of web pages, e.g. "Check out so-and-so's new Home Page."

 
Another sloppier use of the term refers to practically any web page as a "homepage," e.g. "That web site has 65 homepages and none of them are interesting."  
See Also: Browser , Web  
 
 
Host 
Any computer on a network that is a repository for services available to other computers on the network. It is quite common to have one host machine provide several services, such as WWW and USENET.  
See Also: Node , Network  
 
 
HTML 
(HyperText Markup Language) -- The coding language used to create Hypertext documents for use on the World Wide Web. HTML looks a lot like old-fashioned typesetting code, where you surround a block of text with codes that indicate how it should appear, additionally, in HTML you can specify that a block of text, or a word, is linked to another file on the Internet. HTML files are meant to be viewed using a World Wide Web Client Program, such as Netscape or Mosaic.  
See Also: Client , Server , WWW  
 
 
HTTP 
(HyperText Transport Protocol) -- The protocol for moving hypertext files across the Internet. Requires a HTTP client program on one end, and an HTTP server program on the other end. HTTP is the most important protocol used in the World Wide Web (WWW).  
See Also: Client , Server , WWW  
 
 
Hypertext 
Generally, any text that contains links to other documents - words or phrases in the document that can be chosen by a reader and which cause another document to be retrieved and displayed.  
 
 
IMHO 
(In My Humble Opinion) -- A shorthand appended to a comment written in an online forum, IMHO indicates that the writer is aware that they are expressing a debatable view, probably on a subject already under discussion. One of may such shorthands in common use online, especially in discussion forums.  
See Also: TTFN , BTW  
 
 
Internet 
(Upper case I) The vast collection of inter-connected networks that all use the TCP/IP protocols and that evolved from the ARPANET of the late 60's and early 70's. The Internet now (July 1995) connects roughly 60,000 independent networks into a vast global internet.  
See Also: internet  
 
 
internet 
(Lower case i) Any time you connect 2 or more networks together, you have an internet - as in inter-national or inter-state.  
See Also: Internet , Network  
 
 
Intranet 
A private network inside a company or organization that uses the same kinds of software that you would find on the public Internet, but that is only for internal use.

 
As the Internet has become more popular many of the tools used on the Internet are being used in private networks, for example, many companies have web servers that are available only to employees.

 
Note that an Intranet may not actually be an internet -- it may simply be a network.  
See Also: internet , Internet , Network  
 
 
IP Number 
(Internet Protocol Number) -- Sometimes called a dotted quad. A unique number consisting of 4 parts separated by dots, e.g.

 
165.113.245.2 
 
Every machine that is on the Internet has a unique IP number - if a machine does not have an IP number, it is not really on the Internet. Most machines also have one or more Domain Names that are easier for people to remember.  
See Also: Domain Name , Internet , TCP/IP  
 
 
IRC 
(Internet Relay Chat) -- Basically a huge multi-user live chat facility. There are a number of major IRC servers around the world which are linked to each other. Anyone can create a channel and anything that anyone types in a given channel is seen by all others in the channel. Private channels can (and are) created for multi-person conference calls.  
 
 
ISDN 
(Integrated Services Digital Network) -- Basically a way to move more data over existing regular phone lines. ISDN is rapidly becoming available to much of the USA and in most markets it is priced very comparably to standard analog phone circuits. It can provide speeds of roughly 128,000 bits-per-second over regular phone lines. In practice, most people will be limited to 56,000 or 64,000 bits-per-second.  
 
 
ISP 
(Internet Service Provider) -- An institution that provides access to the Internet in some form, usually for money.  
See Also: Internet  
 
 
Java 
Java is a network-oriented programming language invented by Sun Microsystems that is specifically designed for writing programs that can be safely downloaded to your computer through the Internet and immediately run without fear of viruses or other harm to your computer or files. Using small Java programs (called "Applets"), Web pages can include functions such as animations, calculators, and other fancy tricks.

 
We can expect to see a huge variety of features added to the Web using Java, since you can write a Java program to do almost anything a regular computer program can do, and then include that Java program in a Web page.  
See Also: Applet  
 
 
JDK 
(Java Development Kit) -- A software development package from Sun Microsystems that implements the basic set of tools needed to write, test and debug Java applications and applets 
 
See Also: Applet , Java  
 
 
JPEG 
(Joint Photographic Experts Group) -- JPEG is most commonly mentioned as a format for image files. JPEG format is preferred to the GIF format for photographic images as opposed to line art or simple logo art.  
See Also: GIF  
 
 
Kilobyte 
A thousand bytes. Actually, usually 1024 (2^10) bytes.  
See Also: Byte , Bit  
 
 
LAN 
(Local Area Network) -- A computer network limited to the immediate area, usually the same building or floor of a building.  
See Also: Ethernet  
 
 
Leased-line 
Refers to a phone line that is rented for exclusive 24-hour, 7 -days-a-week use from your location to another location. The highest speed data connections require a leased line.  
See Also: T-1 , T-3  
 
 
Listserv 
The most common kind of maillist, Listservs originated on BITNET but they are now common on the Internet.  
See Also: BITNET , E-mail , Maillist  
 
 
Login 
Noun or a verb. Noun: The account name used to gain access to a computer system. Not a secret (contrast with Password).

Verb: The act of entering into a computer system, e.g. Login to the WELL and then go to the GBN conference.  
See Also: Password  
 
 
Maillist  
(or Mailing List) A (usually automated) system that allows people to send e-mail to one address, whereupon their message is copied and sent to all of the other subscribers to the maillist. In this way, people who have many different kinds of e-mail access can participate in discussions together.  
 
 
Megabyte 
A million bytes. Actually, technically, 1024 kilobytes.  
See Also: Byte , Bit , Kilobyte  
 
 
MIME 
(Multipurpose Internet Mail Extensions) -- The standard for attaching non-text files to standard Internet mail messages. Non-text files include graphics, spreadsheets, formatted word-processor documents, sound files, etc.

 
An email program is said to be MIME Compliant if it can both send and receive files using the MIME standard.

 
When non-text files are sent using the MIME standard they are converted (encoded) into text - although the resulting text is not really readable.

 
Generally speaking the MIME standard is a way of specifying both the type of file being sent (e.g. a QuicktimeT video file), and the method that should be used to turn it back into its original form.

 
Besides email software, the MIME standard is also universally used by Web Servers to identify the files they are sending to Web Clients, in this way new file formats can be accommodated simply by updating the Browsers' list of pairs of MIME-Types and appropriate software for handling each type.  
See Also: Browser , Client , Server , Binhex , UUENCODE  
 
 
Mirror 
Generally speaking, "to mirror" is to maintain an exact copy of something. Probably the most common use of the term on the Internet refers to "mirror sites" which are web sites, or FTP sites that maintain exact copies of material originated at another location, usually in order to provide more widespread access to the resource.

 
Another common use of the term "mirror" refers to an arrangement where information is written to more than one hard disk simultaneously, so that if one disk fails, the computer keeps on working without losing anything.  
See Also: FTP , Web  
 
 
Modem 
(MOdulator, DEModulator) -- A device that you connect to your computer and to a phone line, that allows the computer to talk to other computers through the phone system. Basically, modems do for computers what a telephone does for humans.  
 
 
MOO 
(Mud, Object Oriented) -- One of several kinds of multi-user role-playing environments, so far only text-based.  
See Also: MUD , MUSE  
 
 
Mosaic 
The first WWW browser that was available for the Macintosh, Windows, and UNIX all with the same interface. Mosaic really started the popularity of the Web. The source-code to Mosaic has been licensed by several companies and there are several other pieces of software as good or better than Mosaic, most notably, Netscape.  
See Also: Browser , Client , WWW  
 
 
MUD 
(Multi-User Dungeon or Dimension) -- A (usually text-based) multi-user simulation environment. Some are purely for fun and flirting, others are used for serious software development, or education purposes and all that lies in between. A significant feature of most MUDs is that users can create things that stay after they leave and which other users can interact with in their absence, thus allowing a world to be built gradually and collectively.  
See Also: MOO , MUSE  
 
 
MUSE 
(Multi-User Simulated Environment) -- One kind of MUD - usually with little or no violence.  
See Also: MOO , MUD  
 
 
Netiquette 
The etiquette on the Internet.  
See Also: Internet  
 
 
Netizen 
Derived from the term citizen, referring to a citizen of the Internet, or someone who uses networked resources. The term connotes civic responsibility and participation.  
See Also: Internet  
 
 
Netscape 
A WWW Browser and the name of a company. The Netscape (tm) browser was originally based on the Mosaic program developed at the National Center for Supercomputing Applications (NCSA).  
 
Netscape has grown in features rapidly and is widely recognized as the best and most popular web browser. Netscape corporation also produces web server software.

 
Netscape provided major improvements in speed and interface over other browsers, and has also engendered debate by creating new elements for the HTML language used by Web pages -- but the Netscape extensions to HTML are not universally supported.

 
The main author of Netscape, Mark Andreessen, was hired away from the NCSA by Jim Clark, and they founded a company called Mosaic Communications and soon changed the name to Netscape Communications Corporation.

 
 
See Also: Browser , Mosaic , Server , WWW  
 
 
Network 
Any time you connect 2 or more computers together so that they can share resources, you have a computer network. Connect 2 or more networks together and you have an internet.  
See Also: internet , Internet , Intranet  
 
 
Newsgroup 
The name for discussion groups on USENET.  
See Also: USENET  
 
 
NIC 
(Networked Information Center) -- Generally, any office that handles information for a network. The most famous of these on the Internet is the InterNIC, which is where new domain names are registered.

Another definition: NIC also refers to Network Interface Card which plugs into a computer and 
adapts the network interface to the appropriate standard. ISA, PCI, and PCMCIA cards are all examples of NICs.

 
 
 
NNTP 
(Network News Transport Protocol) -- The protocol used by client and server software to carry USENET postings back and forth over a TCP/IP network. If you are using any of the more common software such as Netscape, Nuntius, Internet Explorer, etc. to participate in newsgroups then you are benefiting from an NNTP connection.  
See Also: Newsgroup , TCP/IP , USENET  
 
 
Node 
Any single computer connected to a network.  
See Also: Network , Internet , internet  
 
 
Packet Switching 
The method used to move data around on the Internet. In packet switching, all the data coming out of a machine is broken up into chunks, each chunk has the address of where it came from and where it is going. This enables chunks of data from many different sources to co-mingle on the same lines, and be sorted and directed to different routes by special machines along the way. This way many people can use the same lines at the same time.  
 
 
Password 
A code used to gain access to a locked system. Good passwords contain letters and non-letters and are not simple combinations such as virtue7. A good password might be: 
 
Hot$1-6  
See Also: Login  
 
 
Plug-in 
A (usually small) piece of software that adds features to a larger piece of software. Common examples are plug-ins for the Netscaper browser and web server. Adobe Photoshopr also uses plug-ins.

 
The idea behind plug-in's is that a small piece of software is loaded into memory by the larger program, adding a new feature, and that users need only install the few plug-ins that they need, out of a much larger pool of possibilities. Plug-ins are usually created by people other than the publishers of the software the plug-in works with.  
 
 
POP 
(Point of Presence, also Post Office Protocol) -- Two commonly used meanings: Point of Presence and Post Office Protocol. A Point of Presence usually means a city or location where a network can be connected to, often with dial up phone lines. So if an Internet company says they will soon have a POP in Belgrade, it means that they will soon have a local phone number in Belgrade and/or a place where leased lines can connect to their network. A second meaning, Post Office Protocol refers to the way e-mail software such as Eudora gets mail from a mail server. When you obtain a SLIP, PPP, or shell account you almost always get a POP account with it, and it is this POP account that you tell your e-mail software to use to get your mail.  
See Also: SLIP , PPP  
 
 
Port 
3 meanings. First and most generally, a place where information goes into or out of a computer, or both. E.g. the serial port on a personal computer is where a modem would be connected.  
 
On the Internet port often refers to a number that is part of a URL, appearing after a colon (:) right after the domain name. Every service on an Internet server listens on a particular port number on that server. Most services have standard port numbers, e.g. Web servers normally listen on port 80. Services can also listen on non-standard ports, in which case the port number must be specified in a URL when accessing the server, so you might see a URL of the form: 
 
gopher://peg.cwis.uci.edu:7000/ 
 
shows a gopher server running on a non-standard port (the standard gopher port is 70).

Finally, port also refers to translating a piece of software to bring it from one type of computer system to another, e.g. to translate a Windows program so that is will run on a Macintosh.  
See Also: Domain Name , Server , URL  
 
 
Posting 
A single message entered into a network communications system.

 
E.g. A single message posted to a newsgroup or message board.  
See Also: Newsgroup  
 
 
PPP 
(Point to Point Protocol) -- Most well known as a protocol that allows a computer to use a regular telephone line and a modem to make TCP/IP connections and thus be really and truly on the Internet.  
See Also: IP Number , Internet , SLIP , TCP/IP  
 
 
PSTN 
(Public Switched Telephone Network) -- The regular old-fashioned telephone system.  
 
 
RFC 
(Request For Comments) -- The name of the result and the process for creating a standard on the Internet. New standards are proposed and published on line, as a Request For Comments. The Internet Engineering Task Force is a consensus-building body that facilitates discussion, and eventually a new standard is established, but the reference number/name for the standard retains the acronym RFC, e.g. the official standard for e-mail is RFC 822.  
 
 
Router 
A special-purpose computer (or software package) that handles the connection between 2 or more networks. Routers spend all their time looking at the destination addresses of the packets passing through them and deciding which route to send them on.  
See Also: Network , Packet Switching  
 
 
Security Certificate 
A chunk of information (often stored as a text file) that is used by the SSL protocol to establish a secure connection.

 
Security Certificates contain information about who it belongs to, who it was issued by, a unique serial number or other unique identification, valid dates, and an encrypted "fingerprint" that can be used to verify the contents of the certificate.

 
In order for an SSL connection to be created both sides must have a valid Security Certificate.  
See Also: Certificate Authority , SSL  
 
 
Server 
A computer, or a software package, that provides a specific kind of service to client software running on other computers. The term can refer to a particular piece of software, such as a WWW server, or to the machine on which the software is running, e.g.Our mail server is down today, that's why e-mail isn't getting out. A single server machine could have several different server software packages running on it, thus providing many different servers to clients on the network.  
See Also: Client , Network  
 
 
SLIP 
(Serial Line Internet Protocol) -- A standard for using a regular telephone line (a serial line) and a modem to connect a computer as a real Internet site. SLIP is gradually being replaced by PPP.  
See Also: Internet , PPP  
 
 
SMDS 
(Switched Multimegabit Data Service) -- A new standard for very high-speed data transfer.  
 
 
SMTP 
(Simple Mail Transport Protocol) -- The main protocol used to send electronic mail on the Internet.

 
SMTP consists of a set of rules for how a program sending mail and a program receiving mail should interact.

 
Almost all Internet email is sent and received by clients and servers using SMTP, thus if one wanted to set up an email server on the Internet one would look for email server software that supports SMTP.  
See Also: Client , Server  
 
 
SNMP 
(Simple Network Management Protocol) -- A set of standards for communication with devices connected to a TCP/IP network. Examples of these devices include routers, hubs, and switches.

 
A device is said to be "SNMP compatible" if it can be monitored and/or controlled using SNMP messages. SNMP messages are known as "PDU's" - Protocol Data Units.

 
Devices that are SNMP compatible contain SNMP "agent" software to receive, send, and act upon SNMP messages.

 
Software for managing devices via SNMP are available for every kind of commonly used computer and are often bundled along with the device they are designed to manage. Some SNMP software is designed to handle a wide variety of devices.  
See Also: Network , Router  
 
 
Spam (or Spamming) 
An inappropriate attempt to use a mailing list, or USENET or other networked communications facility as if it was a broadcast medium (which it is not) by sending the same message to a large number of people who didn't ask for it. The term probably comes from a famous Monty Python skit which featured the word spam repeated over and over. The term may also have come from someone's low opinion of the food product with the same name, which is generally perceived as a generic content-free waste of resources. (Spam is a registered trademark of Hormel Corporation, for its processed meat product.) 
 
E.g. Mary spammed 50 USENET groups by posting the same message to each.  
See Also: Maillist , USENET  
 
 
SQL 
(Structured Query Language) -- A specialized programming language for sending queries to databases. Most industrial-strength and many smaller database applications can be addressed using SQL. Each specific application will have its own version of SQL implementing features unique to that application, but all SQL-capable databases support a common subset of SQL.  
 
 
SSL 
(Secure Sockets Layer) -- A protocol designed by Netscape Communications to enable encrypted, authenticated communications across the Internet.

 
SSL used mostly (but not exclusively) in communications between web browsers and web servers. URL's that begin with "https" indicate that an SSL connection will be used.

 
SSL provides 3 important things: Privacy, Authentication, and Message Integrity.

 
In an SSL connection each side of the connection must have a Security Certificate, which each side's software sends to the other. Each side then encrypts what it sends using information from both its own and the other side's Certificate, ensuring that only the intended recipient can de-crypt it, and that the other side can be sure the data came from the place it claims to have come from, and that the message has not been tampered with.  
See Also: Browser , Server , Security Certificate , URL  
 
 
Sysop 
(System Operator) -- Anyone responsible for the physical operations of a computer system or network resource. A System Administrator decides how often backups and maintenance should be performed and the System Operator performs those tasks.  
 
 
T-1 
A leased-line connection capable of carrying data at 1,544,000 bits-per-second. At maximum theoretical capacity, a T-1 line could move a megabyte in less than 10 seconds. That is still not fast enough for full-screen, full-motion video, for which you need at least 10,000,000 bits-per-second. T-1 is the fastest speed commonly used to connect networks to the Internet.  
See Also: Bandwidth , Bit , Byte , Ethernet , T-3  
 
 
T-3 
A leased-line connection capable of carrying data at 44,736,000 bits-per-second. This is more than enough to do full-screen, full-motion video.  
See Also: Bandwidth , Bit , Byte , Ethernet , T-1  
 
 
TCP/IP 
(Transmission Control Protocol/Internet Protocol) -- This is the suite of protocols that defines the Internet. Originally designed for the UNIX operating system, TCP/IP software is now available for every major kind of computer operating system. To be truly on the Internet, your computer must have TCP/IP software.  
See Also: IP Number , Internet , UNIX  
 
 
Telnet 
The command and program used to login from one Internet site to another. The telnet command/program gets you to the login: prompt of another host.  
 
 
Terabyte 
1000 gigabytes.  
See Also: Byte , Kilobyte  
 
 
Terminal 
A device that allows you to send commands to a computer somewhere else. At a minimum, this usually means a keyboard and a display screen and some simple circuitry. Usually you will use terminal software in a personal computer - the software pretends to be (emulates) a physical terminal and allows you to type commands to a computer somewhere else.  
 
 
Terminal Server 
A special purpose computer that has places to plug in many modems on one side, and a connection to a LAN or host machine on the other side. Thus the terminal server does the work of answering the calls and passes the connections on to the appropriate node. Most terminal servers can provide PPP or SLIP services if connected to the Internet.  
See Also: LAN , Modem , Host , Node , PPP , SLIP  
 
 
UDP 
(User Datagram Protocol) -- One of the protocols for data transfer that is part of the TCP/IP suite of protocols. UDP is a "stateless" protocol in that UDP makes no provision for acknowledgement of packets received.  
See Also: TCP/IP  
 
 
UNIX 
A computer operating system (the basic software running on a computer, underneath things like word processors and spreadsheets). UNIX is designed to be used by many people at the same time (it is multi-user) and has TCP/IP built-in. It is the most common operating system for servers on the Internet.  
 
 
URL 
(Uniform Resource Locator) -- The standard way to give the address of any resource on the Internet that is part of the World Wide Web (WWW). A URL looks like this: 
 
http://www.matisse.net/seminars.html 
or telnet://well.sf.ca.us 
or news:new.newusers.questions 
etc.

 
The most common way to use a URL is to enter into a WWW browser program, such as Netscape, or Lynx.  
See Also: Browser , WWW  
 
 
USENET 
A world-wide system of discussion groups, with comments passed among hundreds of thousands of machines. Not all USENET machines are on the Internet, maybe half. USENET is completely decentralized, with over 10,000 discussion areas, called newsgroups.  
See Also: Newsgroup  
 
 
UUENCODE 
(Unix to Unix Encoding) -- A method for converting files from Binary to ASCII (text) so that they can be sent across the Internet via e-mail.  
See Also: Binhex , MIME  
 
 
Veronica 
(Very Easy Rodent Oriented Net-wide Index to Computerized Archives) -- Developed at the University of Nevada, Veronica is a constantly updated database of the names of almost every menu item on thousands of gopher servers. The Veronica database can be searched from most major gopher menus.  
See Also: Gopher  
 
 
WAIS 
(Wide Area Information Servers) -- A commercial software package that allows the indexing of huge quantities of information, and then making those indices searchable across networks such as the Internet. A prominent feature of WAIS is that the search results are ranked (scored) according to how relevant the hits are, and that subsequent searches can find more stuff like that last batch and thus refine the search process.  
 
 
WAN 
(Wide Area Network) -- Any internet or network that covers an area larger than a single building or campus.  
See Also: Internet , internet , LAN , Network  
 
 
Web 
See: WWW  
 
 
WWW 
(World Wide Web) -- Two meanings - First, loosely used: the whole constellation of resources that can be accessed using Gopher, FTP, HTTP, telnet, USENET, WAIS and some other tools. Second, the universe of hypertext servers (HTTP servers) which are the servers that allow text, graphics, sound files, etc. to be mixed together.  
See Also: Browser , FTP , Gopher , HTTP , Telnet , URL , WAIS 