package examples.chainOfResponsibility.aspectj;



/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

import java.awt.event.ActionEvent; 
import ca.ubc.cs.spl.pattern.library.ChainOfResponsibilityProtocol;

/**
 * Implements an instance of the abstracted ChainOfResponsibility design
 * pattern. Here, the a click on the button triggers an event (request) 
 * that gets passed along the widget hierarchy (button -> panel -> frame). 
 * 
 * In this implementation, the request is handled by the panel if the 
 * CTRL mask is active (i.e., if the CTRL key was pressed while the button 
 * was clicked). If the SHIFT mask is active, the frame handles the request.
 * Otherwise, the request is unhandled.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 *
 */
  
public aspect MyChain extends ChainOfResponsibilityProtocol {

    /**
     * Frame, Panel and Button are all Handlers
     */

	declare parents: Frame       implements Handler;
	declare parents: Panel       implements Handler;
	declare parents: Button      implements Handler; 

    // declare parents: ActionEvent implements Object; // this would be nice! doesn't work on classes where AJ does not control the source
 
    protected pointcut eventTrigger(Handler handler, Object event): call(void Button.doClick(ActionEvent)) && target(handler) && args(event);
 

    public boolean Frame.acceptRequest(Object event) {
        if (event instanceof ActionEvent) {
            ActionEvent ae = (ActionEvent) event;
            return ((ae.getModifiers() & ActionEvent.SHIFT_MASK) != 0 );
        } 
        return false;
    } 
    
    public void Frame.handleRequest(Object event) {
		MyChain.aspectOf().note("Class "+this.getClass().getName() + " is handling the event");
    }
    
    
    public boolean Panel.acceptRequest(Object event) { 
        if (event instanceof ActionEvent) {
            ActionEvent ae = (ActionEvent) event;
            return ((ae.getModifiers() & ActionEvent.CTRL_MASK) != 0 );
        } 
        return false;
    } 
    
    public void Panel.handleRequest(Object event) {
		MyChain.aspectOf().note("Class "+this.getClass().getName() + " is handling the event");
    }


}
