package examples.chainOfResponsibility.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */
 
import javax.swing.JFrame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;   


/** 
 * Represents a regular GUI frame modified to be able to accept requests. 
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 *
 */

public class Frame extends JFrame implements Handler {

    /**
     * the successor in the chain of responsibility
     */

	protected Handler successor;


    /** 
     * Creates a <code>Frame</code> with a given title. The frame
     * does not have a successor and handles request that it receives.
     *
     * @param s the frame title
     */	 
     
 	public Frame(String s) {
		super(s);
		
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
	}  
	
    /** 
     * Implements the method to handle requests as defined by the
     * <code>Handler</code> interface. The request is handled here.
     * 
     * @see Handler
     */	 

	public void handleRequest() {
		System.out.println("Request received by: Frame (handled)");
	}
}

	
	