package examples.chainOfResponsibility.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */
 
import javax.swing.*;

/** 
 * Represents a regular GUI panel modified to be able to accept requests.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 *
 */

public class Panel extends JPanel implements Handler {  

    /**
     * the successor in the chain of responsibility
     */

	protected Handler successor;

    /** 
     * Creates a <code>Panel</code> with a given successor. 
     *
     * @param successor The successor in the chain of responsibility
     */	 
     
 	public Panel(Handler successor) {
		super();
		this.successor = successor;
	}
	

    /** 
     * Implements the method to handle requests as defined by the
     * <code>Handler</code> interface. The request is not handled here.
     * 
     * @see Handler
     */	 

	public void handleRequest() {
		System.out.println("Request received by: Panel (unhandled: forwarded)");
		successor.handleRequest();
	}
}
		