package examples.command.aspectj;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.pattern.
 *
 * Contributor(s):   
 */

import ca.ubc.cs.spl.pattern.library.Command;
import ca.ubc.cs.spl.pattern.library.CommandReceiver;

/**
 * Implements a sample command. This one prints a short message to 
 * <code>System.out</code> whenever it executes. The message is
 * <quote>"ButtonCommand executed"</quote>. 
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.1, 10/29/02
 */

public class ButtonCommand implements Command { 

    private Printer printer = new Printer();
	
    /**
     * Implements a sample command. This one prints a short message to 
     * <code>System.out</code> whenever it executes. The message is
     * <quote>"ButtonCommand executed"</quote>. 
     */              
     
	public void executeCommand(CommandReceiver receiver ) {
		printer.println("ButtonCommand executed");
	}  
}

