package examples.command.aspectj;

import ca.ubc.cs.spl.pattern.library.CommandProtocol;
import ca.ubc.cs.spl.pattern.library.Command;
import ca.ubc.cs.spl.pattern.library.CommandInvoker;
import ca.ubc.cs.spl.pattern.library.CommandReceiver; 
import java.io.PrintStream;

public aspect ButtonCommanding extends CommandProtocol {

    declare parents: Button         implements CommandInvoker;
    declare parents: Printer        implements CommandReceiver;
    declare parents: ButtonCommand  implements Command;     // Unneccessay
    declare parents: ButtonCommand2 implements Command;     // "Making" a class
                                                            // a Command
  
    /**
     * Implements a sample command. This one prints a short message to 
     * <code>System.out</code> whenever it executes. The message is
     * <quote>"ButtonCommand number 2 executed"</quote>. 
     */
 
    public void ButtonCommand2.executeCommand(CommandReceiver receiver) {
        ((Printer) receiver).println("ButtonCommand number 2 executed");
    }  

    /**
     * The join points after which to execute the command.
     * This replaces the normally scattered myCommand.execute() calls. 
     * In this example, a call to <code>Button.clicked()</code> triggers
     * the execution of the command.
     *
     * @param invoker the object invoking the command
     */

    protected pointcut commandTrigger(CommandInvoker invoker): 
        call(void Button.clicked()) && target(invoker);
}

