package examples.composite.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.pattern.
 *
 * Contributor(s):   
 */
 
/**
 * Implements the driver for the composite design pattern example.<p> 
 *
 * Intent: <i>Compose objects into tree structures torepresent part-whole 
 * hierarchies. Composite lets clients treat individual objects and 
 * compositions of objects uniformly.</i><p>
 *
 * Participatng classes are <code>CompositeA</code>s as <i>Composite</i>s,
 * and a <code>LeafB</code> as <i>Leaf</i>. Both implement the 
 * <i>Component</i> interface.<p>
 *
 * This example creates a simple structure as follows: Composite c1 has 
 * three children: l1, c2, and l3. c2 has l2 as a child.
 * Compact notation: c1(l1, c2(l2), l3)
 *
 * <p><i>This is the Java version.</i><p> 
 *
 * Every component and every leaf need to know about the pattern and their
 * in the pattern.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see Component
 * @see CompositeA 
 * @see LeafB
 */
  
public class Main { 

	/**
	 * helper variable to store recursion depth for pretty printing
	 */
	 
	private static int indent = 0;  

    /**
     * Print a number of spaces according to the current recursion depth
     */
     	
	private static void indent() {
		for (int i=0; i<indent; i++)
			System.out.print(" ");
	}

    /** 
     * Pretty-prints a recursive composite structure 
     *
     * @param comp the component denoting the entry point into the structure
     */
     
	private static void printStructure(Component comp) {   
		indent();
		System.out.println("Showing: "+comp);
		indent +=4;                
		for (int i=0; i<comp.getChildCount(); i++) {
			printStructure(comp.getChild(i));
		}
		indent -= 4;
	}


    /**
     * This example creates a simple structure as follows: Composite c1 has 
     * three children: l1, c2, and l3. c2 has l2 as a child.
     * Compact notation: c1(l1, c2(l2), l3)
     */


	public static void main(String[] args) {
		CompositeA composite1 = new CompositeA(1);
		CompositeA composite2 = new CompositeA(2);
		LeafB 	   leaf1      = new LeafB(1);
		LeafB      leaf2      = new LeafB(2);
		LeafB      leaf3      = new LeafB(3); 
		
		composite1.add(leaf1);
		composite1.add(composite2);
		composite2.add(leaf2);
		composite1.add(leaf3); 
		
		printStructure(composite1);
	}
}