package examples.facade.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * Implements the driver for the facade design pattern example.<p> 
 *
 * Intent: <i>Provide a unified interface to a set of interfaces in a 
 * subsystem. Facade defines a higher-level interface that makes the 
 * subsystem easier to use.</i><p>
 *
 * The <i>subsystem</i> consists of three classes that provide low-level
 * string manipulation and output functionality: <code>RegularScreen</code>,
 * <code>Decoration</code>, and <code>StringTransformer</code>. The <i>Facade
 * </i> class <code>OutputFacade</code> procides a higher-level interface
 * to output strings. This class calls methods on that higer-level interface.
 *
 * <p><i>This is the Java version.</i><p>    
 *

 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 */
 
public class Main {
    
    /**
     * Tests the higher-level interface of <code>OutputFacade</code>.
     */  
     
    public static void main(String[] args) {
        OutputFacade facade = new OutputFacade();
    
        System.out.println("Testing Facade..."); 
        
        facade.printNormal("Printing normally works FINE.");
        
        facade.printFancy("This is the test for the FANCY output");
    }

}