package examples.interpreter.aspectj;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * Implements an OR expression for booleans. This is a concrete boolean 
 * expression
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 */

public class OrExp implements BooleanExp {

    /**
     * stores the first part of the OR expression
     */
     
	protected BooleanExp op1 = null;

    /**
     * stores the second part of the OR expression
     */

	protected BooleanExp op2 = null; 

    /** 
     * Creates a new OR expression with the given parts
     *
     * @param op1 the first expression
     * @param op1 the second expression
     */	                    
     
	public OrExp(BooleanExp op1, BooleanExp op2) {
		this.op1 = op1;
		this.op2 = op2;
	}
	
    /**
     * Evaluates this expression in the given <i>Context</i>
     *
     * @param c the context to evaluate the expression in
     * @returns the boolean value of the expression
     */

	public boolean evaluate(Context c) {
		return (op1.evaluate(c) || op2.evaluate(c)); 
	}
}