package examples.observer.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */ 
 
/**
 * Defines methods to attach and detach <i>Observers<i> to/from 
 * <i>Subjects</i>, and the <code>notifyObservers()</code> method.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02 
 *
 * @see Observer
 */
  
public interface Subject {
    
    /**
     * Attaches an observer to this subject.
     * 
     * @param o the observer to attach
     */
     
    public void attach(Observer o);

    /**
     * Detaches an observer from this subject.
     * 
     * @param o the observer to detach
     */
     
    public void detach(Observer o);

    /**
     * Notifies all observers.
     */
   
    public void notifyObservers();
}