package examples.proxy.aspectj;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * This class will serve as a Delegate for RealSubject. Note that no 
 * interfaces need to be implemented. Note further that it is possible to
 * have the delegate's method be static (illustrated here).
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see RealSubject
 */  
public class AnotherRealSubject{  

    /**
     * Prints the argument string to <code>System.out</code>. This is 
     * equivalent to <code>write(String)</code>. 
     *
     * @param s the string to print
     */

	public static void print(String s) {
		System.out.println("[AnotherRealSubject.print:] "+s);
	}

    /**
     * Prints the argument string to <code>System.out</code>. This is 
     * equivalent to <code>print(String)</code>
     *
     * @param s the string to print
     */

	public static void write(String s) {
		System.out.println("[AnotherRealSubject.write:] "+s);
	}
}