package examples.proxy.aspectj;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * Implements the driver for the proxy design pattern example.<p> 
 *
 * Intent: <i>Provide a surrogate or placeholder for another object to control
 * access to it.</i><p>
 *
 * Participatng objects are <code>RealSubject</code>s and <code>Proxy</code>. 
 * Both implement the <code>Subject</code> interface.
 *
 * <i>Proxy</i> forwards or blocks requests to <i>RealSubject</i>
 *
 * <p><i>This is the AspectJ version.</i><p> 
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see RealSubject
 * @see AnotherRealSubject
 * @see ProtectionProxy
 * @see DelegationProxy
 */

public class Main {
    
    /** 
     * Creates a new Main object and runs the test suite.
     */  
    
	public Main() { 

	    /**
	     * The <i>RealSubject</i> that the client sends all requests to
	     */
	     
		RealSubject real = new RealSubject(); 
		
		real.print("PRINT");
		real.write("WRITE");
		real.print("PRINT");
		real.write("WRITE");
	}	    

    /** 
     * Implements the driver for the proxy design pattern example.
     * Experimental setup (AOP): RealSubject and Proxy are identical. 
	 * No need for common interface. Concrete Aspect intercepts 
	 * method calls of interest. No performance penalty for methods
	 * that are not of interest. <p>
	 *
	 * Note that this library aspect is not suited for remote or
	 * virtual proxies.<p>
	 *
	 * This example illustrates two applications of the proxy pattern.
	 * One pattern instance protects the <code>print(String)</code> on
	 * <code>RealSubject</code>s and denies access to callers of type
	 * <code>Main</code>. The other instance intercepts calls to   
	 * <code>print(String)</code> on <code>RealSubject</code>s and 
	 * delegates them to <code>AnotherRealSubject</code>.
	 */

	public static void main (String[] args) { 
        Main main = new Main();
	}
}
