package examples.proxy.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * Implements the driver for the proxy design pattern example.<p> 
 *
 * Intent: <i>Provide a surrogate or placeholder for another object to control
 * access to it.</i><p>
 *
 * Participatng objects are <code>RealSubject</code>s and <code>Proxy</code>. 
 * Both implement the <code>Subject</code> interface.
 *
 * <i>Proxy</i> forwards or blocks requests to <i>RealSubject</i>
 *
 * <p><i>This is the Java version.</i><p> 
 *
 * <code>Proxy</code> needs to implement all methods of <i>Subject</i>, even 
 * those it is not interested in. <i>Proxy</i> needs to be aware of its role
 * in the pattern.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see Subject
 * @see RealSubject
 * @see Proxy
 */

public class Main {   

    /**
     * Implements the driver for the proxy design pattern. Experimental setup:
     * The proxy is to count the number of calls to RealSubject.print(String). 
     * It is not interested in calls to Subject.write(String).
     * Proxy has to implement all method of subject, even those that are of 
     * no interest.
     */

	public static void main (String[] args) { 
		Subject real  = new RealSubject();
		Subject proxy = new Proxy(real);
		
		proxy.print("PRINT");
		proxy.write("WRITE");
		proxy.print("PRINT");
		proxy.write("WRITE");
	}
}
