package examples.singleton.aspectj;


/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

import ca.ubc.cs.spl.pattern.library.SingletonProtocol;

/**
 * Implements a concrete instance of the <i>Singleton</i> pattern. It declares
 * Printer to be Singleton and defines an exception to the Singleton
 * of the constructor: PrinterSubclass (a subclass of the Singleton) can still
 * access Printer's constructor.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see Printer
 * @see PrinterSubclass
 */


public aspect SingletonInstance extends SingletonProtocol { 
    
    /**
     * Assigns the Singleton to <code>Printer</code>
     */
  
	declare parents: Printer implements Singleton;		                // Alternatively, Printer can just declare to implement it
	
    /**
     * This declaration allows <code>PrinterSubclass</code> (and all its
     * subclasses) to access <code>Printer</code>'s constructor within
     * a its constructor (to allow for <code>super()</code> calls).
     */
 
 	protected pointcut protectionExclusions(): call((PrinterSubclass+).new(..));  // To allow access to regular constructor (for subclasses etc.)
}