package examples.singleton.java;


/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.patterns.
 *
 * Contributor(s):   
 */

/**
 * Implements a sample <i>Singleton</i> class. The class's functionality
 * is to store an instance-specific ID and provide a <code>print()</code>
 * method that shows an object's ID.  
 *
 * Note that in this implementation the <i>Singleton</i> class has to know
 * that it implements the pattern (i.e. has to have appropriate code in it).
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see PrinterSubclass
 */

 
public class PrinterSingleton { 

    /**
     * Counts the instances of this class
     */
      
	protected static int objectsSoFar = 0;  

    /**
     * Stores the <i>Singleton</i>'s only instance
     */
  
	protected static PrinterSingleton onlyInstance = null;

    /**
     * Each instance has an ID to distinguish them.
     */
  
	protected int id;

    /**
     * Creates a new <code>PrinterSingleton</code>. The new instance gets
     * an ID equal to the total number of instacnes of that type created +1.
     */
    
	protected PrinterSingleton() {
		id = ++ objectsSoFar;
	}
	
    /**
     * Factory method that provides access to the <i>Singleton</i> instance.
     *
     * returns the unique <i>Singleton</i> instance
     */
    
	public static PrinterSingleton instance() {
		if(onlyInstance == null) {
			onlyInstance = new PrinterSingleton();
		}
		return onlyInstance;
	}
	
    /**
     * Prints the instance's ID to <code>System.out</code>.
     */
    
	public void print() {
		System.out.println("\tMy ID is "+id);
	}
}
	