package examples.state.aspectj;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.pattern.
 *
 * Contributor(s):   
 */

/**
 * Defines the interface for <i>State</i>s within this queue example. The 
 * operations provided are insert, getFirst, and removeFirst. This verison
 * does not require passing the context as an argument to these functions. 
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 06/13/02
 */

public interface QueueState {
	
    /**
     * Tries to insert an object into the queue. Returns true if successful, 
     * false otherwiese.
     *
     * @param arg the object to be inserted into the queue
     * @returns true if insertion was successful, false otherwise.
     */ 
	
	public boolean insert(Object arg);

    /**
     * Returns the first item in the queue
     *
     * @returns the first item in the queue
     */ 

	public Object  getFirst();	

    /**
     * Tries to remove an object from the queue. Returns true if successful,
     * false otherwiese.
     *
     * @returns true if deletion was successful, false otherwise.
     */ 

	public boolean removeFirst();	

}