package examples.templateMethod.java;

/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This file is part of the design patterns project at UBC
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * either http://www.mozilla.org/MPL/ or http://aspectj.org/MPL/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ca.ubc.cs.spl.pattern.
 *
 * Contributor(s):   
 */

/**
 * Implements the driver for the Template Method design pattern example.<p>
 *
 * Intent: <i>Define the skeleton of an algorithm in an operation, deferring 
 * some steps to subclasses. Template Method lets subclasses redefine certain
 * steps of an algorithm without changing the algorithm's structure</i><p>
 *
 * Participatng objects are <code>SimpleCreator</code> and 
 * <code>FancyCreator</code> as <i>ConcreteClass</i>es. The 
 * <i>AbstractClass</i> is <code>Creator</code>.
 *  <p>
 *
 * In this example, the template method <code>decorate(String)</code> calls
 * modifies a string in three steps and returns the result. The SimpleCreator
 * does not change the string much, but adds a period at the end of it. The
 * FancyCreator turns the string to lowercase, then capitalizes all 
 * consonants and adds an explanantion to it.
 *
 * <p><i>This is the Java version.</i><p>
 *
 * Note that <i>AbstractClass</i> does in fact have to be abstract, to 
 * make it possible to define a default implementation for the template 
 * method.
 *
 * @author  Jan Hannemann
 * @author  Gregor Kiczales
 * @version 1.0, 05/13/02
 * 
 * @see Creator
 * @see SimpleCreator
 * @see FancyCreator
 */

public class Main {

    /**
     * Implements the driver for the Template Method design pattern example.<p>
     *
     * In this example, the template method <code>decorate(String)</code> calls
     * modifies a string in three steps and returns the result. The SimpleCreator
     * does not change the string much, but adds a period at the end of it. The
     * FancyCreator turns the string to lowercase, then capitalizes all 
     * consonants and adds an explanantion to it.        
     *
     * @param args the command line parameters, unused
     */
 
	public static void main(String[] args) {
		String original = "This Is The Original String To Be Processed";
		
		Creator c1 = new SimpleCreator();
		Creator c2 = new FancyCreator();
		
		System.out.println("<Original>");
		System.out.println(original);
		System.out.println("<SimpleCreator>");
		System.out.println(c1.decorate(original));
		System.out.println("<FancyCreator>");
		System.out.println(c2.decorate(original));
	}
}