# makefile for panorama stitching, created by hugin 



# Tool configuration
NONA=nona
PTSTITCHER=PTStitcher
PTMENDER=PTmender
PTBLENDER=PTblender
PTMASKER=PTmasker
PTROLLER=PTroller
ENBLEND=enblend
ENFUSE=enfuse
SMARTBLEND=smartblend.exe
HDRMERGE=hugin_hdrmerge
RM=rm
EXIFTOOL=exiftool

# Project parameters
HUGIN_PROJECTION=1
HUGIN_HFOV=186
HUGIN_WIDTH=2279
HUGIN_HEIGHT=273

# options for the programs

NONA_LDR_REMAPPED_COMP=-z PACKBITS
ENBLEND_OPTS= -f2279x273
ENBLEND_LDR_COMP=--compression NONE
ENBLEND_HDR_COMP=
ENFUSE_OPTS=
EXIFTOOL_COPY_ARGS=-ImageDescription -Make -Model -Artist -WhitePoint -Copyright -GPS:all -DateTimeOriginal -CreateDate -UserComment -ColorSpace -OwnerName -SerialNumber

# the output panorama
LDR_REMAPPED_PREFIX=DSC07135-DSC07142
LDR_REMAPPED_PREFIX_SHELL=DSC07135-DSC07142
HDR_STACK_REMAPPED_PREFIX=DSC07135-DSC07142_hdr_
HDR_STACK_REMAPPED_PREFIX_SHELL=DSC07135-DSC07142_hdr_
LDR_EXPOSURE_REMAPPED_PREFIX=DSC07135-DSC07142_exposure_layers_
LDR_EXPOSURE_REMAPPED_PREFIX_SHELL=DSC07135-DSC07142_exposure_layers_
PROJECT_FILE=/home/carfield/Pictures/Untitled\ Export/DSC07135-DSC07142.pto
PROJECT_FILE_SHELL=/home/carfield/Pictures/Untitled\ Export/DSC07135-DSC07142.pto
LDR_BLENDED=DSC07135-DSC07142.tif
LDR_BLENDED_SHELL=DSC07135-DSC07142.tif
LDR_STACKED_BLENDED=DSC07135-DSC07142_fused.tif
LDR_STACKED_BLENDED_SHELL=DSC07135-DSC07142_fused.tif
HDR_BLENDED=DSC07135-DSC07142_hdr.exr
HDR_BLENDED_SHELL=DSC07135-DSC07142_hdr.exr

# first input image
INPUT_IMAGE_1=/home/carfield/Pictures/Untitled\ Export/DSC07135.jpg
INPUT_IMAGE_1_SHELL=/home/carfield/Pictures/Untitled\ Export/DSC07135.jpg
# all input images
INPUT_IMAGES=/home/carfield/Pictures/Untitled\ Export/DSC07135.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07136.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07137.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07138.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07139.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07140.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07141.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07142.jpg

INPUT_IMAGES_SHELL=/home/carfield/Pictures/Untitled\ Export/DSC07135.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07136.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07137.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07138.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07139.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07140.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07141.jpg\
/home/carfield/Pictures/Untitled\ Export/DSC07142.jpg

# remapped images
LDR_LAYERS=DSC07135-DSC071420000.tif\
DSC07135-DSC071420001.tif\
DSC07135-DSC071420002.tif\
DSC07135-DSC071420003.tif\
DSC07135-DSC071420004.tif\
DSC07135-DSC071420005.tif\
DSC07135-DSC071420006.tif\
DSC07135-DSC071420007.tif

LDR_LAYERS_SHELL=DSC07135-DSC071420000.tif\
DSC07135-DSC071420001.tif\
DSC07135-DSC071420002.tif\
DSC07135-DSC071420003.tif\
DSC07135-DSC071420004.tif\
DSC07135-DSC071420005.tif\
DSC07135-DSC071420006.tif\
DSC07135-DSC071420007.tif

# remapped images (hdr)
HDR_LAYERS=DSC07135-DSC07142_hdr_0000.exr\
DSC07135-DSC07142_hdr_0001.exr\
DSC07135-DSC07142_hdr_0002.exr\
DSC07135-DSC07142_hdr_0003.exr\
DSC07135-DSC07142_hdr_0004.exr\
DSC07135-DSC07142_hdr_0005.exr\
DSC07135-DSC07142_hdr_0006.exr\
DSC07135-DSC07142_hdr_0007.exr

HDR_LAYERS_SHELL=DSC07135-DSC07142_hdr_0000.exr\
DSC07135-DSC07142_hdr_0001.exr\
DSC07135-DSC07142_hdr_0002.exr\
DSC07135-DSC07142_hdr_0003.exr\
DSC07135-DSC07142_hdr_0004.exr\
DSC07135-DSC07142_hdr_0005.exr\
DSC07135-DSC07142_hdr_0006.exr\
DSC07135-DSC07142_hdr_0007.exr

# remapped maxval images
HDR_LAYERS_WEIGHTS=DSC07135-DSC07142_hdr_0000_gray.pgm \
DSC07135-DSC07142_hdr_0001_gray.pgm \
DSC07135-DSC07142_hdr_0002_gray.pgm \
DSC07135-DSC07142_hdr_0003_gray.pgm \
DSC07135-DSC07142_hdr_0004_gray.pgm \
DSC07135-DSC07142_hdr_0005_gray.pgm \
DSC07135-DSC07142_hdr_0006_gray.pgm \
DSC07135-DSC07142_hdr_0007_gray.pgm 

HDR_LAYERS_WEIGHTS_SHELL=DSC07135-DSC07142_hdr_0000_gray.pgm\
DSC07135-DSC07142_hdr_0001_gray.pgm\
DSC07135-DSC07142_hdr_0002_gray.pgm\
DSC07135-DSC07142_hdr_0003_gray.pgm\
DSC07135-DSC07142_hdr_0004_gray.pgm\
DSC07135-DSC07142_hdr_0005_gray.pgm\
DSC07135-DSC07142_hdr_0006_gray.pgm\
DSC07135-DSC07142_hdr_0007_gray.pgm

# stacked images
HDR_STACKS_NUMBERS = 0 1 2 3 4 5 6 7 
HDR_STACK_0 = DSC07135-DSC07142_stack_hdr_0000.exr
HDR_STACK_0_SHELL = DSC07135-DSC07142_stack_hdr_0000.exr
HDR_STACK_0_INPUT = DSC07135-DSC07142_hdr_0000.exr

HDR_STACK_0_INPUT_SHELL = DSC07135-DSC07142_hdr_0000.exr

HDR_STACK_1 = DSC07135-DSC07142_stack_hdr_0001.exr
HDR_STACK_1_SHELL = DSC07135-DSC07142_stack_hdr_0001.exr
HDR_STACK_1_INPUT = DSC07135-DSC07142_hdr_0001.exr

HDR_STACK_1_INPUT_SHELL = DSC07135-DSC07142_hdr_0001.exr

HDR_STACK_2 = DSC07135-DSC07142_stack_hdr_0002.exr
HDR_STACK_2_SHELL = DSC07135-DSC07142_stack_hdr_0002.exr
HDR_STACK_2_INPUT = DSC07135-DSC07142_hdr_0002.exr

HDR_STACK_2_INPUT_SHELL = DSC07135-DSC07142_hdr_0002.exr

HDR_STACK_3 = DSC07135-DSC07142_stack_hdr_0003.exr
HDR_STACK_3_SHELL = DSC07135-DSC07142_stack_hdr_0003.exr
HDR_STACK_3_INPUT = DSC07135-DSC07142_hdr_0003.exr

HDR_STACK_3_INPUT_SHELL = DSC07135-DSC07142_hdr_0003.exr

HDR_STACK_4 = DSC07135-DSC07142_stack_hdr_0004.exr
HDR_STACK_4_SHELL = DSC07135-DSC07142_stack_hdr_0004.exr
HDR_STACK_4_INPUT = DSC07135-DSC07142_hdr_0004.exr

HDR_STACK_4_INPUT_SHELL = DSC07135-DSC07142_hdr_0004.exr

HDR_STACK_5 = DSC07135-DSC07142_stack_hdr_0005.exr
HDR_STACK_5_SHELL = DSC07135-DSC07142_stack_hdr_0005.exr
HDR_STACK_5_INPUT = DSC07135-DSC07142_hdr_0005.exr

HDR_STACK_5_INPUT_SHELL = DSC07135-DSC07142_hdr_0005.exr

HDR_STACK_6 = DSC07135-DSC07142_stack_hdr_0006.exr
HDR_STACK_6_SHELL = DSC07135-DSC07142_stack_hdr_0006.exr
HDR_STACK_6_INPUT = DSC07135-DSC07142_hdr_0006.exr

HDR_STACK_6_INPUT_SHELL = DSC07135-DSC07142_hdr_0006.exr

HDR_STACK_7 = DSC07135-DSC07142_stack_hdr_0007.exr
HDR_STACK_7_SHELL = DSC07135-DSC07142_stack_hdr_0007.exr
HDR_STACK_7_INPUT = DSC07135-DSC07142_hdr_0007.exr

HDR_STACK_7_INPUT_SHELL = DSC07135-DSC07142_hdr_0007.exr


HDR_STACKS = $(HDR_STACK_0) $(HDR_STACK_1) $(HDR_STACK_2) $(HDR_STACK_3) $(HDR_STACK_4) $(HDR_STACK_5) $(HDR_STACK_6) $(HDR_STACK_7) 
HDR_STACKS_SHELL = $(HDR_STACK_0_SHELL) $(HDR_STACK_1_SHELL) $(HDR_STACK_2_SHELL) $(HDR_STACK_3_SHELL) $(HDR_STACK_4_SHELL) $(HDR_STACK_5_SHELL) $(HDR_STACK_6_SHELL) $(HDR_STACK_7_SHELL) 


# number of image sets with similar exposure
LDR_EXPOSURE_EXPOSURE_LAYERS_NUMBERS = 0 1 2 3 4 
LDR_EXPOSURE_LAYER_0 = DSC07135-DSC07142_exposure_00.tif
LDR_EXPOSURE_LAYER_0_SHELL = DSC07135-DSC07142_exposure_00.tif
LDR_EXPOSURE_LAYER_0_INPUT = DSC07135-DSC07142_exposure_layers_0000.tif

LDR_EXPOSURE_LAYER_0_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0000.tif

LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER = DSC07135-DSC071420000.tif

LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER_SHELL = DSC07135-DSC071420000.tif
LDR_EXPOSURE_LAYER_0_EXPOSURE = 25.2193
LDR_EXPOSURE_LAYER_1 = DSC07135-DSC07142_exposure_01.tif
LDR_EXPOSURE_LAYER_1_SHELL = DSC07135-DSC07142_exposure_01.tif
LDR_EXPOSURE_LAYER_1_INPUT = DSC07135-DSC07142_exposure_layers_0001.tif\
DSC07135-DSC07142_exposure_layers_0007.tif

LDR_EXPOSURE_LAYER_1_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0001.tif\
DSC07135-DSC07142_exposure_layers_0007.tif

LDR_EXPOSURE_LAYER_1_INPUT_PTMENDER = DSC07135-DSC071420001.tif\
DSC07135-DSC071420007.tif

LDR_EXPOSURE_LAYER_1_INPUT_PTMENDER_SHELL = DSC07135-DSC071420001.tif\
DSC07135-DSC071420007.tif
LDR_EXPOSURE_LAYER_1_EXPOSURE = 25.7381
LDR_EXPOSURE_LAYER_2 = DSC07135-DSC07142_exposure_02.tif
LDR_EXPOSURE_LAYER_2_SHELL = DSC07135-DSC07142_exposure_02.tif
LDR_EXPOSURE_LAYER_2_INPUT = DSC07135-DSC07142_exposure_layers_0002.tif

LDR_EXPOSURE_LAYER_2_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0002.tif

LDR_EXPOSURE_LAYER_2_INPUT_PTMENDER = DSC07135-DSC071420002.tif

LDR_EXPOSURE_LAYER_2_INPUT_PTMENDER_SHELL = DSC07135-DSC071420002.tif
LDR_EXPOSURE_LAYER_2_EXPOSURE = 26.7522
LDR_EXPOSURE_LAYER_3 = DSC07135-DSC07142_exposure_03.tif
LDR_EXPOSURE_LAYER_3_SHELL = DSC07135-DSC07142_exposure_03.tif
LDR_EXPOSURE_LAYER_3_INPUT = DSC07135-DSC07142_exposure_layers_0003.tif\
DSC07135-DSC07142_exposure_layers_0006.tif

LDR_EXPOSURE_LAYER_3_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0003.tif\
DSC07135-DSC07142_exposure_layers_0006.tif

LDR_EXPOSURE_LAYER_3_INPUT_PTMENDER = DSC07135-DSC071420003.tif\
DSC07135-DSC071420006.tif

LDR_EXPOSURE_LAYER_3_INPUT_PTMENDER_SHELL = DSC07135-DSC071420003.tif\
DSC07135-DSC071420006.tif
LDR_EXPOSURE_LAYER_3_EXPOSURE = 27.4012
LDR_EXPOSURE_LAYER_4 = DSC07135-DSC07142_exposure_04.tif
LDR_EXPOSURE_LAYER_4_SHELL = DSC07135-DSC07142_exposure_04.tif
LDR_EXPOSURE_LAYER_4_INPUT = DSC07135-DSC07142_exposure_layers_0004.tif\
DSC07135-DSC07142_exposure_layers_0005.tif

LDR_EXPOSURE_LAYER_4_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0004.tif\
DSC07135-DSC07142_exposure_layers_0005.tif

LDR_EXPOSURE_LAYER_4_INPUT_PTMENDER = DSC07135-DSC071420004.tif\
DSC07135-DSC071420005.tif

LDR_EXPOSURE_LAYER_4_INPUT_PTMENDER_SHELL = DSC07135-DSC071420004.tif\
DSC07135-DSC071420005.tif
LDR_EXPOSURE_LAYER_4_EXPOSURE = 28.2076

LDR_EXPOSURE_LAYERS = $(LDR_EXPOSURE_LAYER_0) $(LDR_EXPOSURE_LAYER_1) $(LDR_EXPOSURE_LAYER_2) $(LDR_EXPOSURE_LAYER_3) $(LDR_EXPOSURE_LAYER_4) 
LDR_EXPOSURE_LAYERS_SHELL = $(LDR_EXPOSURE_LAYER_0_SHELL) $(LDR_EXPOSURE_LAYER_1_SHELL) $(LDR_EXPOSURE_LAYER_2_SHELL) $(LDR_EXPOSURE_LAYER_3_SHELL) $(LDR_EXPOSURE_LAYER_4_SHELL) 
LDR_EXPOSURE_LAYERS_REMAPPED = DSC07135-DSC07142_exposure_layers_0000.tif\
DSC07135-DSC07142_exposure_layers_0001.tif\
DSC07135-DSC07142_exposure_layers_0007.tif\
DSC07135-DSC07142_exposure_layers_0002.tif\
DSC07135-DSC07142_exposure_layers_0003.tif\
DSC07135-DSC07142_exposure_layers_0006.tif\
DSC07135-DSC07142_exposure_layers_0004.tif\
DSC07135-DSC07142_exposure_layers_0005.tif

LDR_EXPOSURE_LAYERS_REMAPPED_SHELL = DSC07135-DSC07142_exposure_layers_0000.tif\
DSC07135-DSC07142_exposure_layers_0001.tif\
DSC07135-DSC07142_exposure_layers_0007.tif\
DSC07135-DSC07142_exposure_layers_0002.tif\
DSC07135-DSC07142_exposure_layers_0003.tif\
DSC07135-DSC07142_exposure_layers_0006.tif\
DSC07135-DSC07142_exposure_layers_0004.tif\
DSC07135-DSC07142_exposure_layers_0005.tif


# stacked images for enfuse or other automatic exposure blending tools
LDR_STACKS_NUMBERS = 0 1 2 3 4 5 6 7 
LDR_STACK_0 = DSC07135-DSC07142_stack_ldr_0000.tif
LDR_STACK_0_SHELL = DSC07135-DSC07142_stack_ldr_0000.tif
LDR_STACK_0_INPUT = DSC07135-DSC07142_exposure_layers_0000.tif

LDR_STACK_0_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0000.tif

LDR_STACK_1 = DSC07135-DSC07142_stack_ldr_0001.tif
LDR_STACK_1_SHELL = DSC07135-DSC07142_stack_ldr_0001.tif
LDR_STACK_1_INPUT = DSC07135-DSC07142_exposure_layers_0001.tif

LDR_STACK_1_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0001.tif

LDR_STACK_2 = DSC07135-DSC07142_stack_ldr_0002.tif
LDR_STACK_2_SHELL = DSC07135-DSC07142_stack_ldr_0002.tif
LDR_STACK_2_INPUT = DSC07135-DSC07142_exposure_layers_0002.tif

LDR_STACK_2_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0002.tif

LDR_STACK_3 = DSC07135-DSC07142_stack_ldr_0003.tif
LDR_STACK_3_SHELL = DSC07135-DSC07142_stack_ldr_0003.tif
LDR_STACK_3_INPUT = DSC07135-DSC07142_exposure_layers_0003.tif

LDR_STACK_3_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0003.tif

LDR_STACK_4 = DSC07135-DSC07142_stack_ldr_0004.tif
LDR_STACK_4_SHELL = DSC07135-DSC07142_stack_ldr_0004.tif
LDR_STACK_4_INPUT = DSC07135-DSC07142_exposure_layers_0004.tif

LDR_STACK_4_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0004.tif

LDR_STACK_5 = DSC07135-DSC07142_stack_ldr_0005.tif
LDR_STACK_5_SHELL = DSC07135-DSC07142_stack_ldr_0005.tif
LDR_STACK_5_INPUT = DSC07135-DSC07142_exposure_layers_0005.tif

LDR_STACK_5_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0005.tif

LDR_STACK_6 = DSC07135-DSC07142_stack_ldr_0006.tif
LDR_STACK_6_SHELL = DSC07135-DSC07142_stack_ldr_0006.tif
LDR_STACK_6_INPUT = DSC07135-DSC07142_exposure_layers_0006.tif

LDR_STACK_6_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0006.tif

LDR_STACK_7 = DSC07135-DSC07142_stack_ldr_0007.tif
LDR_STACK_7_SHELL = DSC07135-DSC07142_stack_ldr_0007.tif
LDR_STACK_7_INPUT = DSC07135-DSC07142_exposure_layers_0007.tif

LDR_STACK_7_INPUT_SHELL = DSC07135-DSC07142_exposure_layers_0007.tif


LDR_STACKS = $(LDR_STACK_0) $(LDR_STACK_1) $(LDR_STACK_2) $(LDR_STACK_3) $(LDR_STACK_4) $(LDR_STACK_5) $(LDR_STACK_6) $(LDR_STACK_7) 
LDR_STACKS_SHELL = $(LDR_STACK_0_SHELL) $(LDR_STACK_1_SHELL) $(LDR_STACK_2_SHELL) $(LDR_STACK_3_SHELL) $(LDR_STACK_4_SHELL) $(LDR_STACK_5_SHELL) $(LDR_STACK_6_SHELL) $(LDR_STACK_7_SHELL) 
DO_LDR_BLENDED = 1
TEMP_FILES_SHELL = $(LDR_LAYERS_SHELL) 

all: $(LDR_BLENDED) 

clean: 
	-$(RM) $(TEMP_FILES_SHELL)

test: 
	@echo -n 'Checking nona...'
	@-$(NONA) --help > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking enblend...'
	@-$(ENBLEND) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking enfuse...'
	@-$(ENFUSE) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking hugin_hdrmerge...'
	@-$(HDRMERGE) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking exiftool...'
	@-$(EXIFTOOL) -ver > /dev/null 2>&1 && echo '[OK]' || echo '[FAIL]'

# Rules for ordinary TIFF_m output
DSC07135-DSC071420000.tif: /home/carfield/Pictures/Untitled\ Export/DSC07135.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

DSC07135-DSC071420001.tif: /home/carfield/Pictures/Untitled\ Export/DSC07136.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

DSC07135-DSC071420002.tif: /home/carfield/Pictures/Untitled\ Export/DSC07137.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

DSC07135-DSC071420003.tif: /home/carfield/Pictures/Untitled\ Export/DSC07138.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

DSC07135-DSC071420004.tif: /home/carfield/Pictures/Untitled\ Export/DSC07139.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 4 $(PROJECT_FILE_SHELL)

DSC07135-DSC071420005.tif: /home/carfield/Pictures/Untitled\ Export/DSC07140.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 5 $(PROJECT_FILE_SHELL)

DSC07135-DSC071420006.tif: /home/carfield/Pictures/Untitled\ Export/DSC07141.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 6 $(PROJECT_FILE_SHELL)

DSC07135-DSC071420007.tif: /home/carfield/Pictures/Untitled\ Export/DSC07142.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 7 $(PROJECT_FILE_SHELL)

# Rules for merge to hdr output
DSC07135-DSC07142_hdr_0000.exr: /home/carfield/Pictures/Untitled\ Export/DSC07135.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_hdr_0001.exr: /home/carfield/Pictures/Untitled\ Export/DSC07136.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_hdr_0002.exr: /home/carfield/Pictures/Untitled\ Export/DSC07137.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_hdr_0003.exr: /home/carfield/Pictures/Untitled\ Export/DSC07138.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_hdr_0004.exr: /home/carfield/Pictures/Untitled\ Export/DSC07139.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 4 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_hdr_0005.exr: /home/carfield/Pictures/Untitled\ Export/DSC07140.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 5 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_hdr_0006.exr: /home/carfield/Pictures/Untitled\ Export/DSC07141.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 6 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_hdr_0007.exr: /home/carfield/Pictures/Untitled\ Export/DSC07142.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 7 $(PROJECT_FILE_SHELL)

# Rules for exposure layer output
DSC07135-DSC07142_exposure_layers_0000.tif: /home/carfield/Pictures/Untitled\ Export/DSC07135.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 12.6096 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_exposure_layers_0001.tif: /home/carfield/Pictures/Untitled\ Export/DSC07136.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 12.9008 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_exposure_layers_0007.tif: /home/carfield/Pictures/Untitled\ Export/DSC07142.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 12.8373 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 7 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_exposure_layers_0002.tif: /home/carfield/Pictures/Untitled\ Export/DSC07137.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 13.3761 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_exposure_layers_0003.tif: /home/carfield/Pictures/Untitled\ Export/DSC07138.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 13.7934 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_exposure_layers_0006.tif: /home/carfield/Pictures/Untitled\ Export/DSC07141.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 13.6078 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 6 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_exposure_layers_0004.tif: /home/carfield/Pictures/Untitled\ Export/DSC07139.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 14.1554 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 4 $(PROJECT_FILE_SHELL)

DSC07135-DSC07142_exposure_layers_0005.tif: /home/carfield/Pictures/Untitled\ Export/DSC07140.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 14.0522 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 5 $(PROJECT_FILE_SHELL)

$(HDR_STACK_0) : $(HDR_STACK_0_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_0_SHELL) $(HDR_STACK_0_INPUT_SHELL)

$(HDR_STACK_1) : $(HDR_STACK_1_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_1_SHELL) $(HDR_STACK_1_INPUT_SHELL)

$(HDR_STACK_2) : $(HDR_STACK_2_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_2_SHELL) $(HDR_STACK_2_INPUT_SHELL)

$(HDR_STACK_3) : $(HDR_STACK_3_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_3_SHELL) $(HDR_STACK_3_INPUT_SHELL)

$(HDR_STACK_4) : $(HDR_STACK_4_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_4_SHELL) $(HDR_STACK_4_INPUT_SHELL)

$(HDR_STACK_5) : $(HDR_STACK_5_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_5_SHELL) $(HDR_STACK_5_INPUT_SHELL)

$(HDR_STACK_6) : $(HDR_STACK_6_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_6_SHELL) $(HDR_STACK_6_INPUT_SHELL)

$(HDR_STACK_7) : $(HDR_STACK_7_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_7_SHELL) $(HDR_STACK_7_INPUT_SHELL)

$(LDR_STACK_0) : $(LDR_STACK_0_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_0_SHELL) $(LDR_STACK_0_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_0_SHELL)

$(LDR_STACK_1) : $(LDR_STACK_1_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_1_SHELL) $(LDR_STACK_1_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_1_SHELL)

$(LDR_STACK_2) : $(LDR_STACK_2_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_2_SHELL) $(LDR_STACK_2_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_2_SHELL)

$(LDR_STACK_3) : $(LDR_STACK_3_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_3_SHELL) $(LDR_STACK_3_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_3_SHELL)

$(LDR_STACK_4) : $(LDR_STACK_4_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_4_SHELL) $(LDR_STACK_4_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_4_SHELL)

$(LDR_STACK_5) : $(LDR_STACK_5_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_5_SHELL) $(LDR_STACK_5_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_5_SHELL)

$(LDR_STACK_6) : $(LDR_STACK_6_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_6_SHELL) $(LDR_STACK_6_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_6_SHELL)

$(LDR_STACK_7) : $(LDR_STACK_7_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_7_SHELL) $(LDR_STACK_7_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_7_SHELL)

$(LDR_BLENDED) : $(LDR_LAYERS)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_BLENDED_SHELL) $(LDR_LAYERS_SHELL) 
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_BLENDED_SHELL)

$(LDR_EXPOSURE_LAYER_0) : $(LDR_EXPOSURE_LAYER_0_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_0_SHELL) $(LDR_EXPOSURE_LAYER_0_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_0_SHELL)

$(LDR_EXPOSURE_LAYER_1) : $(LDR_EXPOSURE_LAYER_1_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_1_SHELL) $(LDR_EXPOSURE_LAYER_1_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_1_SHELL)

$(LDR_EXPOSURE_LAYER_2) : $(LDR_EXPOSURE_LAYER_2_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_2_SHELL) $(LDR_EXPOSURE_LAYER_2_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_2_SHELL)

$(LDR_EXPOSURE_LAYER_3) : $(LDR_EXPOSURE_LAYER_3_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_3_SHELL) $(LDR_EXPOSURE_LAYER_3_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_3_SHELL)

$(LDR_EXPOSURE_LAYER_4) : $(LDR_EXPOSURE_LAYER_4_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_4_SHELL) $(LDR_EXPOSURE_LAYER_4_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_4_SHELL)

$(LDR_STACKED_BLENDED) : $(LDR_STACKS)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_STACKED_BLENDED_SHELL) $(LDR_STACKS_SHELL) 
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACKED_BLENDED_SHELL)

$(HDR_BLENDED) : $(HDR_STACKS)
	$(ENBLEND) $(ENBLEND_HDR_COMP) $(ENBLEND_OPTS) -o $(HDR_BLENDED_SHELL) $(HDR_STACKS_SHELL) 

