# makefile for panorama stitching, created by hugin 



# Tool configuration
NONA=nona
PTSTITCHER=PTStitcher
PTMENDER=PTmender
PTBLENDER=PTblender
PTMASKER=PTmasker
PTROLLER=PTroller
ENBLEND=enblend
ENFUSE=enfuse
SMARTBLEND=smartblend.exe
HDRMERGE=hugin_hdrmerge
RM=rm
EXIFTOOL=exiftool

# Project parameters
HUGIN_PROJECTION=1
HUGIN_HFOV=154
HUGIN_WIDTH=2071
HUGIN_HEIGHT=751

# options for the programs

NONA_LDR_REMAPPED_COMP=-z PACKBITS 
ENBLEND_OPTS= -f2071x751
ENBLEND_LDR_COMP=--compression 100
ENBLEND_HDR_COMP=
ENFUSE_OPTS=
EXIFTOOL_COPY_ARGS=-ImageDescription -Make -Model -Artist -WhitePoint -Copyright -GPS:all -DateTimeOriginal -CreateDate -UserComment -ColorSpace -OwnerName -SerialNumber

# the output panorama
LDR_REMAPPED_PREFIX=dsc09894-dsc09897
LDR_REMAPPED_PREFIX_SHELL=dsc09894-dsc09897
HDR_STACK_REMAPPED_PREFIX=dsc09894-dsc09897_hdr_
HDR_STACK_REMAPPED_PREFIX_SHELL=dsc09894-dsc09897_hdr_
LDR_EXPOSURE_REMAPPED_PREFIX=dsc09894-dsc09897_exposure_layers_
LDR_EXPOSURE_REMAPPED_PREFIX_SHELL=dsc09894-dsc09897_exposure_layers_
PROJECT_FILE=/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894-dsc09897.pto
PROJECT_FILE_SHELL=/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894-dsc09897.pto
LDR_BLENDED=dsc09894-dsc09897.jpg
LDR_BLENDED_SHELL=dsc09894-dsc09897.jpg
LDR_STACKED_BLENDED=dsc09894-dsc09897_fused.jpg
LDR_STACKED_BLENDED_SHELL=dsc09894-dsc09897_fused.jpg
HDR_BLENDED=dsc09894-dsc09897_hdr.exr
HDR_BLENDED_SHELL=dsc09894-dsc09897_hdr.exr

# first input image
INPUT_IMAGE_1=/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894.jpg
INPUT_IMAGE_1_SHELL=/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894.jpg
# all input images
INPUT_IMAGES=/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894.jpg\
/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09895.jpg\
/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09896.jpg\
/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09897.jpg

INPUT_IMAGES_SHELL=/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894.jpg\
/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09895.jpg\
/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09896.jpg\
/home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09897.jpg

# remapped images
LDR_LAYERS=dsc09894-dsc098970000.tif\
dsc09894-dsc098970001.tif\
dsc09894-dsc098970002.tif\
dsc09894-dsc098970003.tif

LDR_LAYERS_SHELL=dsc09894-dsc098970000.tif\
dsc09894-dsc098970001.tif\
dsc09894-dsc098970002.tif\
dsc09894-dsc098970003.tif

# remapped images (hdr)
HDR_LAYERS=dsc09894-dsc09897_hdr_0000.exr\
dsc09894-dsc09897_hdr_0001.exr\
dsc09894-dsc09897_hdr_0002.exr\
dsc09894-dsc09897_hdr_0003.exr

HDR_LAYERS_SHELL=dsc09894-dsc09897_hdr_0000.exr\
dsc09894-dsc09897_hdr_0001.exr\
dsc09894-dsc09897_hdr_0002.exr\
dsc09894-dsc09897_hdr_0003.exr

# remapped maxval images
HDR_LAYERS_WEIGHTS=dsc09894-dsc09897_hdr_0000_gray.pgm \
dsc09894-dsc09897_hdr_0001_gray.pgm \
dsc09894-dsc09897_hdr_0002_gray.pgm \
dsc09894-dsc09897_hdr_0003_gray.pgm 

HDR_LAYERS_WEIGHTS_SHELL=dsc09894-dsc09897_hdr_0000_gray.pgm\
dsc09894-dsc09897_hdr_0001_gray.pgm\
dsc09894-dsc09897_hdr_0002_gray.pgm\
dsc09894-dsc09897_hdr_0003_gray.pgm

# stacked images
HDR_STACKS_NUMBERS = 0 1 2 3 
HDR_STACK_0 = dsc09894-dsc09897_stack_hdr_0000.exr
HDR_STACK_0_SHELL = dsc09894-dsc09897_stack_hdr_0000.exr
HDR_STACK_0_INPUT = dsc09894-dsc09897_hdr_0000.exr

HDR_STACK_0_INPUT_SHELL = dsc09894-dsc09897_hdr_0000.exr

HDR_STACK_1 = dsc09894-dsc09897_stack_hdr_0001.exr
HDR_STACK_1_SHELL = dsc09894-dsc09897_stack_hdr_0001.exr
HDR_STACK_1_INPUT = dsc09894-dsc09897_hdr_0001.exr

HDR_STACK_1_INPUT_SHELL = dsc09894-dsc09897_hdr_0001.exr

HDR_STACK_2 = dsc09894-dsc09897_stack_hdr_0002.exr
HDR_STACK_2_SHELL = dsc09894-dsc09897_stack_hdr_0002.exr
HDR_STACK_2_INPUT = dsc09894-dsc09897_hdr_0002.exr

HDR_STACK_2_INPUT_SHELL = dsc09894-dsc09897_hdr_0002.exr

HDR_STACK_3 = dsc09894-dsc09897_stack_hdr_0003.exr
HDR_STACK_3_SHELL = dsc09894-dsc09897_stack_hdr_0003.exr
HDR_STACK_3_INPUT = dsc09894-dsc09897_hdr_0003.exr

HDR_STACK_3_INPUT_SHELL = dsc09894-dsc09897_hdr_0003.exr


HDR_STACKS = $(HDR_STACK_0) $(HDR_STACK_1) $(HDR_STACK_2) $(HDR_STACK_3) 
HDR_STACKS_SHELL = $(HDR_STACK_0_SHELL) $(HDR_STACK_1_SHELL) $(HDR_STACK_2_SHELL) $(HDR_STACK_3_SHELL) 


# number of image sets with similar exposure
LDR_EXPOSURE_EXPOSURE_LAYERS_NUMBERS = 0 1 
LDR_EXPOSURE_LAYER_0 = dsc09894-dsc09897_exposure_00.jpg
LDR_EXPOSURE_LAYER_0_SHELL = dsc09894-dsc09897_exposure_00.jpg
LDR_EXPOSURE_LAYER_0_INPUT = dsc09894-dsc09897_exposure_layers_0000.tif\
dsc09894-dsc09897_exposure_layers_0001.tif\
dsc09894-dsc09897_exposure_layers_0002.tif

LDR_EXPOSURE_LAYER_0_INPUT_SHELL = dsc09894-dsc09897_exposure_layers_0000.tif\
dsc09894-dsc09897_exposure_layers_0001.tif\
dsc09894-dsc09897_exposure_layers_0002.tif

LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER = dsc09894-dsc098970000.tif\
dsc09894-dsc098970001.tif\
dsc09894-dsc098970002.tif

LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER_SHELL = dsc09894-dsc098970000.tif\
dsc09894-dsc098970001.tif\
dsc09894-dsc098970002.tif
LDR_EXPOSURE_LAYER_0_EXPOSURE = 24.5419
LDR_EXPOSURE_LAYER_1 = dsc09894-dsc09897_exposure_01.jpg
LDR_EXPOSURE_LAYER_1_SHELL = dsc09894-dsc09897_exposure_01.jpg
LDR_EXPOSURE_LAYER_1_INPUT = dsc09894-dsc09897_exposure_layers_0003.tif

LDR_EXPOSURE_LAYER_1_INPUT_SHELL = dsc09894-dsc09897_exposure_layers_0003.tif

LDR_EXPOSURE_LAYER_1_INPUT_PTMENDER = dsc09894-dsc098970003.tif

LDR_EXPOSURE_LAYER_1_INPUT_PTMENDER_SHELL = dsc09894-dsc098970003.tif
LDR_EXPOSURE_LAYER_1_EXPOSURE = 24.154

LDR_EXPOSURE_LAYERS = $(LDR_EXPOSURE_LAYER_0) $(LDR_EXPOSURE_LAYER_1) 
LDR_EXPOSURE_LAYERS_SHELL = $(LDR_EXPOSURE_LAYER_0_SHELL) $(LDR_EXPOSURE_LAYER_1_SHELL) 
LDR_EXPOSURE_LAYERS_REMAPPED = dsc09894-dsc09897_exposure_layers_0000.tif\
dsc09894-dsc09897_exposure_layers_0001.tif\
dsc09894-dsc09897_exposure_layers_0002.tif\
dsc09894-dsc09897_exposure_layers_0003.tif

LDR_EXPOSURE_LAYERS_REMAPPED_SHELL = dsc09894-dsc09897_exposure_layers_0000.tif\
dsc09894-dsc09897_exposure_layers_0001.tif\
dsc09894-dsc09897_exposure_layers_0002.tif\
dsc09894-dsc09897_exposure_layers_0003.tif


# stacked images for enfuse or other automatic exposure blending tools
LDR_STACKS_NUMBERS = 0 1 2 3 
LDR_STACK_0 = dsc09894-dsc09897_stack_ldr_0000.tif
LDR_STACK_0_SHELL = dsc09894-dsc09897_stack_ldr_0000.tif
LDR_STACK_0_INPUT = dsc09894-dsc09897_exposure_layers_0000.tif

LDR_STACK_0_INPUT_SHELL = dsc09894-dsc09897_exposure_layers_0000.tif

LDR_STACK_1 = dsc09894-dsc09897_stack_ldr_0001.tif
LDR_STACK_1_SHELL = dsc09894-dsc09897_stack_ldr_0001.tif
LDR_STACK_1_INPUT = dsc09894-dsc09897_exposure_layers_0001.tif

LDR_STACK_1_INPUT_SHELL = dsc09894-dsc09897_exposure_layers_0001.tif

LDR_STACK_2 = dsc09894-dsc09897_stack_ldr_0002.tif
LDR_STACK_2_SHELL = dsc09894-dsc09897_stack_ldr_0002.tif
LDR_STACK_2_INPUT = dsc09894-dsc09897_exposure_layers_0002.tif

LDR_STACK_2_INPUT_SHELL = dsc09894-dsc09897_exposure_layers_0002.tif

LDR_STACK_3 = dsc09894-dsc09897_stack_ldr_0003.tif
LDR_STACK_3_SHELL = dsc09894-dsc09897_stack_ldr_0003.tif
LDR_STACK_3_INPUT = dsc09894-dsc09897_exposure_layers_0003.tif

LDR_STACK_3_INPUT_SHELL = dsc09894-dsc09897_exposure_layers_0003.tif


LDR_STACKS = $(LDR_STACK_0) $(LDR_STACK_1) $(LDR_STACK_2) $(LDR_STACK_3) 
LDR_STACKS_SHELL = $(LDR_STACK_0_SHELL) $(LDR_STACK_1_SHELL) $(LDR_STACK_2_SHELL) $(LDR_STACK_3_SHELL) 
DO_LDR_BLENDED = 1
TEMP_FILES_SHELL = $(LDR_LAYERS_SHELL) 

all: $(LDR_BLENDED) 

clean: 
	-$(RM) $(TEMP_FILES_SHELL)

test: 
	@echo -n 'Checking nona...'
	@-$(NONA) --help > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking enblend...'
	@-$(ENBLEND) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking enfuse...'
	@-$(ENFUSE) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking hugin_hdrmerge...'
	@-$(HDRMERGE) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking exiftool...'
	@-$(EXIFTOOL) -ver > /dev/null 2>&1 && echo '[OK]' || echo '[FAIL]'

# Rules for ordinary TIFF_m output
dsc09894-dsc098970000.tif: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

dsc09894-dsc098970001.tif: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09895.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

dsc09894-dsc098970002.tif: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09896.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

dsc09894-dsc098970003.tif: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09897.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

# Rules for merge to hdr output
dsc09894-dsc09897_hdr_0000.exr: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

dsc09894-dsc09897_hdr_0001.exr: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09895.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

dsc09894-dsc09897_hdr_0002.exr: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09896.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

dsc09894-dsc09897_hdr_0003.exr: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09897.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

# Rules for exposure layer output
dsc09894-dsc09897_exposure_layers_0000.tif: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09894.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 12.3078 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

dsc09894-dsc09897_exposure_layers_0001.tif: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09895.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 12.275 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

dsc09894-dsc09897_exposure_layers_0002.tif: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09896.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 12.2301 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

dsc09894-dsc09897_exposure_layers_0003.tif: /home/carfield/Public/photo/MyPhoto/Day\ Trip/紅石門/dsc09897.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 12.077 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

$(HDR_STACK_0) : $(HDR_STACK_0_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_0_SHELL) $(HDR_STACK_0_INPUT_SHELL)

$(HDR_STACK_1) : $(HDR_STACK_1_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_1_SHELL) $(HDR_STACK_1_INPUT_SHELL)

$(HDR_STACK_2) : $(HDR_STACK_2_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_2_SHELL) $(HDR_STACK_2_INPUT_SHELL)

$(HDR_STACK_3) : $(HDR_STACK_3_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_3_SHELL) $(HDR_STACK_3_INPUT_SHELL)

$(LDR_STACK_0) : $(LDR_STACK_0_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_0_SHELL) $(LDR_STACK_0_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_0_SHELL)

$(LDR_STACK_1) : $(LDR_STACK_1_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_1_SHELL) $(LDR_STACK_1_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_1_SHELL)

$(LDR_STACK_2) : $(LDR_STACK_2_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_2_SHELL) $(LDR_STACK_2_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_2_SHELL)

$(LDR_STACK_3) : $(LDR_STACK_3_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_3_SHELL) $(LDR_STACK_3_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_3_SHELL)

$(LDR_BLENDED) : $(LDR_LAYERS)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_BLENDED_SHELL) $(LDR_LAYERS_SHELL) 
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_BLENDED_SHELL)

$(LDR_EXPOSURE_LAYER_0) : $(LDR_EXPOSURE_LAYER_0_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_0_SHELL) $(LDR_EXPOSURE_LAYER_0_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_0_SHELL)

$(LDR_EXPOSURE_LAYER_1) : $(LDR_EXPOSURE_LAYER_1_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_1_SHELL) $(LDR_EXPOSURE_LAYER_1_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_1_SHELL)

$(LDR_STACKED_BLENDED) : $(LDR_STACKS)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_STACKED_BLENDED_SHELL) $(LDR_STACKS_SHELL) 
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACKED_BLENDED_SHELL)

$(HDR_BLENDED) : $(HDR_STACKS)
	$(ENBLEND) $(ENBLEND_HDR_COMP) $(ENBLEND_OPTS) -o $(HDR_BLENDED_SHELL) $(HDR_STACKS_SHELL) 

