# makefile for panorama stitching, created by hugin 



# Tool configuration
NONA=nona
PTSTITCHER=PTStitcher
PTMENDER=PTmender
PTBLENDER=PTblender
PTMASKER=PTmasker
PTROLLER=PTroller
ENBLEND=enblend
ENFUSE=enfuse
SMARTBLEND=smartblend.exe
HDRMERGE=hugin_hdrmerge
RM=rm
EXIFTOOL=exiftool

# Project parameters
HUGIN_PROJECTION=1
HUGIN_HFOV=208
HUGIN_WIDTH=1897
HUGIN_HEIGHT=510

# options for the programs

NONA_LDR_REMAPPED_COMP=-z PACKBITS
ENBLEND_OPTS= -f1897x510
ENBLEND_LDR_COMP=--compression NONE
ENBLEND_HDR_COMP=
ENFUSE_OPTS=
EXIFTOOL_COPY_ARGS=-ImageDescription -Make -Model -Artist -WhitePoint -Copyright -GPS:all -DateTimeOriginal -CreateDate -UserComment -ColorSpace -OwnerName -SerialNumber

# the output panorama
LDR_REMAPPED_PREFIX=DSC07395-DSC07398
LDR_REMAPPED_PREFIX_SHELL=DSC07395-DSC07398
HDR_STACK_REMAPPED_PREFIX=DSC07395-DSC07398_hdr_
HDR_STACK_REMAPPED_PREFIX_SHELL=DSC07395-DSC07398_hdr_
LDR_EXPOSURE_REMAPPED_PREFIX=DSC07395-DSC07398_exposure_layers_
LDR_EXPOSURE_REMAPPED_PREFIX_SHELL=DSC07395-DSC07398_exposure_layers_
PROJECT_FILE=/home/carfield/Pictures/new/DSC07395-DSC07398.pto
PROJECT_FILE_SHELL=/home/carfield/Pictures/new/DSC07395-DSC07398.pto
LDR_BLENDED=DSC07395-DSC07398.tif
LDR_BLENDED_SHELL=DSC07395-DSC07398.tif
LDR_STACKED_BLENDED=DSC07395-DSC07398_fused.tif
LDR_STACKED_BLENDED_SHELL=DSC07395-DSC07398_fused.tif
HDR_BLENDED=DSC07395-DSC07398_hdr.exr
HDR_BLENDED_SHELL=DSC07395-DSC07398_hdr.exr

# first input image
INPUT_IMAGE_1=/home/carfield/Pictures/new/DSC07395.jpg
INPUT_IMAGE_1_SHELL=/home/carfield/Pictures/new/DSC07395.jpg
# all input images
INPUT_IMAGES=/home/carfield/Pictures/new/DSC07395.jpg\
/home/carfield/Pictures/new/DSC07396.jpg\
/home/carfield/Pictures/new/DSC07397.jpg\
/home/carfield/Pictures/new/DSC07398.jpg

INPUT_IMAGES_SHELL=/home/carfield/Pictures/new/DSC07395.jpg\
/home/carfield/Pictures/new/DSC07396.jpg\
/home/carfield/Pictures/new/DSC07397.jpg\
/home/carfield/Pictures/new/DSC07398.jpg

# remapped images
LDR_LAYERS=DSC07395-DSC073980000.tif\
DSC07395-DSC073980001.tif\
DSC07395-DSC073980002.tif\
DSC07395-DSC073980003.tif

LDR_LAYERS_SHELL=DSC07395-DSC073980000.tif\
DSC07395-DSC073980001.tif\
DSC07395-DSC073980002.tif\
DSC07395-DSC073980003.tif

# remapped images (hdr)
HDR_LAYERS=DSC07395-DSC07398_hdr_0000.exr\
DSC07395-DSC07398_hdr_0001.exr\
DSC07395-DSC07398_hdr_0002.exr\
DSC07395-DSC07398_hdr_0003.exr

HDR_LAYERS_SHELL=DSC07395-DSC07398_hdr_0000.exr\
DSC07395-DSC07398_hdr_0001.exr\
DSC07395-DSC07398_hdr_0002.exr\
DSC07395-DSC07398_hdr_0003.exr

# remapped maxval images
HDR_LAYERS_WEIGHTS=DSC07395-DSC07398_hdr_0000_gray.pgm \
DSC07395-DSC07398_hdr_0001_gray.pgm \
DSC07395-DSC07398_hdr_0002_gray.pgm \
DSC07395-DSC07398_hdr_0003_gray.pgm 

HDR_LAYERS_WEIGHTS_SHELL=DSC07395-DSC07398_hdr_0000_gray.pgm\
DSC07395-DSC07398_hdr_0001_gray.pgm\
DSC07395-DSC07398_hdr_0002_gray.pgm\
DSC07395-DSC07398_hdr_0003_gray.pgm

# stacked images
HDR_STACKS_NUMBERS = 0 1 2 3 
HDR_STACK_0 = DSC07395-DSC07398_stack_hdr_0000.exr
HDR_STACK_0_SHELL = DSC07395-DSC07398_stack_hdr_0000.exr
HDR_STACK_0_INPUT = DSC07395-DSC07398_hdr_0000.exr

HDR_STACK_0_INPUT_SHELL = DSC07395-DSC07398_hdr_0000.exr

HDR_STACK_1 = DSC07395-DSC07398_stack_hdr_0001.exr
HDR_STACK_1_SHELL = DSC07395-DSC07398_stack_hdr_0001.exr
HDR_STACK_1_INPUT = DSC07395-DSC07398_hdr_0001.exr

HDR_STACK_1_INPUT_SHELL = DSC07395-DSC07398_hdr_0001.exr

HDR_STACK_2 = DSC07395-DSC07398_stack_hdr_0002.exr
HDR_STACK_2_SHELL = DSC07395-DSC07398_stack_hdr_0002.exr
HDR_STACK_2_INPUT = DSC07395-DSC07398_hdr_0002.exr

HDR_STACK_2_INPUT_SHELL = DSC07395-DSC07398_hdr_0002.exr

HDR_STACK_3 = DSC07395-DSC07398_stack_hdr_0003.exr
HDR_STACK_3_SHELL = DSC07395-DSC07398_stack_hdr_0003.exr
HDR_STACK_3_INPUT = DSC07395-DSC07398_hdr_0003.exr

HDR_STACK_3_INPUT_SHELL = DSC07395-DSC07398_hdr_0003.exr


HDR_STACKS = $(HDR_STACK_0) $(HDR_STACK_1) $(HDR_STACK_2) $(HDR_STACK_3) 
HDR_STACKS_SHELL = $(HDR_STACK_0_SHELL) $(HDR_STACK_1_SHELL) $(HDR_STACK_2_SHELL) $(HDR_STACK_3_SHELL) 


# number of image sets with similar exposure
LDR_EXPOSURE_EXPOSURE_LAYERS_NUMBERS = 0 1 2 
LDR_EXPOSURE_LAYER_0 = DSC07395-DSC07398_exposure_00.tif
LDR_EXPOSURE_LAYER_0_SHELL = DSC07395-DSC07398_exposure_00.tif
LDR_EXPOSURE_LAYER_0_INPUT = DSC07395-DSC07398_exposure_layers_0000.tif

LDR_EXPOSURE_LAYER_0_INPUT_SHELL = DSC07395-DSC07398_exposure_layers_0000.tif

LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER = DSC07395-DSC073980000.tif

LDR_EXPOSURE_LAYER_0_INPUT_PTMENDER_SHELL = DSC07395-DSC073980000.tif
LDR_EXPOSURE_LAYER_0_EXPOSURE = 31.8631
LDR_EXPOSURE_LAYER_1 = DSC07395-DSC07398_exposure_01.tif
LDR_EXPOSURE_LAYER_1_SHELL = DSC07395-DSC07398_exposure_01.tif
LDR_EXPOSURE_LAYER_1_INPUT = DSC07395-DSC07398_exposure_layers_0001.tif

LDR_EXPOSURE_LAYER_1_INPUT_SHELL = DSC07395-DSC07398_exposure_layers_0001.tif

LDR_EXPOSURE_LAYER_1_INPUT_PTMENDER = DSC07395-DSC073980001.tif

LDR_EXPOSURE_LAYER_1_INPUT_PTMENDER_SHELL = DSC07395-DSC073980001.tif
LDR_EXPOSURE_LAYER_1_EXPOSURE = 32.9745
LDR_EXPOSURE_LAYER_2 = DSC07395-DSC07398_exposure_02.tif
LDR_EXPOSURE_LAYER_2_SHELL = DSC07395-DSC07398_exposure_02.tif
LDR_EXPOSURE_LAYER_2_INPUT = DSC07395-DSC07398_exposure_layers_0002.tif\
DSC07395-DSC07398_exposure_layers_0003.tif

LDR_EXPOSURE_LAYER_2_INPUT_SHELL = DSC07395-DSC07398_exposure_layers_0002.tif\
DSC07395-DSC07398_exposure_layers_0003.tif

LDR_EXPOSURE_LAYER_2_INPUT_PTMENDER = DSC07395-DSC073980002.tif\
DSC07395-DSC073980003.tif

LDR_EXPOSURE_LAYER_2_INPUT_PTMENDER_SHELL = DSC07395-DSC073980002.tif\
DSC07395-DSC073980003.tif
LDR_EXPOSURE_LAYER_2_EXPOSURE = 33.8916

LDR_EXPOSURE_LAYERS = $(LDR_EXPOSURE_LAYER_0) $(LDR_EXPOSURE_LAYER_1) $(LDR_EXPOSURE_LAYER_2) 
LDR_EXPOSURE_LAYERS_SHELL = $(LDR_EXPOSURE_LAYER_0_SHELL) $(LDR_EXPOSURE_LAYER_1_SHELL) $(LDR_EXPOSURE_LAYER_2_SHELL) 
LDR_EXPOSURE_LAYERS_REMAPPED = DSC07395-DSC07398_exposure_layers_0000.tif\
DSC07395-DSC07398_exposure_layers_0001.tif\
DSC07395-DSC07398_exposure_layers_0002.tif\
DSC07395-DSC07398_exposure_layers_0003.tif

LDR_EXPOSURE_LAYERS_REMAPPED_SHELL = DSC07395-DSC07398_exposure_layers_0000.tif\
DSC07395-DSC07398_exposure_layers_0001.tif\
DSC07395-DSC07398_exposure_layers_0002.tif\
DSC07395-DSC07398_exposure_layers_0003.tif


# stacked images for enfuse or other automatic exposure blending tools
LDR_STACKS_NUMBERS = 0 1 2 3 
LDR_STACK_0 = DSC07395-DSC07398_stack_ldr_0000.tif
LDR_STACK_0_SHELL = DSC07395-DSC07398_stack_ldr_0000.tif
LDR_STACK_0_INPUT = DSC07395-DSC07398_exposure_layers_0000.tif

LDR_STACK_0_INPUT_SHELL = DSC07395-DSC07398_exposure_layers_0000.tif

LDR_STACK_1 = DSC07395-DSC07398_stack_ldr_0001.tif
LDR_STACK_1_SHELL = DSC07395-DSC07398_stack_ldr_0001.tif
LDR_STACK_1_INPUT = DSC07395-DSC07398_exposure_layers_0001.tif

LDR_STACK_1_INPUT_SHELL = DSC07395-DSC07398_exposure_layers_0001.tif

LDR_STACK_2 = DSC07395-DSC07398_stack_ldr_0002.tif
LDR_STACK_2_SHELL = DSC07395-DSC07398_stack_ldr_0002.tif
LDR_STACK_2_INPUT = DSC07395-DSC07398_exposure_layers_0002.tif

LDR_STACK_2_INPUT_SHELL = DSC07395-DSC07398_exposure_layers_0002.tif

LDR_STACK_3 = DSC07395-DSC07398_stack_ldr_0003.tif
LDR_STACK_3_SHELL = DSC07395-DSC07398_stack_ldr_0003.tif
LDR_STACK_3_INPUT = DSC07395-DSC07398_exposure_layers_0003.tif

LDR_STACK_3_INPUT_SHELL = DSC07395-DSC07398_exposure_layers_0003.tif


LDR_STACKS = $(LDR_STACK_0) $(LDR_STACK_1) $(LDR_STACK_2) $(LDR_STACK_3) 
LDR_STACKS_SHELL = $(LDR_STACK_0_SHELL) $(LDR_STACK_1_SHELL) $(LDR_STACK_2_SHELL) $(LDR_STACK_3_SHELL) 
DO_LDR_BLENDED = 1
TEMP_FILES_SHELL = $(LDR_LAYERS_SHELL) 

all: $(LDR_BLENDED) 

clean: 
	-$(RM) $(TEMP_FILES_SHELL)

test: 
	@echo -n 'Checking nona...'
	@-$(NONA) --help > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking enblend...'
	@-$(ENBLEND) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking enfuse...'
	@-$(ENFUSE) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking hugin_hdrmerge...'
	@-$(HDRMERGE) -h > /dev/null 2>&1 && echo '[OK]'
	@echo -n 'Checking exiftool...'
	@-$(EXIFTOOL) -ver > /dev/null 2>&1 && echo '[OK]' || echo '[FAIL]'

# Rules for ordinary TIFF_m output
DSC07395-DSC073980000.tif: /home/carfield/Pictures/new/DSC07395.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

DSC07395-DSC073980001.tif: /home/carfield/Pictures/new/DSC07396.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

DSC07395-DSC073980002.tif: /home/carfield/Pictures/new/DSC07397.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

DSC07395-DSC073980003.tif: /home/carfield/Pictures/new/DSC07398.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -m TIFF_m -o $(LDR_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

# Rules for merge to hdr output
DSC07395-DSC07398_hdr_0000.exr: /home/carfield/Pictures/new/DSC07395.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

DSC07395-DSC07398_hdr_0001.exr: /home/carfield/Pictures/new/DSC07396.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

DSC07395-DSC07398_hdr_0002.exr: /home/carfield/Pictures/new/DSC07397.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

DSC07395-DSC07398_hdr_0003.exr: /home/carfield/Pictures/new/DSC07398.jpg $(PROJECT_FILE)
	$(NONA) -r hdr -m EXR_m -o $(HDR_STACK_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

# Rules for exposure layer output
DSC07395-DSC07398_exposure_layers_0000.tif: /home/carfield/Pictures/new/DSC07395.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 15.9316 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 0 $(PROJECT_FILE_SHELL)

DSC07395-DSC07398_exposure_layers_0001.tif: /home/carfield/Pictures/new/DSC07396.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 16.4872 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 1 $(PROJECT_FILE_SHELL)

DSC07395-DSC07398_exposure_layers_0002.tif: /home/carfield/Pictures/new/DSC07397.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 16.8912 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 2 $(PROJECT_FILE_SHELL)

DSC07395-DSC07398_exposure_layers_0003.tif: /home/carfield/Pictures/new/DSC07398.jpg $(PROJECT_FILE)
	$(NONA) $(NONA_LDR_REMAPPED_COMP) -r ldr -e 17.0004 -m TIFF_m -o $(LDR_EXPOSURE_REMAPPED_PREFIX_SHELL) -i 3 $(PROJECT_FILE_SHELL)

$(HDR_STACK_0) : $(HDR_STACK_0_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_0_SHELL) $(HDR_STACK_0_INPUT_SHELL)

$(HDR_STACK_1) : $(HDR_STACK_1_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_1_SHELL) $(HDR_STACK_1_INPUT_SHELL)

$(HDR_STACK_2) : $(HDR_STACK_2_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_2_SHELL) $(HDR_STACK_2_INPUT_SHELL)

$(HDR_STACK_3) : $(HDR_STACK_3_INPUT)
	$(HDRMERGE) -m avg -c -o $(HDR_STACK_3_SHELL) $(HDR_STACK_3_INPUT_SHELL)

$(LDR_STACK_0) : $(LDR_STACK_0_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_0_SHELL) $(LDR_STACK_0_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_0_SHELL)

$(LDR_STACK_1) : $(LDR_STACK_1_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_1_SHELL) $(LDR_STACK_1_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_1_SHELL)

$(LDR_STACK_2) : $(LDR_STACK_2_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_2_SHELL) $(LDR_STACK_2_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_2_SHELL)

$(LDR_STACK_3) : $(LDR_STACK_3_INPUT)
	$(ENFUSE) $(ENFUSE_OPTS) -o $(LDR_STACK_3_SHELL) $(LDR_STACK_3_INPUT_SHELL)
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACK_3_SHELL)

$(LDR_BLENDED) : $(LDR_LAYERS)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_BLENDED_SHELL) $(LDR_LAYERS_SHELL) 
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_BLENDED_SHELL)

$(LDR_EXPOSURE_LAYER_0) : $(LDR_EXPOSURE_LAYER_0_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_0_SHELL) $(LDR_EXPOSURE_LAYER_0_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_0_SHELL)

$(LDR_EXPOSURE_LAYER_1) : $(LDR_EXPOSURE_LAYER_1_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_1_SHELL) $(LDR_EXPOSURE_LAYER_1_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_1_SHELL)

$(LDR_EXPOSURE_LAYER_2) : $(LDR_EXPOSURE_LAYER_2_INPUT)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_EXPOSURE_LAYER_2_SHELL) $(LDR_EXPOSURE_LAYER_2_INPUT_SHELL)
	-$(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_EXPOSURE_LAYER_2_SHELL)

$(LDR_STACKED_BLENDED) : $(LDR_STACKS)
	$(ENBLEND) $(ENBLEND_LDR_COMP) $(ENBLEND_OPTS) -o $(LDR_STACKED_BLENDED_SHELL) $(LDR_STACKS_SHELL) 
	- $(EXIFTOOL) -overwrite_original_in_place -TagsFromFile $(INPUT_IMAGE_1_SHELL) $(EXIFTOOL_COPY_ARGS) $(LDR_STACKED_BLENDED_SHELL)

$(HDR_BLENDED) : $(HDR_STACKS)
	$(ENBLEND) $(ENBLEND_HDR_COMP) $(ENBLEND_OPTS) -o $(HDR_BLENDED_SHELL) $(HDR_STACKS_SHELL) 

